package com.xunlei.niux.data.vipgame.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import org.springframework.jdbc.core.RowCallbackHandler;

import com.ferret.common.dao.BaseDaoImpl;
import com.xunlei.common.util.StringTools;
import com.xunlei.niux.data.vipgame.dto.BonusChargeDTO;

public class BonusChargeDaoImpl extends BaseDaoImpl implements BonusChargeDao {

	@Override
	public List<BonusChargeDTO> getBonusChargeList(
			BonusChargeDTO query, int pageNo, int pageSize) {
		List<Object> list = new ArrayList<Object>();      
		
		StringBuffer sql = new StringBuffer();
		sql.append("select b.seqId , productId, giftName, giftType, totalCount, exchangeCount, usedCount, leftCount, content, bonus, b.isValid, inputTime, inputBy, valdateTime, picUrl, smallPicUrl, orderNum, firstLetter " +
				"from bonusproductcharge b left join gift g on b.productId = g.giftId where 1=1 \n");

		handleParamter(query, sql, list);
    	
        sql.append(" order by inputTime desc limit ?,?");
        list.add((pageNo-1)*pageSize);
	    list.add(pageSize);
		
      final List<BonusChargeDTO> bonusChargeList = new ArrayList<BonusChargeDTO>();
      getJdbcTemplate().query(sql.toString(), list.toArray(), new RowCallbackHandler() {
          @Override
          public void processRow(ResultSet resultSet) throws SQLException {
        	  BonusChargeDTO bonusCharge = new BonusChargeDTO();
        	  
        	  bonusCharge.setSeqId(resultSet.getLong("seqId"));
        	  bonusCharge.setProductId(resultSet.getString("productId"));
        	  bonusCharge.setBonus(resultSet.getLong("bonus"));
        	  bonusCharge.setGiftName(resultSet.getString("giftName"));
        	  bonusCharge.setGiftType(resultSet.getString("giftType"));
        	  bonusCharge.setContent(resultSet.getString("content"));
        	  bonusCharge.setTotalCount(resultSet.getLong("totalCount"));
        	  bonusCharge.setExchangeCount(resultSet.getLong("exchangeCount"));
        	  bonusCharge.setUsedCount(resultSet.getLong("usedCount"));
        	  bonusCharge.setLeftCount(resultSet.getLong("leftCount"));
        	  bonusCharge.setIsValid(resultSet.getBoolean("isValid"));
        	  bonusCharge.setInputTime(resultSet.getString("inputTime"));
        	  bonusCharge.setInputBy(resultSet.getString("inputBy"));
        	  bonusCharge.setValdateTime(resultSet.getString("valdateTime"));
        	  bonusCharge.setPicUrl(resultSet.getString("picUrl"));
        	  bonusCharge.setSmallPicUrl(resultSet.getString("smallPicUrl"));
        	  bonusCharge.setOrderNum(Integer.parseInt(resultSet.getString("orderNum")));
        	  bonusCharge.setFirstLetter(resultSet.getString("firstLetter"));
        	  bonusChargeList.add(bonusCharge);
          }
      });
      return bonusChargeList;
	}
	
	@Override
	public int getCount(BonusChargeDTO query){
		List<Object> list = new ArrayList<Object>();  
		
		StringBuffer sql = new StringBuffer();
		sql.append("select count(*) as count " +
				"from bonusproductcharge b left join gift g on b.productId = g.giftId where 1=1 \n");

		handleParamter(query, sql, list);
      
		int counts = getJdbcTemplate().queryForInt(sql.toString(), list.toArray());
      
		return counts;
	}
	
	private void handleParamter(BonusChargeDTO query, StringBuffer sql, List<Object> list){
		String productId = query.getProductId();
    	if(StringTools.isNotEmpty(productId)){
    		sql.append(" and  productId= ?");
    		list.add(productId);
    	}
    	
    	String giftName = query.getGiftName();
    	if(StringTools.isNotEmpty(giftName)){
    		sql.append(" and  g.giftName= ?");
    		list.add(giftName);
    	}
    	
    	String giftType = query.getGiftType();
    	if(StringTools.isNotEmpty(giftType)){
    		sql.append(" and  g.giftType= ?");
    		list.add(giftType);
    	}
    	
		
	}
	

}
