/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.data.vipgame.bo.vic;

import com.ferret.common.dao.BaseDao;
import com.xunlei.niux.data.vipgame.bo.vic.RebateReportBo;
import com.xunlei.niux.data.vipgame.dto.vic.RebateReportGameDTO;
import com.xunlei.niux.data.vipgame.dto.vic.RebateReportOldGameDTO;
import com.xunlei.niux.data.vipgame.dto.vic.RebateReportPersonDTO;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class RebateReportBoImpl
implements RebateReportBo {
    private BaseDao baseDao;

    public BaseDao getBaseDao() {
        return this.baseDao;
    }

    public void setBaseDao(BaseDao baseDao) {
        this.baseDao = baseDao;
    }

    @Override
    public List<RebateReportPersonDTO> queryRebateReportPersonByDate(String startDate, String endDate) {
        String sql = "SELECT k.person, a.finished, k.kpi, a.finished/k.kpi*100 AS kpirate FROM \n (SELECT r.person AS person , SUM(r.money) AS finished FROM vic_rebate_report_data r \n WHERE r.reportdate>=? AND r.reportdate<=? GROUP BY r.person) AS a \n right JOIN vic_kpi_person k ON a.person=k.person WHERE k.kpidate=? ";
        ArrayList<String> params = new ArrayList<String>();
        params.add(startDate);
        params.add(endDate);
        params.add(endDate.substring(0, 7));
        return this.baseDao.findBySql(RebateReportPersonDTO.class, sql, params);
    }

    @Override
    public List<RebateReportGameDTO> queryRebateReportGameByDate(String startDate, String endDate) {
        String sql = "SELECT k.gameid, a.finished, k.kpi, a.finished/k.kpi*100 AS kpirate, 0.0 AS payrate FROM \n (SELECT r.gameid AS gameid , SUM(r.money) AS finished FROM vic_rebate_report_data r \n WHERE r.reportdate>=? AND r.reportdate<=? GROUP BY r.gameid) AS a \n right JOIN vic_kpi_game k ON a.gameid=k.gameid WHERE k.kpidate=? ";
        ArrayList<String> params = new ArrayList<String>();
        params.add(startDate);
        params.add(endDate);
        params.add(endDate.substring(0, 7));
        return this.baseDao.findBySql(RebateReportGameDTO.class, sql, params);
    }

    @Override
    public List<RebateReportOldGameDTO> queryRebateReportOldGameByDate(String startDate, String endDate) {
        String sql = "SELECT a.person,b.money AS finished,a.kpi AS kpitotal,b.money/a.kpi*100 AS kpirate FROM \n (SELECT c.person,SUM(c.kpi) AS kpi FROM vic_rebate_report_old_game_config c GROUP BY c.person ) a \n LEFT JOIN \n (SELECT person, SUM(money) AS money FROM vic_rebate_report_data d \n WHERE EXISTS (SELECT 1 FROM vic_rebate_report_old_game_config c WHERE c.gameid=d.gameid AND c.person=d.person) AND d.reportdate>=? AND d.reportdate<=? \n GROUP BY d.person) b \n ON a.person=b.person ";
        ArrayList<String> params = new ArrayList<String>();
        params.add(startDate);
        params.add(endDate);
        return this.baseDao.findBySql(RebateReportOldGameDTO.class, sql, params);
    }
}

