/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.data.vipgame.bo.bonus;

import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.common.exception.NiuRuntimeException;
import com.xunlei.niux.data.vipgame.bo.BonusProductBo;
import com.xunlei.niux.data.vipgame.bo.bonus.BonusExchangeBo;
import com.xunlei.niux.data.vipgame.bo.bonus.BonusProductGiveOutDayStatisticsBo;
import com.xunlei.niux.data.vipgame.bt.bonus.BonusProductBT;
import com.xunlei.niux.data.vipgame.vo.BonusProduct;
import com.xunlei.niux.data.vipgame.vo.bonus.BonusExchange;
import com.xunlei.niux.data.vipgame.vo.bonus.BonusProductCharge;
import com.xunlei.niux.data.vipgame.vo.bonus.BonusProductChargeRecord;
import com.xunlei.niux.easyutils.commonutils.OrderNoUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BonusExchangeBoImpl
implements BonusExchangeBo {
    private static SimpleDateFormat sdfShort = new SimpleDateFormat("yyyy-MM-dd");
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    @Resource(name="BaseDao")
    private BaseDao baseDao;
    @Autowired
    private BonusProductBo bonusProductBo;
    @Autowired
    private BonusProductGiveOutDayStatisticsBo bonusProductGiveOutDayStatisticsBo;

    public BaseDao getBaseDao() {
        return this.baseDao;
    }

    public void setBaseDao(BaseDao baseDao) {
        this.baseDao = baseDao;
    }

    public BonusProductBo getBonusProductBo() {
        return this.bonusProductBo;
    }

    public void setBonusProductBo(BonusProductBo bonusProductBo) {
        this.bonusProductBo = bonusProductBo;
    }

    public BonusProductGiveOutDayStatisticsBo getBonusProductGiveOutDayStatisticsBo() {
        return this.bonusProductGiveOutDayStatisticsBo;
    }

    public void setBonusProductGiveOutDayStatisticsBo(BonusProductGiveOutDayStatisticsBo bonusProductGiveOutDayStatisticsBo) {
        this.bonusProductGiveOutDayStatisticsBo = bonusProductGiveOutDayStatisticsBo;
    }

    @Override
    public BonusExchange insert(BonusExchange exchange) {
        Date now = new Date();
        BonusProduct bonusProduct = this.bonusProductBo.update_consume(exchange.getProductNo());
        this.checkUserCanExchange(exchange.getUserId(), now, bonusProduct);
        BonusProductBT.checkProductDayEnough(bonusProduct.getProductNo(), sdfShort.format(now), bonusProduct.getEverydayMaxNum());
        this.bonusProductGiveOutDayStatisticsBo.update_addOne(bonusProduct.getProductNo(), sdfShort.format(now));
        BonusExchange bonusExchange = new BonusExchange();
        bonusExchange.setBalanceDate(sdfShort.format(now));
        bonusExchange.setBonusNum(exchange.getBonusNum());
        bonusExchange.setExchangeDirect(exchange.getExchangeDirect());
        bonusExchange.setExchangeStatus("0");
        bonusExchange.setExchangeTime(sdf.format(now));
        bonusExchange.setGameId(bonusProduct.getGameId());
        bonusExchange.setProductLot(bonusProduct.getProductLot());
        bonusExchange.setProductName(bonusProduct.getProductName());
        bonusExchange.setProductNo(bonusProduct.getProductNo());
        bonusExchange.setProductType(bonusProduct.getProductType());
        bonusExchange.setProductUnit(bonusProduct.getProductUnit());
        bonusExchange.setProductNum(exchange.getProductNum());
        bonusExchange.setRemark(exchange.getRemark());
        bonusExchange.setSerialNumber("");
        bonusExchange.setServerId(exchange.getServerId());
        bonusExchange.setUserId(exchange.getUserId());
        bonusExchange.setUserName(exchange.getUserName());
        bonusExchange.setExchangeNo(OrderNoUtil.getOrderNo());
        bonusExchange.setExchangeStatusUpdateTime(sdf.format(now));
        bonusExchange.setFailCause("");
        bonusExchange.setExchangePlatform(exchange.getExchangePlatform());
        bonusExchange.setExchangeIp(exchange.getExchangeIp());
        bonusExchange.setRoleId(exchange.getRoleId());
        this.baseDao.insert((Object)bonusExchange);
        return this.findOne(bonusExchange.getExchangeNo());
    }

    @Override
    public BonusExchange updateKouChuProductResult(BonusExchange exchange, boolean isSuccess) {
        BonusExchange bonusExchange = (BonusExchange)this.baseDao.findById(BonusExchange.class, (Number)exchange.getSeqId());
        if (!"0".equals(bonusExchange.getExchangeStatus())) {
            throw new NiuRuntimeException("99", "\u5151\u6362\u8ba2\u5355[" + bonusExchange.getExchangeNo() + "]\u4e0d\u5b58\u4e8e\u79ef\u5206\u6263\u9664\u9636\u6bb5");
        }
        if (!isSuccess) {
            this.bonusProductBo.update_rechargefailconsum(bonusExchange.getProductNo());
            this.bonusProductGiveOutDayStatisticsBo.update_removeOne(bonusExchange.getProductNo(), bonusExchange.getBalanceDate());
        }
        Date now = new Date();
        bonusExchange.setRemark(exchange.getRemark());
        bonusExchange.setFailCause(exchange.getFailCause());
        bonusExchange.setExchangeStatusUpdateTime(sdf.format(now));
        String nextExchangeStatus = isSuccess ? "1" : "3";
        bonusExchange.setExchangeStatus(nextExchangeStatus);
        this.baseDao.updateById((Object)bonusExchange);
        return bonusExchange;
    }

    @Override
    public BonusExchange updateExchangeProductResult(BonusExchange exchange, boolean isSuccess) {
        BonusExchange bonusExchange = (BonusExchange)this.baseDao.findById(BonusExchange.class, (Number)exchange.getSeqId());
        if (!"1".equals(bonusExchange.getExchangeStatus())) {
            throw new NiuRuntimeException("99", "\u5151\u6362\u8ba2\u5355[" + bonusExchange.getExchangeNo() + "]\u4e0d\u5b58\u4e8e\u53d1\u653e\u5151\u6362\u54c1\u9636\u6bb5");
        }
        if (!isSuccess && "11".equals(bonusExchange.getExchangeDirect())) {
            return bonusExchange;
        }
        if (!isSuccess) {
            this.bonusProductBo.update_rechargefailconsum(bonusExchange.getProductNo());
            this.bonusProductGiveOutDayStatisticsBo.update_removeOne(bonusExchange.getProductNo(), bonusExchange.getBalanceDate());
        }
        Date now = new Date();
        bonusExchange.setRemark(exchange.getRemark());
        bonusExchange.setFailCause(exchange.getFailCause());
        bonusExchange.setExchangeStatusUpdateTime(sdf.format(now));
        bonusExchange.setSerialNumber(exchange.getSerialNumber());
        String nextExchangeStatus = isSuccess ? "2" : "4";
        bonusExchange.setExchangeStatus(nextExchangeStatus);
        this.baseDao.updateById((Object)bonusExchange);
        return bonusExchange;
    }

    @Override
    public BonusExchange updateReturnProductResult(BonusExchange exchange, boolean isSuccess) {
        BonusExchange bonusExchange = (BonusExchange)this.baseDao.findById(BonusExchange.class, (Number)exchange.getSeqId());
        if (!isSuccess) {
            return bonusExchange;
        }
        if (!"4".equals(bonusExchange.getExchangeStatus())) {
            throw new NiuRuntimeException("99", "\u5151\u6362\u8ba2\u5355[" + bonusExchange.getExchangeNo() + "]\u4e0d\u5b58\u4e8e\u9000\u8fd8\u4ea7\u54c1\u9636\u6bb5");
        }
        bonusExchange.setExchangeStatus("3");
        this.baseDao.updateById((Object)bonusExchange);
        return bonusExchange;
    }

    @Override
    public void checkUserCanExchange(String userId, Date date, BonusProduct bonusProduct) {
        this.checkUserTodayCanExchange(userId, date, bonusProduct);
        this.checkUserExceedRestrictCanExchange(userId, date, bonusProduct);
    }

    private void checkUserTodayCanExchange(String userId, Date date, BonusProduct bonusProduct) {
        if (bonusProduct.getUserEverydayMaxNum() == null || bonusProduct.getUserEverydayMaxNum() <= 0) {
            return;
        }
        BonusExchange query = new BonusExchange();
        query.setUserId(userId);
        query.setProductNo(bonusProduct.getProductNo());
        query.setToExchangeStatus("3");
        query.setBalanceDate(sdfShort.format(date));
        int count = this.baseDao.count((Object)query);
        if (count < bonusProduct.getUserEverydayMaxNum()) {
            return;
        }
        throw new NiuRuntimeException("1040", "\u8fbe\u5230\u5355\u4e2a\u7528\u6237\u9886\u53d6\u6700\u5927\u9650\u989d");
    }

    private void checkUserExceedRestrictCanExchange(String userId, Date date, BonusProduct bonusProduct) {
        int count;
        if (bonusProduct.getUserRestrictMaxNum() == null || bonusProduct.getUserRestrictMaxNum() <= 0) {
            return;
        }
        Date restrictDate = null;
        if (bonusProduct.getRestrictDays() != null && bonusProduct.getRestrictDays() > 0) {
            restrictDate = new Date(date.getTime() - 86400000L * (long)(bonusProduct.getRestrictDays() - 1));
        }
        BonusExchange query = new BonusExchange();
        query.setUserId(userId);
        query.setProductNo(bonusProduct.getProductNo());
        query.setToExchangeStatus("3");
        if (restrictDate != null) {
            query.setFromBalanceDate(sdfShort.format(restrictDate));
        }
        if ((count = this.baseDao.count((Object)query)) < bonusProduct.getUserRestrictMaxNum()) {
            return;
        }
        throw new NiuRuntimeException("1041", "\u8fbe\u5230\u5355\u4e2a\u7528\u6237\u5468\u671f\uff08" + bonusProduct.getUserRestrictMaxNum() + "\u5929\uff09\u9886\u53d6\u6700\u5927\u9650\u989d");
    }

    @Override
    public int count(BonusExchange exchange) {
        return this.baseDao.count((Object)exchange);
    }

    public BonusExchange findOne(String orderNo) {
        BonusExchange query = new BonusExchange();
        query.setExchangeNo(orderNo);
        Page page = new Page();
        page.setPageNo(1);
        page.setPageSize(1);
        List list = this.baseDao.findByObject(BonusExchange.class, (Object)query, page);
        return list == null || list.size() == 0 ? null : (BonusExchange)list.get(0);
    }

    @Override
    public List<BonusExchange> finds(BonusExchange bonusExchange, Page page) {
        return this.baseDao.findByObject(BonusExchange.class, (Object)bonusExchange, page);
    }

    @Override
    public BonusProductChargeRecord insert(BonusProductCharge exchange, long userId, String ip) {
        BonusProductCharge bpc = this.bonusProductBo.updateProductLeftCount(exchange.getProductId(), true);
        return this.addProductChargeRecord(bpc, userId, ip);
    }

    @Override
    public void update(BonusProductCharge exchange, boolean flag) {
        this.bonusProductBo.updateProductLeftCount(exchange.getProductId(), flag);
    }

    private BonusProductChargeRecord addProductChargeRecord(BonusProductCharge bpc, long userId, String ip) {
        BonusProductChargeRecord record = new BonusProductChargeRecord();
        record.setBonus(bpc.getBonus());
        record.setChargeFlag(1);
        record.setProductId(bpc.getProductId());
        record.setRecordTime(sdf.format(new Date()));
        record.setUserId(userId);
        record.setIp(ip);
        this.baseDao.insert((Object)record);
        return record;
    }
}

