/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.data.vipgame.bo;

import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.bo.LinkInfoBo;
import com.xunlei.niux.data.vipgame.enums.game.GameClientTypeEnum;
import com.xunlei.niux.data.vipgame.vo.LinkInfo;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class LinkInfoBoImpl
implements LinkInfoBo {
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private BaseDao baseDao;

    public BaseDao getBaseDao() {
        return this.baseDao;
    }

    public void setBaseDao(BaseDao baseDao) {
        this.baseDao = baseDao;
    }

    @Override
    public int count(LinkInfo linkInfo) {
        return this.baseDao.count((Object)linkInfo);
    }

    @Override
    public void delete(Integer linkid) {
        this.baseDao.deleteById(LinkInfo.class, (Number)linkid);
    }

    @Override
    public List<LinkInfo> find(LinkInfo linkInfo) {
        return this.baseDao.findByObject(LinkInfo.class, (Object)linkInfo, new Page());
    }

    @Override
    public LinkInfo find(Integer linkid) {
        return (LinkInfo)this.baseDao.findById(LinkInfo.class, (Number)linkid);
    }

    @Override
    public void update(LinkInfo linkInfo) {
        linkInfo = this.formatNull(linkInfo);
        this.baseDao.updateById((Object)linkInfo);
    }

    @Override
    public void add(LinkInfo linkInfo) {
        linkInfo = this.formatNull(linkInfo);
        linkInfo.setEditby(linkInfo.getInputby());
        linkInfo.setEdittime(linkInfo.getInputtime());
        this.baseDao.insert((Object)linkInfo);
    }

    @Override
    public List<LinkInfo> find(LinkInfo linkInfo, Page page) {
        return this.baseDao.findByObject(LinkInfo.class, (Object)linkInfo, page);
    }

    @Override
    public List<LinkInfo> getValidteLinkInfoListByLinkLocId(String linkLocid, int rownum, boolean isQueryTestData) {
        if (linkLocid == null || "".equals(linkLocid)) {
            return new ArrayList<LinkInfo>();
        }
        String now = sdf.format(new Date());
        LinkInfo qli = new LinkInfo();
        qli.setLinklocid(linkLocid);
        qli.setTovaliddatetime(now);
        if (!isQueryTestData) {
            qli.setIstest(false);
        }
        Page page = new Page();
        page.setPageNo(1);
        page.setPageSize(rownum);
        page.addOrder("validdatetime", OrderType.DESC);
        page.addOrder("displayorder", OrderType.DESC);
        return this.baseDao.findByObject(LinkInfo.class, (Object)qli, page);
    }

    @Override
    public LinkInfo getValidteLinkInfoByLinkLocId(String linkLocid, boolean isQueryTestData) {
        if (linkLocid == null || "".equals(linkLocid)) {
            return null;
        }
        String now = sdf.format(new Date());
        LinkInfo qli = new LinkInfo();
        qli.setLinklocid(linkLocid);
        qli.setTovaliddatetime(now);
        if (!isQueryTestData) {
            qli.setIstest(false);
        }
        Page page = new Page();
        page.setPageNo(1);
        page.setPageSize(1);
        page.addOrder("validdatetime", OrderType.DESC);
        page.addOrder("displayorder", OrderType.DESC);
        List list = this.baseDao.findByObject(LinkInfo.class, (Object)qli, page);
        return list != null && list.size() > 0 ? (LinkInfo)list.get(0) : null;
    }

    @Override
    public LinkInfo getValidteLinkInfoByLinkLocId_V2(String linkLocid, boolean isQueryTestData) {
        List<LinkInfo> list = this.getValidteLinkInfoListByLinkLocId_V2(linkLocid, 1, isQueryTestData);
        return list != null && list.size() > 0 ? list.get(0) : null;
    }

    @Override
    public List<LinkInfo> getGameValidteLinkInfoListByLinkLocId(String linkLocid, String gameId, int rownum, boolean isQueryTestData) {
        if (linkLocid == null || "".equals(linkLocid)) {
            return new ArrayList<LinkInfo>();
        }
        if (gameId == null || "".equals(gameId)) {
            return new ArrayList<LinkInfo>();
        }
        String now = sdf.format(new Date());
        LinkInfo qli = new LinkInfo();
        qli.setGameid(gameId);
        qli.setLinklocid(linkLocid);
        qli.setTovaliddatetime(now);
        if (!isQueryTestData) {
            qli.setIstest(false);
        }
        Page page = new Page();
        page.setPageNo(1);
        page.setPageSize(rownum);
        page.addOrder("validdatetime", OrderType.DESC);
        page.addOrder("displayorder", OrderType.DESC);
        return this.baseDao.findByObject(LinkInfo.class, (Object)qli, page);
    }

    @Override
    public List<LinkInfo> getLinkInfoByLinkLocIdandTime(String linkLocid, String fromvaliddatetime, String tovaliddatetime, boolean isQueryTestData) {
        if (linkLocid == null || "".equals(linkLocid)) {
            return new ArrayList<LinkInfo>();
        }
        LinkInfo qli = new LinkInfo();
        qli.setLinklocid(linkLocid);
        qli.setFromvaliddatetime(fromvaliddatetime);
        qli.setTovaliddatetime(tovaliddatetime);
        if (!isQueryTestData) {
            qli.setIstest(false);
        }
        Page page = new Page();
        page.setPageNo(0);
        page.setPageSize(0);
        page.addOrder("validdatetime", OrderType.DESC);
        return this.baseDao.findByObject(LinkInfo.class, (Object)qli, page);
    }

    @Override
    public LinkInfo getGameValidteLinkInfoByLinkLocId(String linkLocid, String gameId, boolean isQueryTestData) {
        if (linkLocid == null || "".equals(linkLocid)) {
            return null;
        }
        if (gameId == null || "".equals(gameId)) {
            return null;
        }
        String now = sdf.format(new Date());
        LinkInfo qli = new LinkInfo();
        qli.setLinklocid(linkLocid);
        qli.setGameid(gameId);
        qli.setTovaliddatetime(now);
        if (!isQueryTestData) {
            qli.setIstest(false);
        }
        Page page = new Page();
        page.setPageNo(1);
        page.setPageSize(1);
        page.addOrder("validdatetime", OrderType.DESC);
        page.addOrder("displayorder", OrderType.DESC);
        List list = this.baseDao.findByObject(LinkInfo.class, (Object)qli, page);
        return list != null && list.size() > 0 ? (LinkInfo)list.get(0) : null;
    }

    @Override
    public LinkInfo getGameValidteLinkInfoByLinkLocId_v2(String linkLocid, String gameId, boolean isQueryTestData) {
        List<LinkInfo> list = this.getGameValidteLinkInfoListByLinkLocId_v2(linkLocid, gameId, 1, isQueryTestData);
        return list == null || list.size() == 0 ? null : list.get(0);
    }

    @Override
    public List<LinkInfo> getGameValidteLinkInfoListByLinkLocId_v2(String linkLocid, String gameId, int rownum, boolean isQueryTestData) {
        LinkInfo li = new LinkInfo();
        li.setLinklocid(linkLocid);
        li.setGameid(gameId);
        li.setTovaliddatetime(sdf.format(new Date()));
        if (!isQueryTestData) {
            li.setIstest(false);
        }
        li.setIsvalid(true);
        Page page = new Page();
        page.setPageNo(1);
        page.setPageSize(rownum);
        page.addOrder("displaysort", OrderType.ESC);
        page.addOrder("validdatetime", OrderType.DESC);
        return this.baseDao.findByObject(LinkInfo.class, (Object)li, page);
    }

    public LinkInfo formatNull(LinkInfo linkInfo) {
        if (linkInfo == null) {
            return null;
        }
        linkInfo.setDisplayorder(this.defaultReplaceNull(linkInfo.getDisplayorder()));
        linkInfo.setExt1(this.defaultReplaceNull(linkInfo.getExt1()));
        linkInfo.setExt2(this.defaultReplaceNull(linkInfo.getExt2()));
        linkInfo.setExt3(this.defaultReplaceNull(linkInfo.getExt3()));
        linkInfo.setGameid(this.defaultReplaceNull(linkInfo.getGameid()));
        linkInfo.setGameidbytuijian(this.defaultReplaceNull(linkInfo.getGameidbytuijian()));
        linkInfo.setLinktitle(this.defaultReplaceNull(linkInfo.getLinktitle()));
        linkInfo.setSmallpicurl(this.defaultReplaceNull(linkInfo.getSmallpicurl()));
        linkInfo.setPicurl(this.defaultReplaceNull(linkInfo.getPicurl()));
        linkInfo.setLinkurl(this.defaultReplaceNull(linkInfo.getLinkurl()));
        linkInfo.setLinkdesc(this.defaultReplaceNull(linkInfo.getLinkdesc()));
        return linkInfo;
    }

    public String defaultReplaceNull(String value) {
        return value == null ? "" : value;
    }

    @Override
    public List<LinkInfo> getValidteLinkInfoListByLinkLocId_V2(String linkLocid, int rownum, boolean isQueryTestData) {
        return this.getValidteLinkInfoListByLinkLocId_V2(linkLocid, rownum, isQueryTestData, 1);
    }

    @Override
    public List<LinkInfo> getValidteLinkInfoListByLinkLocId_V2(String linkLocid, int rownum, boolean isQueryTestData, int isvalid) {
        if (linkLocid == null || "".equals(linkLocid)) {
            return new ArrayList<LinkInfo>();
        }
        String now = sdf.format(new Date());
        LinkInfo qli = new LinkInfo();
        qli.setLinklocid(linkLocid);
        qli.setTovaliddatetime(now);
        if (!isQueryTestData) {
            qli.setIstest(false);
        }
        if (isvalid > 0) {
            qli.setIsvalid(true);
        }
        Page page = new Page();
        page.setPageNo(1);
        page.setPageSize(rownum);
        page.addOrder("displaysort", OrderType.DESC);
        page.addOrder("validdatetime", OrderType.DESC);
        return this.baseDao.findByObject(LinkInfo.class, (Object)qli, page);
    }

    @Override
    public List<LinkInfo> getLinkListByOrderByLimit(String linkLocid, String orderColumn, OrderType orderType, boolean isQueryTestData) {
        return this.getLinkListByOrderByLimit(linkLocid, 0, orderColumn, orderType, isQueryTestData);
    }

    @Override
    public List<LinkInfo> getAllLinkListByLinkLocId(String linkLocId, boolean isQueryTestData) {
        return this.getLinkListByOrderByLimit(linkLocId, 0, "", OrderType.DESC, isQueryTestData);
    }

    @Override
    public List<LinkInfo> getLinkListByOrderByLimit(String linkLocid, int limit, String orderColumn, OrderType orderType, boolean isQueryTestData) {
        return this.getLinkListByOrderByLimit(linkLocid, limit, orderColumn, orderType, false, isQueryTestData);
    }

    @Override
    public List<LinkInfo> getLinkListByOrderByLimit(String linkLocid, int limit, String orderColumn, OrderType orderType, boolean isValid, boolean isQueryTestData) {
        LinkInfo li = new LinkInfo();
        li.setLinklocid(linkLocid);
        if (!isQueryTestData) {
            li.setIstest(false);
        }
        if (isValid) {
            li.setIsvalid(true);
        }
        Page page = new Page();
        if (limit > 0) {
            page.setPageNo(1);
            page.setPageSize(limit);
        }
        if (StringUtils.isNotEmpty((String)orderColumn)) {
            page.addOrder(orderColumn, orderType);
        }
        return this.baseDao.findByObject(LinkInfo.class, (Object)li, page);
    }

    @Override
    public List<LinkInfo> getHotShouyouGiftList(int limit) {
        return this.getGiftListByClientTypeWithOrderByColumnDesc(GameClientTypeEnum.shouyou, "displaysort", limit);
    }

    @Override
    public List<LinkInfo> getGiftListByClientTypeWithOrderByColumnDesc(GameClientTypeEnum clientTypeEnum, String orderbyColumn, int limit) {
        String sql = "     SELECT gifts.* FROM\n     (SELECT * FROM linkinfo WHERE linklocid = '251')  AS gifts\n     LEFT JOIN games ON gifts.gameid = games.gameId\n     WHERE games.clientType = ?\n";
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(clientTypeEnum.getValue());
        if (StringUtils.isNotEmpty((String)orderbyColumn)) {
            if ("displaysort".equals(orderbyColumn)) {
                sql = sql + " order by displaysort desc ";
            } else if ("validdatetime".equals(orderbyColumn)) {
                sql = sql + " order by validdatetime desc ";
            }
        }
        if (limit > 0) {
            sql = sql + " limit ? ";
            list.add(limit);
        }
        List giftList = this.baseDao.findBySql(LinkInfo.class, sql, list);
        return giftList;
    }

    @Override
    public void updateNormalToWeihu(String shemaId, String shemaTime) {
        String sql = "UPDATE linkinfo li, gameservers gs SET gs.openstatus = '3'  WHERE li.ext4 = ? AND li.ext2 = ?  AND li.gameId = gs.gameId AND li.ext1 = gs.fenQuNum  AND gs.openstatus = '1' ";
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add(shemaId);
        paramList.add(shemaTime);
        this.baseDao.execute(sql, paramList);
    }

    @Override
    public void updateWeihuToNormal(String shemaId, String shemaTime) {
        String sql = "UPDATE linkinfo li, gameservers gs SET gs.openstatus = '1'  WHERE li.ext5 = ? AND li.ext3 = ?  AND li.gameId = gs.gameId AND li.ext1 = gs.fenQuNum  AND gs.openstatus = '3' ";
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add(shemaId);
        paramList.add(shemaTime);
        this.baseDao.execute(sql, paramList);
    }
}

