package com.xunlei.niux.data.vipgame.bo.vic;

import com.ferret.common.dao.BaseDao;
import com.xunlei.niux.data.vipgame.vo.vic.KpiGame;
import com.xunlei.niux.data.vipgame.vo.vic.KpiPerson;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
public class KpiBoImpl implements KpiBo{

    private BaseDao baseDao;

    public BaseDao getBaseDao() {
        return baseDao;
    }

    public void setBaseDao(BaseDao baseDao) {
        this.baseDao = baseDao;
    }

    @Override
    public Map<String, KpiPerson> getKpiPersonMap(String queryMonth) {
        List<Object> params = new ArrayList<Object>();
        params.add(queryMonth);
        List<KpiPerson> list = baseDao.findBySql(KpiPerson.class, "select * from vic_kpi_person where kpidate=? ", params);
        Map<String, KpiPerson> map = new HashMap<String, KpiPerson>();
        for(KpiPerson vo:list){
            map.put(vo.getPerson(),vo);
        }
        return map;
    }

    @Override
    public Map<String, KpiGame> getKpiGameMap(String queryMonth) {
        List<Object> params = new ArrayList<Object>();
        params.add(queryMonth);
        List<KpiGame> list = baseDao.findBySql(KpiGame.class, "select * from vic_kpi_game where kpidate=? ", params);
        Map<String, KpiGame> map = new HashMap<String, KpiGame>();
        for(KpiGame vo:list){
            map.put(vo.getGameid(),vo);
        }
        return map;
    }
}
