package com.xunlei.niux.data.vipgame.bo;

import com.xunlei.niux.data.vipgame.dao.MobileGameApkDao;
import com.xunlei.niux.data.vipgame.dto.CanPkgMobileGame;
import com.xunlei.niux.data.vipgame.dto.game.GameDTO;
import com.xunlei.niux.data.vipgame.dto.game.MobileGameDTO;
import com.xunlei.niux.data.vipgame.vo.WDJMobileGameApk;
import com.xunlei.niux.data.vipgame.vo.mobilegameapkversion.MobileGameChannelApk;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * Created by Dean on 2016/4/5.
 */
@Service
public class MobileGameApkBoImpl implements MobileGameApkBo {
    @Autowired
    private MobileGameApkDao mobileGameApkDao;

    public MobileGameApkDao getMobileGameApkDao() {
        return mobileGameApkDao;
    }

    public void setMobileGameApkDao(MobileGameApkDao mobileGameApkDao) {
        this.mobileGameApkDao = mobileGameApkDao;
    }

    public List<WDJMobileGameApk> getWDJMobileGameApk(Long apkId, String gameId, String channleApkStatus,int pageNo,int pageSize){
        return mobileGameApkDao.getWDJMobileGameApk( apkId,  gameId,  channleApkStatus, pageNo, pageSize);
    }

    public int countWDJMobileGameApk(Long apkId, String gameId, String channleApkStatus,int pageNo,int pageSize){
        return mobileGameApkDao.countWDJMobileGameApk(apkId, gameId, channleApkStatus, pageNo, pageSize);
    }

    public List<GameDTO> getPhoneGameDto(String gameId, String channelId){
        return mobileGameApkDao.getPhoneGameDto(gameId, channelId);
    }

    public List<MobileGameChannelApk> getMobileGameChannelApk(Long apkId, String chanelIds){
        return mobileGameApkDao.getMobileGameChannelApk(apkId,chanelIds);
    }

    public List<MobileGameChannelApk> getApkByIds(String apkIds){
        return mobileGameApkDao.getApkByIds(apkIds);
    }

    public List<MobileGameDTO> getMobileGameDTO(String gameId, String channelId){return mobileGameApkDao.getMobileGameDTO(gameId, channelId);}

    public  String getApkChannelsString(String gameId){
        return mobileGameApkDao.getApkChannelsString(gameId);
    }

    public List<String> getApkChannels(String gameId){
        return mobileGameApkDao.getApkChannels(gameId);
    }

    public List<CanPkgMobileGame> getCanPkgMobileGame(){
        return mobileGameApkDao.getCanPkgMobileGame();
    }

}
