/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.data.vipgame.dao.gift;

import com.ferret.common.dao.BaseDaoImpl;
import com.xunlei.common.util.StringTools;
import com.xunlei.niux.data.vipgame.dao.gift.GiftRecordDao;
import com.xunlei.niux.data.vipgame.dto.ActivityNGiftNGiftRecordDTO;
import com.xunlei.niux.data.vipgame.dto.GiftRecordDTO;
import com.xunlei.niux.data.vipgame.dto.ProductDTO;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class GiftRecordDaoImpl
extends BaseDaoImpl
implements GiftRecordDao {
    @Override
    public List<GiftRecordDTO> getUnReleaseProductGiftRecord() {
        final ArrayList<GiftRecordDTO> giftRecordDTOList = new ArrayList<GiftRecordDTO>();
        String sql = "SELECT giftrecord.*,giftshopreleaserecord.*,gift.goodId FROM giftrecord\nLEFT JOIN giftshopreleaserecord ON giftrecord.recordId = giftshopreleaserecord.giftRecordId\nLEFT JOIN gift ON giftrecord.giftId = gift.giftId\nWHERE giftType = 'product' AND (giftshopreleaserecord.releaseStatus IS NULL OR giftshopreleaserecord.releaseStatus != 1)\nand gift.goodId is not null and gift.goodId > 0";
        this.getJdbcTemplate().query(sql, new RowCallbackHandler(){

            public void processRow(ResultSet resultSet) throws SQLException {
                GiftRecordDTO giftRecordDTO = new GiftRecordDTO();
                giftRecordDTO.setRecordId(resultSet.getLong("recordId"));
                giftRecordDTO.setGiftId(resultSet.getLong("giftId"));
                giftRecordDTO.setUserId(resultSet.getString("userId"));
                giftRecordDTO.setGameId(resultSet.getString("gameId"));
                giftRecordDTO.setServerId(resultSet.getString("serverId"));
                giftRecordDTO.setRoleId(resultSet.getString("roleId"));
                giftRecordDTO.setGiftNum(resultSet.getDouble("giftNum"));
                giftRecordDTO.setMobile(resultSet.getString("mobile"));
                giftRecordDTO.setGiftStatus(resultSet.getString("giftStatus"));
                giftRecordDTO.setActNo(resultSet.getString("actNo"));
                giftRecordDTO.setThirdRecordId(resultSet.getString("thirdRecordId"));
                giftRecordDTO.setFailCause(resultSet.getString("failCause"));
                giftRecordDTO.setRecordTime(resultSet.getString("recordTime"));
                giftRecordDTO.setDealTime(resultSet.getString("dealTime"));
                giftRecordDTO.setExpireDate(resultSet.getString("expireDate"));
                giftRecordDTO.setXunleiVipType(resultSet.getString("xunleiVipType"));
                giftRecordDTO.setParentRecordId(resultSet.getLong("parentRecordId"));
                giftRecordDTO.setIsShow(resultSet.getBoolean("isShow"));
                giftRecordDTO.setSerialNumber(resultSet.getString("serialNumber"));
                giftRecordDTO.setShowLocNo(resultSet.getString("showLocNo"));
                giftRecordDTO.setReleaseStatus(resultSet.getBoolean("releaseStatus"));
                giftRecordDTO.setReleaseTime(resultSet.getString("releaseTime"));
                giftRecordDTO.setGoodId(resultSet.getInt("goodId"));
                giftRecordDTOList.add(giftRecordDTO);
            }
        });
        return giftRecordDTOList;
    }

    @Override
    public List<ProductDTO> getBonusProductChargeList(int max) {
        final ArrayList<ProductDTO> giftRecordDTOList = new ArrayList<ProductDTO>();
        String sql = "SELECT * FROM bonusproductcharge s1 LEFT JOIN gift s2 ON  s1.productId=s2.giftId where s1.isValid=1 order by s1.inputtime desc";
        Object[] args = null;
        if (max > 0) {
            sql = sql + " limit ?";
            args = new Object[]{max};
        }
        this.getJdbcTemplate().query(sql, args, new RowCallbackHandler(){

            public void processRow(ResultSet resultSet) throws SQLException {
                ProductDTO giftRecordDTO = new ProductDTO();
                giftRecordDTO.setGiftid(resultSet.getString("productId"));
                giftRecordDTO.setGiftName(resultSet.getString("giftName"));
                String giftType = resultSet.getString("giftType");
                giftRecordDTO.setGiftType(StringTools.isEmpty((String)giftType) ? 2 : ("product".equals(giftType) ? 1 : 2));
                giftRecordDTO.setTotalNum(resultSet.getLong("totalCount"));
                giftRecordDTO.setRemainNum(resultSet.getLong("leftCount"));
                giftRecordDTO.setGiftBonusNum(resultSet.getLong("bonus"));
                giftRecordDTO.setGiftImgUrl(resultSet.getString("giftPic"));
                giftRecordDTO.setSmallImgUrl(resultSet.getString("smallPicUrl"));
                giftRecordDTO.setValdateTime(resultSet.getString("valdateTime"));
                giftRecordDTOList.add(giftRecordDTO);
            }
        });
        return giftRecordDTOList;
    }

    @Override
    public List<?> getJiFenShopGiftRecord(Class<?> object, String userId, Set<String> giftTypeParamSet, int pageNo, int pageSize) {
        ArrayList list = new ArrayList();
        String sql = "SELECT giftrecord.*, giftshopreleaserecord.*, 0 AS goodId FROM giftrecord  LEFT JOIN giftshopreleaserecord ON giftrecord.recordId = giftshopreleaserecord.giftRecordId  LEFT JOIN gift ON giftrecord.giftId = gift.giftId  WHERE giftrecord.userid=:userid AND gift.giftType in (:giftTypeParamSet) AND giftrecord.isshow='1'   AND EXISTS (SELECT 1 FROM activity_category WHERE giftrecord.actNo = activity_category.actNo AND activity_category.is_bonusshop = 1)  ORDER BY giftrecord.recordTime DESC LIMIT :pageNo,:pageSize";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("userid", (Object)userId);
        parameters.addValue("giftTypeParamSet", giftTypeParamSet);
        parameters.addValue("pageNo", (Object)pageNo);
        parameters.addValue("pageSize", (Object)pageSize);
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.getDataSource());
        return namedParameterJdbcTemplate.query(sql, (SqlParameterSource)parameters, (RowMapper)new BeanPropertyRowMapper(object));
    }

    @Override
    public List<?> getUserGiftRecordByGiftType(Class<?> object, String userId, Set<String> giftTypeParamSet, int pageNo, int pageSize) {
        String sql = "SELECT activity.*, gift.* , giftrecord.*, giftshopreleaserecord.*, 0 AS goodId FROM giftrecord  LEFT JOIN giftshopreleaserecord ON giftrecord.recordId = giftshopreleaserecord.giftRecordId LEFT JOIN gift ON giftrecord.giftId = gift.giftId LEFT JOIN activity ON giftrecord.actno = activity.actno WHERE giftrecord.userid=:userid AND gift.giftType in (:giftTypeParamSet) AND giftrecord.isshow='1'  ORDER BY giftrecord.recordTime DESC LIMIT :pageNo,:pageSize";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("userid", (Object)userId);
        parameters.addValue("giftTypeParamSet", giftTypeParamSet);
        parameters.addValue("pageNo", (Object)pageNo);
        parameters.addValue("pageSize", (Object)pageSize);
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.getDataSource());
        return namedParameterJdbcTemplate.query(sql, (SqlParameterSource)parameters, (RowMapper)new BeanPropertyRowMapper(object));
    }

    @Override
    public int countUserGiftRecordByGiftType(String userId, Set<String> giftTypeParamSet) {
        String sql = "SELECT count(*) FROM giftrecord  LEFT JOIN gift ON giftrecord.giftId = gift.giftId  WHERE giftrecord.userid=:userid AND gift.giftType in (:giftTypeParamSet) AND giftrecord.isshow='1' ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("userid", (Object)userId);
        parameters.addValue("giftTypeParamSet", giftTypeParamSet);
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.getDataSource());
        return namedParameterJdbcTemplate.queryForInt(sql, (SqlParameterSource)parameters);
    }

    @Override
    public int countJiFenShopGiftRecord(String userId, Set<String> giftTypeParamSet) {
        String sql = "SELECT count(*) FROM giftrecord  LEFT JOIN gift ON giftrecord.giftId = gift.giftId  WHERE giftrecord.userid=:userid AND gift.giftType in (:giftTypeParamSet) AND giftrecord.isshow='1'  AND EXISTS (SELECT 1 FROM activity_category WHERE giftrecord.actNo = activity_category.actNo AND activity_category.is_bonusshop = 1) ";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("userid", (Object)userId);
        parameters.addValue("giftTypeParamSet", giftTypeParamSet);
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.getDataSource());
        return namedParameterJdbcTemplate.queryForInt(sql, (SqlParameterSource)parameters);
    }

    @Override
    public List<ActivityNGiftNGiftRecordDTO> getUserGiftRecordsByActNo(String userId, String actNo) {
        String sql = "select giftrecord.*,gift.* from \ngift join giftrecord on gift.giftId = giftrecord.giftId\nwhere giftrecord.isshow='1' and giftrecord.actNo=:actNo and giftrecord.userId=:userId";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("userId", (Object)userId);
        parameters.addValue("actNo", (Object)actNo);
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.getDataSource());
        return namedParameterJdbcTemplate.query(sql, (SqlParameterSource)parameters, (RowMapper)new BeanPropertyRowMapper(ActivityNGiftNGiftRecordDTO.class));
    }
}

