package com.xunlei.niux.data.vipgame.dao.games;

import com.ferret.common.dao.BaseDaoImpl;
import com.xunlei.niux.data.vipgame.vo.Games;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.jdbc.core.RowCallbackHandler;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

/**
 * Created by jamesjxin on 14-6-25.
 */
public class GamesDaoImpl extends BaseDaoImpl implements GamesDao{

    @Override
    public List<Games> queryGames(String keyWord,int limit) {
        String sql = "select * from games where gameName like ? and status = '1' ";
          sql += " and (clientType = 0 or clientType = 1) order by inputTime desc limit "+limit;        

        final List<Games> gamesList = new ArrayList<Games>();

        getJdbcTemplate().query(sql, new Object[]{keyWord+"%"}, new RowCallbackHandler() {
            @Override
            public void processRow(ResultSet resultSet) throws SQLException {
                Games game = new Games();
                game.setSeqId(resultSet.getLong("seqId"));
                game.setGameId(resultSet.getString("gameId"));
                game.setGameNo(resultSet.getString("gameNo"));
                game.setGameName(resultSet.getString("gameName"));
                game.setOfficialWebSite(resultSet.getString("officialWebSite"));
                gamesList.add(game);
            }
        });

        return gamesList;
    }

    @Override
    public List<Games> queryGamesByKeyWord(String keyWord,int gameType) {
        String sql = "select * from games where gameName like ? and status = '1' ";
        if(gameType == 1){
            sql += " and clientType = 3 ";
        }else {
            sql += " and (clientType = 0 or clientType = 1) ";
        }

        final List<Games> gamesList = new ArrayList<Games>();

        getJdbcTemplate().query(sql, new Object[]{"%"+keyWord+"%"}, new RowCallbackHandler() {
            @Override
            public void processRow(ResultSet resultSet) throws SQLException {
                Games game = new Games();
                game.setSeqId(resultSet.getLong("seqId"));
                game.setGameId(resultSet.getString("gameId"));
                game.setGameNo(resultSet.getString("gameNo"));
                game.setGameName(resultSet.getString("gameName"));
                game.setOfficialWebSite(resultSet.getString("officialWebSite"));
                game.setPicUrl(resultSet.getString("picUrl"));
                game.setGameDesc(resultSet.getString("gameDesc"));
                game.setSmallPicUrl(resultSet.getString("smallPicUrl"));

                gamesList.add(game);
            }
        });

        return gamesList;
    }

    public Games getCurrentNewstMobileGame(){
        String sql = " select seqId,gameId,gameName,gameNo from games where gameId like '05%' order by gameId desc limit 1;";

        final List<Games> gamesList = new ArrayList<Games>();

        getJdbcTemplate().query(sql,  new RowCallbackHandler() {
            @Override
            public void processRow(ResultSet resultSet) throws SQLException {
                Games game = new Games();
                game.setSeqId(resultSet.getLong("seqId"));
                game.setGameId(resultSet.getString("gameId"));
                game.setGameNo(resultSet.getString("gameNo"));
                game.setGameName(resultSet.getString("gameName"));

                gamesList.add(game);
            }
        });
        if(CollectionUtils.isEmpty(gamesList)){
            return null;
        }
        return gamesList.get(0);
    }
}
