package com.xunlei.niux.data.vipgame.bo.activity.secondkill;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Order;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.dao.activity.secondkill.SecondKillConfigDao;
import com.xunlei.niux.data.vipgame.dto.activity.SecondKillConfigDTO;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.activity.SecondKillConfig;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by jamesjxin on 14-6-6.
 */

public class SecondKillConfigBoImpl implements SecondKillConfigBo{


    private SecondKillConfigDao secondKillConfigDao;

    public SecondKillConfigDao getSecondKillConfigDao() {
        return secondKillConfigDao;
    }

    public void setSecondKillConfigDao(SecondKillConfigDao secondKillConfigDao) {
        this.secondKillConfigDao = secondKillConfigDao;
    }

    @Override
    public List<SecondKillConfigDTO> getAllValidSecondKillConfigs() {
        List<SecondKillConfig> allSecondKillConfigs = secondKillConfigDao.getAllValidSecondKillConfigs();

        List<SecondKillConfigDTO> secondKillConfigDTOs = new ArrayList<SecondKillConfigDTO>();
        if(CollectionUtils.isEmpty(allSecondKillConfigs)){
            return secondKillConfigDTOs;
        }

        for(SecondKillConfig secondKillConfig : allSecondKillConfigs){
            SecondKillConfigDTO secondKillConfigDTO = new SecondKillConfigDTO();
            BeanUtils.copyProperties(secondKillConfig,secondKillConfigDTO);
            secondKillConfigDTOs.add(secondKillConfigDTO);
        }

        return secondKillConfigDTOs;
    }

    @Override
    public SecondKillConfigDTO findSecondKillConfigByActNo(String actNo) {
        SecondKillConfig query = new SecondKillConfig();
        query.setActNo(actNo);
        Page page = new Page();
        page.addOrder("inputTime", OrderType.DESC);
        List<SecondKillConfig> lists = secondKillConfigDao.findByObject(SecondKillConfig.class,query,page);

        if(CollectionUtils.isEmpty(lists)){
            return null;
        }

        SecondKillConfigDTO configDTO = new SecondKillConfigDTO();
        BeanUtils.copyProperties(lists.get(0),configDTO);
        return configDTO;
    }
}
