package com.xunlei.niux.data.vipgame.bo;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.apache.commons.lang.StringUtils;

import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.enums.game.GameClientTypeEnum;
import com.xunlei.niux.data.vipgame.vo.LinkInfo;

public class LinkInfoBoImpl implements LinkInfoBo {
	private static SimpleDateFormat sdf=new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
	private BaseDao baseDao;
	public BaseDao getBaseDao() {
		return baseDao;
	}
	public void setBaseDao(final BaseDao baseDao) {
		this.baseDao = baseDao;
	}
	public int count(final LinkInfo linkInfo) {
		return baseDao.count(linkInfo);
	}

	public void delete(final Integer linkid) {
		baseDao.deleteById(LinkInfo.class, linkid);
	}

	public List<LinkInfo> find(final LinkInfo linkInfo) {
		return baseDao.findByObject(LinkInfo.class, linkInfo, new Page());
	}

	public LinkInfo find(final Integer linkid) {
		return baseDao.findById(LinkInfo.class, linkid);
	}

	public void update(LinkInfo linkInfo) {
		linkInfo=formatNull(linkInfo);
		baseDao.updateById(linkInfo);
	}

	public void add(LinkInfo linkInfo) {
		linkInfo=formatNull(linkInfo);
		linkInfo.setEditby(linkInfo.getInputby());
		linkInfo.setEdittime(linkInfo.getInputtime());
		baseDao.insert(linkInfo);
	}
	public List<LinkInfo> find(final LinkInfo linkInfo, final Page page) {
		return baseDao.findByObject(LinkInfo.class, linkInfo, page);
	}
	/**
	 * 通过linkLocid查询已生效的displayorder降序前rownum行数据。如果需要包含测试数据isQueryTestData=true
	 * @param linkLocid
	 * @param rownum
	 * @param isQueryTestData
	 * @return
	 */
	public List<LinkInfo> getValidteLinkInfoListByLinkLocId(final String linkLocid,final int rownum,boolean isQueryTestData){
		if(linkLocid==null||"".equals(linkLocid)){
			return new ArrayList<LinkInfo>();
		}
		//获取当前时间
		String now =sdf.format(new Date());
		//查询条件
		LinkInfo qli=new LinkInfo();
		qli.setLinklocid(linkLocid);
		qli.setTovaliddatetime(now);
		if(!isQueryTestData){
			//只查询正式数据
			qli.setIstest(false);
		}
		//分页设置
		Page page=new Page();
		page.setPageNo(1);//第一页
		page.setPageSize(rownum);//第一行
		page.addOrder("validdatetime", OrderType.DESC);//生效时间
		page.addOrder("displayorder", OrderType.DESC);//按照降序排
		return  baseDao.findByObject(LinkInfo.class, qli, page);
	}

	/**
	 * 通过linkLocid查询已生效的displayorder降序前1行数据。如果需要包含测试数据isQueryTestData=true
	 * @param linkLocid
	 * @param isQueryTestData
	 * @return
	 */
	public LinkInfo getValidteLinkInfoByLinkLocId(final String linkLocid,boolean isQueryTestData){
		if(linkLocid==null||"".equals(linkLocid)){
			return null;
		}
		//获取当前时间
		String now =sdf.format(new Date());
		//查询条件
		LinkInfo qli=new LinkInfo();
		qli.setLinklocid(linkLocid);
		qli.setTovaliddatetime(now);
		if(!isQueryTestData){
			//只查询正式数据
			qli.setIstest(false);
		}
		//分页设置
		Page page=new Page();
		page.setPageNo(1);//第一页
		page.setPageSize(1);//第一行
		page.addOrder("validdatetime", OrderType.DESC);//生效时间
		page.addOrder("displayorder", OrderType.DESC);//按照降序排
		List<LinkInfo> list= baseDao.findByObject(LinkInfo.class, qli, page);
		return (list!=null&&list.size()>0)?list.get(0):null;
	}
	public LinkInfo getValidteLinkInfoByLinkLocId_V2(final String linkLocid,final boolean isQueryTestData){
		List<LinkInfo> list= getValidteLinkInfoListByLinkLocId_V2(linkLocid, 1, isQueryTestData);
		return (list!=null&&list.size()>0)?list.get(0):null;
	}
	/**
	 * 通过linkLocid查询已生效的displayorder降序前rownum行数据。如果需要包含测试数据isQueryTestData=true
	 * @param linkLocid
	 * @param rownum
	 * @param isQueryTestData
	 * @return
	 */
	public List<LinkInfo> getGameValidteLinkInfoListByLinkLocId(final String linkLocid,final String gameId,final int rownum,boolean isQueryTestData){
		if(linkLocid==null||"".equals(linkLocid)){
			return new ArrayList<LinkInfo>();
		}
		if(gameId==null||"".equals(gameId)){
			return new ArrayList<LinkInfo>();
		}
		//获取当前时间
		String now =sdf.format(new Date());
		//查询条件
		LinkInfo qli=new LinkInfo();
        qli.setGameid(gameId);
		qli.setLinklocid(linkLocid);
		qli.setTovaliddatetime(now);
		if(!isQueryTestData){
			//只查询正式数据
			qli.setIstest(false);
		}
		//分页设置
		Page page=new Page();
		page.setPageNo(1);//第一页
		page.setPageSize(rownum);//第一行
		page.addOrder("validdatetime", OrderType.DESC);//生效时间
		page.addOrder("displayorder", OrderType.DESC);//按照降序排
		return  baseDao.findByObject(LinkInfo.class, qli, page);
	}

    @Override
    public List<LinkInfo> getLinkInfoByLinkLocIdandTime(final String linkLocid, final String fromvaliddatetime, final String tovaliddatetime, boolean isQueryTestData) {
        if(linkLocid==null||"".equals(linkLocid)){
            return new ArrayList<LinkInfo>();
        }
        //查询条件
        LinkInfo qli=new LinkInfo();
        qli.setLinklocid(linkLocid);
        qli.setFromvaliddatetime(fromvaliddatetime);
        qli.setTovaliddatetime(tovaliddatetime);
        if(!isQueryTestData){
            //只查询正式数据
            qli.setIstest(false);
        }

        Page page=new Page();
        page.setPageNo(0);
        page.setPageSize(0);

        page.addOrder("validdatetime", OrderType.DESC);//生效时间
        return baseDao.findByObject(LinkInfo.class, qli, page);

    }

    /**
	 * 通过linkLocid查询已生效的displayorder降序前1行数据。如果需要包含测试数据isQueryTestData=true
	 * @param linkLocid
	 * @param gameId
	 * @param isQueryTestData
	 * @return
	 */
	public LinkInfo getGameValidteLinkInfoByLinkLocId(final String linkLocid,final String gameId,boolean isQueryTestData){
		if(linkLocid==null||"".equals(linkLocid)){
			return null;
		}
		if(gameId==null||"".equals(gameId)){
			return null;
		}
		//获取当前时间
		String now =sdf.format(new Date());
		//查询条件
		LinkInfo qli=new LinkInfo();
		qli.setLinklocid(linkLocid);
		qli.setGameid(gameId);
		qli.setTovaliddatetime(now);
		if(!isQueryTestData){
			//只查询正式数据
			qli.setIstest(false);
		}
		//分页设置
		Page page=new Page();
		page.setPageNo(1);//第一页
		page.setPageSize(1);//第一行
		page.addOrder("validdatetime", OrderType.DESC);//生效时间
		page.addOrder("displayorder", OrderType.DESC);//按照降序排
		//执行查询
		List<LinkInfo> list= baseDao.findByObject(LinkInfo.class, qli, page);
		return (list!=null&&list.size()>0)?list.get(0):null;
	}
	public LinkInfo getGameValidteLinkInfoByLinkLocId_v2(final String linkLocid,final String gameId,final boolean isQueryTestData){
		List<LinkInfo> list=getGameValidteLinkInfoListByLinkLocId_v2(linkLocid, gameId, 1, isQueryTestData);
		return (list==null||list.size()==0)?null:list.get(0);
	}
	public List<LinkInfo> getGameValidteLinkInfoListByLinkLocId_v2(final String linkLocid,final String gameId,final int rownum,boolean isQueryTestData){
		LinkInfo li=new LinkInfo();
		li.setLinklocid(linkLocid);
		li.setGameid(gameId);
		li.setTovaliddatetime(sdf.format(new Date()));
		if(!isQueryTestData){
	        li.setIstest(false);	        //只查询正式数据
	    }
		li.setIsvalid(true);
		
		Page page=new Page();
		page.setPageNo(1);//第一页
		page.setPageSize(rownum);//第一行
		page.addOrder("displaysort", OrderType.ESC);//按照升序序排
		page.addOrder("validdatetime", OrderType.DESC);//生效时间
		return  baseDao.findByObject(LinkInfo.class, li, page);
	}
	public LinkInfo formatNull(final LinkInfo linkInfo){
		if(linkInfo==null){
			return null;
		}
		linkInfo.setDisplayorder(defaultReplaceNull(linkInfo.getDisplayorder()));
		linkInfo.setExt1(defaultReplaceNull(linkInfo.getExt1()));
		linkInfo.setExt2(defaultReplaceNull(linkInfo.getExt2()));
		linkInfo.setExt3(defaultReplaceNull(linkInfo.getExt3()));
		linkInfo.setGameid(defaultReplaceNull(linkInfo.getGameid()));
		linkInfo.setGameidbytuijian(defaultReplaceNull(linkInfo.getGameidbytuijian()));
		linkInfo.setLinktitle(defaultReplaceNull(linkInfo.getLinktitle()));
		linkInfo.setSmallpicurl(defaultReplaceNull(linkInfo.getSmallpicurl()));
		linkInfo.setPicurl(defaultReplaceNull(linkInfo.getPicurl()));
		linkInfo.setLinkurl(defaultReplaceNull(linkInfo.getLinkurl()));
		linkInfo.setLinkdesc(defaultReplaceNull(linkInfo.getLinkdesc()));
		return linkInfo;
	}
	public String defaultReplaceNull(final String value){
		return value==null?"":value;
	}

    public List<LinkInfo> getValidteLinkInfoListByLinkLocId_V2(final String linkLocid,final int rownum,final boolean isQueryTestData){
        return getValidteLinkInfoListByLinkLocId_V2(linkLocid, rownum, isQueryTestData,1);
    }

    @Override
    public List<LinkInfo> getValidteLinkInfoListByLinkLocId_V2(final String linkLocid, final int rownum, boolean isQueryTestData, final int isvalid) {
        if(linkLocid==null||"".equals(linkLocid)){
            return new ArrayList<LinkInfo>();
        }
        //获取当前时间
        String now =sdf.format(new Date());
        //查询条件
        LinkInfo qli=new LinkInfo();
        qli.setLinklocid(linkLocid);
        qli.setTovaliddatetime(now);
        if(!isQueryTestData){
            //只查询正式数据
            qli.setIstest(false);
        }
        if(isvalid>0){
            qli.setIsvalid(true);
        }
        //分页设置
        Page page=new Page();
        page.setPageNo(1);//第一页
        page.setPageSize(rownum);//第一行
        page.addOrder("displaysort", OrderType.ESC);//按照升序序排
        page.addOrder("validdatetime", OrderType.DESC);//生效时间
        return  baseDao.findByObject(LinkInfo.class, qli, page);
    }




	public List<LinkInfo> getLinkListByOrderByLimit(final String linkLocid,final String orderColumn,final OrderType orderType,final boolean isQueryTestData){
          return getLinkListByOrderByLimit(linkLocid, 0, orderColumn, orderType, isQueryTestData);
	}

    @Override
    public List<LinkInfo> getAllLinkListByLinkLocId(final String linkLocId, final boolean isQueryTestData) {
        return getLinkListByOrderByLimit(linkLocId,0,"",OrderType.DESC,isQueryTestData);
    }

    @Override
    public List<LinkInfo> getLinkListByOrderByLimit(final String linkLocid, final int limit, final String orderColumn, final OrderType orderType, final boolean isQueryTestData) {
        return getLinkListByOrderByLimit(linkLocid, limit, orderColumn, orderType, false, isQueryTestData);
    }

    @Override
    public List<LinkInfo> getLinkListByOrderByLimit(final String linkLocid, final int limit, final String orderColumn, final OrderType orderType, final boolean isValid, boolean isQueryTestData) {
        LinkInfo li=new LinkInfo();
        li.setLinklocid(linkLocid);
        if(!isQueryTestData){
            li.setIstest(false);	        //只查询正式数据 
        }

        if(isValid){
            li.setIsvalid(true);
        }

        Page page=new Page();
        if(limit > 0){
            page.setPageNo(1);
            page.setPageSize(limit);
        }

        if(StringUtils.isNotEmpty(orderColumn)){
            page.addOrder(orderColumn, orderType);//按照升序序排
        }
        return  baseDao.findByObject(LinkInfo.class, li, page);
    }



    @Override
    public List<LinkInfo> getHotShouyouGiftList(final int limit) {
        return getGiftListByClientTypeWithOrderByColumnDesc(GameClientTypeEnum.shouyou,"displaysort",limit);
    }

    @Override
    public List<LinkInfo> getGiftListByClientTypeWithOrderByColumnDesc(final GameClientTypeEnum clientTypeEnum, final String orderbyColumn,final int limit) {
        String sql = "     SELECT gifts.* FROM\n" +
                "     (SELECT * FROM linkinfo WHERE linklocid = '251')  AS gifts\n" +
                "     LEFT JOIN games ON gifts.gameid = games.gameId\n" +
                "     WHERE games.clientType = ?\n";

        List<Object> list = new ArrayList<Object>();
        list.add(clientTypeEnum.getValue());
        if(StringUtils.isNotEmpty(orderbyColumn)){
            if("displaysort".equals(orderbyColumn)){
                sql += " order by displaysort desc ";
            }else if("validdatetime".equals(orderbyColumn)){
                sql += " order by validdatetime desc ";
            }
        }

        if(limit > 0){
            sql += " limit ? ";
            list.add(limit);
        }

        List<LinkInfo> giftList = baseDao.findBySql(LinkInfo.class,sql,list);
        return giftList;
    }
    
    
	@Override
	public void updateNormalToWeihu(final String shemaId, final String shemaTime) {
		String sql = "UPDATE linkinfo li, gameservers gs SET gs.openstatus = '3' "
			+ " WHERE li.ext4 = ? AND li.ext2 = ? "
			+ " AND li.gameId = gs.gameId AND li.ext1 = gs.fenQuNum "
			+ " AND gs.openstatus = '1' ";
		
		List<Object> paramList = new ArrayList<Object>();
		paramList.add(shemaId);
		paramList.add(shemaTime);
		
		baseDao.execute(sql, paramList);
	}
	
	@Override
	public void updateWeihuToNormal(final String shemaId, final String shemaTime) {
		String sql = "UPDATE linkinfo li, gameservers gs SET gs.openstatus = '1' "
			+ " WHERE li.ext5 = ? AND li.ext3 = ? "
			+ " AND li.gameId = gs.gameId AND li.ext1 = gs.fenQuNum "
			+ " AND gs.openstatus = '3' ";
		
		List<Object> paramList = new ArrayList<Object>();
		paramList.add(shemaId);
		paramList.add(shemaTime);
		
		baseDao.execute(sql, paramList);
	}
    
    
    
}
