package com.xunlei.niux.data.vipgame.bo.businesss;

import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.vo.business.IncomeApp;
import java.util.List;

/**
 * @author lisu
 * 2014-04-18
 */
public class IncomeAppBoImpl implements IncomeAppBo {

    private BaseDao baseDao;

    public BaseDao getBaseDao() {
        return baseDao;
    }

    public void setBaseDao(BaseDao baseDao) {
        this.baseDao = baseDao;
    }

    @Override
    public List<IncomeApp> find(IncomeApp income, int pageNo, int pageSize) {
        Page page = new Page();
        page.setPageNo(pageNo);
        page.setPageSize(pageSize);
        page.addOrder("incomemonth", OrderType.ESC);

        return baseDao.findByObject(IncomeApp.class, income, page);

    }

    @Override
    public int count(IncomeApp income) {
        return baseDao.count(income);
    }

    @Override
    public IncomeApp findById(Integer seqid) {
        return baseDao.findById(IncomeApp.class, seqid);
    }

    @Override
    public void update(IncomeApp income) {
        baseDao.updateById(income);
    }

    @Override
    public List<IncomeApp> findSql(String sql) {
        return baseDao.findBySql(IncomeApp.class, sql);
    }

    @Override
    public void insert(IncomeApp income) {
        baseDao.insert(income);
    }

    @Override
    public void execute(String sql, List<Object> list) {
        baseDao.execute(sql, list);
    }


}
