/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.data.vipgame.dao.games;

import com.ferret.common.dao.BaseDaoImpl;
import com.xunlei.niux.data.vipgame.dao.games.GamesDao;
import com.xunlei.niux.data.vipgame.dto.MobileGameDTO;
import com.xunlei.niux.data.vipgame.dto.game.GameDTO;
import com.xunlei.niux.data.vipgame.vo.Games;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.jdbc.core.RowCallbackHandler;

public class GamesDaoImpl
extends BaseDaoImpl
implements GamesDao {
    @Override
    public List<Games> queryGames(String keyWord, int limit) {
        String sql = "select * from games where gameName like ? and status = '1' ";
        sql = sql + " and (clientType = 0 or clientType = 1) order by inputTime desc limit " + limit;
        final ArrayList<Games> gamesList = new ArrayList<Games>();
        this.getJdbcTemplate().query(sql, new Object[]{keyWord + "%"}, new RowCallbackHandler(){

            public void processRow(ResultSet resultSet) throws SQLException {
                Games game = new Games();
                game.setSeqId(resultSet.getLong("seqId"));
                game.setGameId(resultSet.getString("gameId"));
                game.setGameNo(resultSet.getString("gameNo"));
                game.setGameName(resultSet.getString("gameName"));
                game.setOfficialWebSite(resultSet.getString("officialWebSite"));
                gamesList.add(game);
            }
        });
        return gamesList;
    }

    @Override
    public List<GameDTO> queryWebGamesByKeyWord(String keyWord) {
        String sql = "select gameId,gameNo,gameName,gameFeature,officialWebSite,picUrl,smallPicUrl,gameDesc,summary,packageName,'' downLoadUrl,'' downloadNum,'' mulPhotoUrl,'' appSize,displayOrder,mobileGameType from games where gameName like ? and status = '1' and (clientType = 0 or clientType = 1) ";
        ArrayList<String> list = new ArrayList<String>();
        list.add("%" + keyWord + "%");
        List gamesList = this.executeQuery(GameDTO.class, sql, list);
        return gamesList;
    }

    @Override
    public List<GameDTO> queryAppGamesByKeyWord(String keyWord) {
        String sql = "select games.gameId,games.gameNo,games.gameName,games.gameFeature,games.officialWebSite,games.picUrl,games.smallPicUrl,games.gameDesc,games.summary,games.packageName,newcommonspreadinfo.shortUrl downLoadUrl,games.downloadNum,newcommonspreadinfo.muliPhotoUrl mulPhotoUrl,displayOrder,games.appSize,mobileGameType from games\nleft join \n(select a.* from commonspreadinfo a \ninner join \n(select gameId,max(seqId) seqId from commonspreadinfo group by gameId) b \non a.gameId = b.gameId and a.seqId = b.seqId\n) newcommonspreadinfo\n on games.gameId = newcommonspreadinfo.gameId\nwhere gameName like ? and status = '1' and clientType = 3\nunion \nselect gameId,gameNo,gameName,gameFeature,'' officialWebSite,picUrl,iconUrl smallPicUrl,gameDesc,summary,packageName,downLoadUrl,downloadNum,mulPhotoUrl,displayOrder,cpsSize appSize,mobileGameType from cpsgames where gameName like ? and status = 1 order by displayOrder desc;";
        ArrayList<String> list = new ArrayList<String>();
        list.add("%" + keyWord + "%");
        list.add("%" + keyWord + "%");
        List gamesList = this.executeQuery(GameDTO.class, sql, list);
        return gamesList;
    }

    @Override
    public List<GameDTO> getAllValidAppGames() {
        String sql = " select games.gameId,games.gameNo,games.gameName,games.gameFeature,games.officialWebSite,games.picUrl,games.smallPicUrl,games.gameDesc,games.summary,games.packageName,newcommonspreadinfo.shortUrl downLoadUrl,games.downloadNum,newcommonspreadinfo.muliPhotoUrl mulPhotoUrl,displayOrder,games.appSize,mobileGameType from games\ninner join \n(select a.* from commonspreadinfo a \ninner join \n(select gameId,max(seqId) seqId from commonspreadinfo group by gameId) b \non a.gameId = b.gameId and a.seqId = b.seqId\n) newcommonspreadinfo\n on games.gameId = newcommonspreadinfo.gameId\nwhere status = '1' and clientType = 3\nunion \nselect gameId,gameNo,gameName,gameFeature,'' officialWebSite,picUrl,iconUrl smallPicUrl,gameDesc,summary,packageName,downLoadUrl,downloadNum,mulPhotoUrl,displayOrder,cpsSize appSize,mobileGameType from cpsgames where status = 1 order by displayOrder desc;";
        ArrayList list = new ArrayList();
        List gamesList = this.executeQuery(GameDTO.class, sql, list);
        return gamesList;
    }

    @Override
    public List<MobileGameDTO> getAllMobileGames() {
        String sql = "SELECT s1.gameId,s1.gameNo,s1.gameName,s1.gameFeature featureId,s1.gameType typeId,s1.officialWebSite gameOfficialLink,ifnull(s1.smallPicUrl,'') icon,s2.linkurl downloadLink,s2.ext1  downloadNum,s1.displayOrder\nFROM games s1 INNER JOIN (SELECT * FROM linkinfo WHERE linklocid='1601') s2\nON s1.gameId = s2.gameidbytuijian\nWHERE s1.status=1 AND s1.clientType=3\nunion\nselect gameId,gameNo,gameName,gameFeature featureId,'' typdId,'' gameOfficialLink,ifnull(iconUrl,'') icon,downLoadUrl downloadLink,downloadNum,displayOrder\nfrom cpsgames where status = 1\norder by displayOrder desc";
        ArrayList list = new ArrayList();
        List bplist = this.executeQuery(MobileGameDTO.class, sql, list);
        return bplist;
    }

    @Override
    public Games getCurrentNewstMobileGame() {
        String sql = " select seqId,gameId,gameName,gameNo from games where gameId like '05%' order by gameId desc limit 1;";
        final ArrayList gamesList = new ArrayList();
        this.getJdbcTemplate().query(sql, new RowCallbackHandler(){

            public void processRow(ResultSet resultSet) throws SQLException {
                Games game = new Games();
                game.setSeqId(resultSet.getLong("seqId"));
                game.setGameId(resultSet.getString("gameId"));
                game.setGameNo(resultSet.getString("gameNo"));
                game.setGameName(resultSet.getString("gameName"));
                gamesList.add(game);
            }
        });
        if (CollectionUtils.isEmpty(gamesList)) {
            return null;
        }
        return (Games)gamesList.get(0);
    }
}

