/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.data.vipgame.bo.lychat;

import com.ferret.common.dao.BaseDao;
import com.xunlei.niux.data.vipgame.bo.lychat.LyChatBo;
import com.xunlei.niux.data.vipgame.dto.LyChatOperationLogDTO;
import com.xunlei.niux.data.vipgame.dto.LyChatWarningDTO;
import com.xunlei.niux.data.vipgame.enums.LyChatConstant;
import com.xunlei.niux.data.vipgame.vo.lychat.LyChatDetailVO;
import com.xunlei.niux.data.vipgame.vo.lychat.LyChatWarningVO;
import com.xunlei.niux.easyutils.commonutils.DateUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class LyChatBoImpl
implements LyChatBo {
    @Resource(name="BaseDao")
    private BaseDao baseDao;

    public BaseDao getBaseDao() {
        return this.baseDao;
    }

    public void setBaseDao(BaseDao baseDao) {
        this.baseDao = baseDao;
    }

    @Override
    public void lockLyChatWarning(Long seqId) {
        LyChatWarningVO lcw = (LyChatWarningVO)this.baseDao.findById(LyChatWarningVO.class, (Number)seqId);
        lcw.setStatus(LyChatConstant.STATUS_DONE);
        lcw.setFinishTime(DateUtil.formatNowByDefault());
        this.baseDao.updateById((Object)lcw);
        LyChatDetailVO cd = this.findWarningByDetailId(lcw.getDetailId());
        cd.setOperationId(LyChatConstant.OPERATION_SEQID_LOCK_USER);
        cd.setStatus(LyChatConstant.STATUS_DONE);
        this.baseDao.updateById((Object)cd);
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(cd.getGameId());
        params.add(cd.getServerId());
        params.add(cd.getCustomerId());
        params.add(cd.getRoleId());
        params.add(cd.getRoleName());
        List detailIdList = this.baseDao.findBySql(Long.class, "select distinct detailId from lychat_detailwhere gameId=? and serverId= ? and (customerId=? or roleId=? or rolename=?) and  isWarning=1", params);
        for (Long detailId : detailIdList) {
            ArrayList<Number> pp = new ArrayList<Number>();
            pp.add(LyChatConstant.STATUS_DONE);
            pp.add(LyChatConstant.STATUS_DONE);
            pp.add(LyChatConstant.OPERATION_SEQID_LOCK_USER);
            pp.add(detailId);
            this.baseDao.execute("update lychat_warning w inner join lychat_detail d on w.detailId = d.detailId set w.status=?, w.finishTime=now(), d.status=?, d.operationId=? where w.detailId=?", pp);
        }
    }

    @Override
    public void ignoreLyChatWarning(Long seqId) {
        LyChatWarningVO cw = (LyChatWarningVO)this.baseDao.findById(LyChatWarningVO.class, (Number)seqId);
        cw.setStatus(LyChatConstant.STATUS_IGNORE);
        cw.setFinishTime(DateUtil.formatNowByDefault());
        this.baseDao.updateById((Object)cw);
        LyChatDetailVO cd = this.findWarningByDetailId(cw.getDetailId());
        cd.setStatus(LyChatConstant.STATUS_IGNORE);
        this.baseDao.updateById((Object)cd);
    }

    @Override
    public List<LyChatWarningDTO> findChatWarning(int pageNo, int pageSize) {
        String sql = "select d.*, w.hasEmail,w.happenTime,w.finishTime, w.seqId as warnSeqId from lychat_warning w left join lychat_detail d on  w.detailId=d.detailId order by happenTime desc limit ?,? ";
        ArrayList<Integer> params = new ArrayList<Integer>();
        params.add(pageNo);
        params.add(pageSize);
        return this.baseDao.findBySql(LyChatWarningDTO.class, sql, params);
    }

    @Override
    public List<LyChatWarningDTO> findChatWarningByStatus(Integer status, int pageNo, int pageSize) {
        String sql = "select d.*, w.hasEmail,w.happenTime,w.finishTime, w.seqId as warnSeqId  from lychat_warning w left join lychat_detail d on  w.detailId=d.detailId where w.status=? order by happenTime desc limit ?,? ";
        ArrayList<Integer> params = new ArrayList<Integer>();
        params.add(status);
        params.add(pageNo);
        params.add(pageSize);
        return this.baseDao.findBySql(LyChatWarningDTO.class, sql, params);
    }

    @Override
    public List<LyChatOperationLogDTO> findLyChatOperationLog(int pageNo, int pageSize) {
        String sql = "select w.*, d.operationId from lychat_operation_log w left join lychat_detail d on w.detailId=d.detailId order by workTime desc limit ?,? ";
        ArrayList<Integer> params = new ArrayList<Integer>();
        params.add(pageNo);
        params.add(pageSize);
        return this.baseDao.findBySql(LyChatOperationLogDTO.class, sql, params);
    }

    @Override
    public List<LyChatDetailVO> findByDetailId(Long detailId) {
        return this.baseDao.findBySql(LyChatDetailVO.class, "select * from lychat_detail where detailId=" + detailId);
    }

    @Override
    public LyChatDetailVO findWarningByDetailId(Long detailId) {
        return (LyChatDetailVO)this.baseDao.findBySql(LyChatDetailVO.class, "select * from lychat_detail where detailId=" + detailId + " and isWarning=1").get(0);
    }
}

