package com.xunlei.niux.data.vipgame.bo.lychat;

import com.ferret.common.dao.BaseDao;
import com.xunlei.niux.data.vipgame.dto.LyChatOperationLogDTO;
import com.xunlei.niux.data.vipgame.dto.LyChatWarningDTO;
import com.xunlei.niux.data.vipgame.enums.LyChatConstant;
import com.xunlei.niux.data.vipgame.vo.lychat.LyChatDetailVO;
import com.xunlei.niux.data.vipgame.vo.lychat.LyChatWarningVO;
import com.xunlei.niux.easyutils.commonutils.DateUtil;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

@Service
public class LyChatBoImpl implements LyChatBo{

    @Resource(name="BaseDao")
    private BaseDao baseDao;

    public BaseDao getBaseDao() {
        return baseDao;
    }

    public void setBaseDao(BaseDao baseDao) {
        this.baseDao = baseDao;
    }



    @Override
    public void lockLyChatWarning(Long seqId){

        LyChatWarningVO lcw = baseDao.findById(LyChatWarningVO.class, seqId);
        lcw.setStatus(LyChatConstant.STATUS_DONE);
        lcw.setFinishTime(DateUtil.formatNowByDefault());
        baseDao.updateById(lcw);

        LyChatDetailVO cd = findWarningByDetailId(lcw.getDetailId());
        cd.setOperationId(LyChatConstant.OPERATION_SEQID_LOCK_USER);
        cd.setStatus(LyChatConstant.STATUS_DONE);
        baseDao.updateById(cd);

        List<Object> params = new ArrayList<Object>();
        params.add(cd.getGameId());
        params.add(cd.getServerId());
        params.add(cd.getCustomerId());
        params.add(cd.getRoleId());
        params.add(cd.getRoleName());
        List<Long> detailIdList = baseDao.findBySql(Long.class, "select distinct detailId from lychat_detailwhere gameId=? and serverId= ? and (customerId=? or roleId=? or rolename=?) and  isWarning=1", params);
        for(Long detailId: detailIdList){
            List<Object> pp = new ArrayList<Object>();
            pp.add(LyChatConstant.STATUS_DONE);
            pp.add(LyChatConstant.STATUS_DONE);
            pp.add(LyChatConstant.OPERATION_SEQID_LOCK_USER);
            pp.add(detailId);
            baseDao.execute("update lychat_warning w inner join lychat_detail d on w.detailId = d.detailId set w.status=?, w.finishTime=now(), d.status=?, d.operationId=? where w.detailId=?", pp);
        }
    }


    @Override
    public void ignoreLyChatWarning(Long seqId) {
        LyChatWarningVO cw = baseDao.findById(LyChatWarningVO.class,seqId);
        cw.setStatus(LyChatConstant.STATUS_IGNORE);
        cw.setFinishTime(DateUtil.formatNowByDefault());
        baseDao.updateById(cw);

        LyChatDetailVO cd = findWarningByDetailId(cw.getDetailId());
        cd.setStatus(LyChatConstant.STATUS_IGNORE);
        baseDao.updateById(cd);
    }

    @Override
    public List<LyChatWarningDTO> findChatWarning(int pageNo, int pageSize) {
        String sql = "select d.*, w.hasEmail,w.happenTime,w.finishTime, w.seqId as warnSeqId from lychat_warning w left join lychat_detail d on  w.detailId=d.detailId order by happenTime desc limit ?,? ";
        List<Object> params = new ArrayList<Object>();
        params.add(pageNo);
        params.add(pageSize);
        return baseDao.findBySql(LyChatWarningDTO.class,sql, params);
    }

    @Override
    public List<LyChatWarningDTO> findChatWarningByStatus(Integer status, int pageNo, int pageSize) {
        String sql = "select d.*, w.hasEmail,w.happenTime,w.finishTime, w.seqId as warnSeqId  from lychat_warning w left join lychat_detail d on  w.detailId=d.detailId where w.status=? order by happenTime desc limit ?,? ";
        List<Object> params = new ArrayList<Object>();
        params.add(status);
        params.add(pageNo);
        params.add(pageSize);
        return baseDao.findBySql(LyChatWarningDTO.class,sql, params);
    }

    @Override
    public List<LyChatOperationLogDTO> findLyChatOperationLog( int pageNo, int pageSize) {
        String sql = "select w.*, d.operationId from lychat_operation_log w left join lychat_detail d on w.detailId=d.detailId order by workTime desc limit ?,? ";
        List<Object> params = new ArrayList<Object>();
        params.add(pageNo);
        params.add(pageSize);
        return baseDao.findBySql(LyChatOperationLogDTO.class,sql, params);
    }

    @Override
    public List<LyChatDetailVO> findByDetailId(Long detailId) {
        return baseDao.findBySql(LyChatDetailVO.class,"select * from lychat_detail where detailId="+detailId);
    }

    @Override
    public LyChatDetailVO findWarningByDetailId(Long detailId) {
        return baseDao.findBySql(LyChatDetailVO.class,"select * from lychat_detail where detailId="+detailId+" and isWarning=1").get(0);
    }


}
