package com.xunlei.niux.data.vipgame.bo;

import java.util.List;

import javax.annotation.Resource;

import org.springframework.stereotype.Service;

import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.vo.FavoriteRecord;
@Service
public class FavoriteRecordBoImpl implements FavoriteRecordBo{
	@Resource(name="BaseDao")
	private BaseDao baseDao;
	
	@Override
	public FavoriteRecord findByOderId(String orderId) {
		if(orderId==null||"".equals(orderId)){
			return null;
		}
		FavoriteRecord fr=new FavoriteRecord();
		fr.setOrderId(orderId);
		List<FavoriteRecord> list=find(fr,new Page());
		return (list==null||list.size()==0)?null:list.get(0);
	}

	@Override
	public FavoriteRecord findByUserId(String userId) {
		if(userId==null||"".equals(userId)){
			return null;
		}
		FavoriteRecord fr=new FavoriteRecord();
		fr.setUserId(userId);
		List<FavoriteRecord> list=find(fr,new Page());
		return (list==null||list.size()==0)?null:list.get(0);
	}

	@Override
	public List<FavoriteRecord> find(FavoriteRecord fr, Page page) {
		return baseDao.findByObject(FavoriteRecord.class, fr, page);
	}

	@Override
	public int count(FavoriteRecord fr) {
		return baseDao.count(fr);
	}

	@Override
	public void insert(FavoriteRecord fr) {
		baseDao.insert(fr);
	}

	@Override
	public void update(FavoriteRecord fr) {
		baseDao.updateById(fr);
	}

	public BaseDao getBaseDao() {
		return baseDao;
	}

	public void setBaseDao(BaseDao baseDao) {
		this.baseDao = baseDao;
	}

}
