package com.xunlei.niux.data.vipgame.dao.gift;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

import com.xunlei.niux.data.vipgame.dto.RebateOrderGroupByApOrderIdDTO;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowCallbackHandler;

import com.ferret.common.dao.BaseDaoImpl;
import com.xunlei.common.util.StringTools;
import com.xunlei.niux.data.vipgame.dto.GiftRecordDTO;
import com.xunlei.niux.data.vipgame.dto.ProductDTO;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;

/**
 * Created by jamesjxin on 14-4-17.
 */
public class GiftRecordDaoImpl extends BaseDaoImpl implements GiftRecordDao {

    @Override
    public List<GiftRecordDTO> getUnReleaseProductGiftRecord() {
        final List<GiftRecordDTO> giftRecordDTOList = new ArrayList<GiftRecordDTO>();

        String sql = "SELECT giftrecord.*,giftshopreleaserecord.*,gift.goodId FROM giftrecord\n" +
                "LEFT JOIN giftshopreleaserecord ON giftrecord.recordId = giftshopreleaserecord.giftRecordId\n" +
                "LEFT JOIN gift ON giftrecord.giftId = gift.giftId\n" +
                "WHERE giftType = 'product' AND (giftshopreleaserecord.releaseStatus IS NULL OR giftshopreleaserecord.releaseStatus != 1)\n" +
                "and gift.goodId is not null and gift.goodId > 0";


        getJdbcTemplate().query(sql, new RowCallbackHandler() {
            @Override
            public void processRow(final ResultSet resultSet) throws SQLException {
                GiftRecordDTO giftRecordDTO = new GiftRecordDTO();
                giftRecordDTO.setRecordId(resultSet.getLong("recordId"));
                giftRecordDTO.setGiftId(resultSet.getLong("giftId"));
                giftRecordDTO.setUserId(resultSet.getString("userId"));
                giftRecordDTO.setGameId(resultSet.getString("gameId"));
                giftRecordDTO.setServerId(resultSet.getString("serverId"));
                giftRecordDTO.setRoleId(resultSet.getString("roleId"));
                giftRecordDTO.setGiftNum(resultSet.getDouble("giftNum"));
                giftRecordDTO.setMobile(resultSet.getString("mobile"));
                giftRecordDTO.setGiftStatus(resultSet.getString("giftStatus"));
                giftRecordDTO.setActNo(resultSet.getString("actNo"));
                giftRecordDTO.setThirdRecordId(resultSet.getString("thirdRecordId"));
                giftRecordDTO.setFailCause(resultSet.getString("failCause"));
                giftRecordDTO.setRecordTime(resultSet.getString("recordTime"));
                giftRecordDTO.setDealTime(resultSet.getString("dealTime"));
                giftRecordDTO.setExpireDate(resultSet.getString("expireDate"));
                giftRecordDTO.setXunleiVipType(resultSet.getString("xunleiVipType"));
                giftRecordDTO.setParentRecordId(resultSet.getLong("parentRecordId"));
                giftRecordDTO.setIsShow(resultSet.getBoolean("isShow"));
                giftRecordDTO.setSerialNumber(resultSet.getString("serialNumber"));
                giftRecordDTO.setShowLocNo(resultSet.getString("showLocNo"));
                giftRecordDTO.setReleaseStatus(resultSet.getBoolean("releaseStatus"));
                giftRecordDTO.setReleaseTime(resultSet.getString("releaseTime"));
                giftRecordDTO.setGoodId(resultSet.getInt("goodId"));

                giftRecordDTOList.add(giftRecordDTO);
            }
        });

        return giftRecordDTOList;
    }

    @Override
    public List<ProductDTO> getBonusProductChargeList(final int max) {
        final List<ProductDTO> giftRecordDTOList = new ArrayList<ProductDTO>();

        String sql = "SELECT * FROM bonusproductcharge s1 LEFT JOIN gift s2 ON  s1.productId=s2.giftId where s1.isValid=1 order by s1.inputtime desc";

        Object[] args = null;
        if (max > 0) {
            sql += " limit ?";
            args = new Object[]{max};
        }

        getJdbcTemplate().query(sql, args, new RowCallbackHandler() {
            @Override
            public void processRow(final ResultSet resultSet) throws SQLException {
                ProductDTO giftRecordDTO = new ProductDTO();
                giftRecordDTO.setGiftid(resultSet.getString("productId"));
                giftRecordDTO.setGiftName(resultSet.getString("giftName"));
                String giftType = resultSet.getString("giftType");
                giftRecordDTO.setGiftType(StringTools.isEmpty(giftType) ? 2 : ("product".equals(giftType) ? 1 : 2));//实物或虚拟
                giftRecordDTO.setTotalNum(resultSet.getLong("totalCount"));
                giftRecordDTO.setRemainNum(resultSet.getLong("leftCount"));
                giftRecordDTO.setGiftBonusNum(resultSet.getLong("bonus"));
                giftRecordDTO.setGiftImgUrl(resultSet.getString("giftPic"));
                giftRecordDTO.setSmallImgUrl(resultSet.getString("smallPicUrl"));
                giftRecordDTO.setValdateTime(resultSet.getString("valdateTime"));
                giftRecordDTOList.add(giftRecordDTO);
            }
        });

        return giftRecordDTOList;
    }

	@Override
	public List<?> getJiFenShopGiftRecord(final Class<?> object, final String userId,Set<String> giftTypeParamSet, final int pageNo, final int pageSize) {
		List<?> list = new ArrayList<Object>();

        String sql = "SELECT giftrecord.*, giftshopreleaserecord.*, 0 AS goodId FROM giftrecord " +
		" LEFT JOIN giftshopreleaserecord ON giftrecord.recordId = giftshopreleaserecord.giftRecordId " +
        " LEFT JOIN gift ON giftrecord.giftId = gift.giftId " +
		" WHERE giftrecord.userid=:userid AND gift.giftType in (:giftTypeParamSet) AND giftrecord.isshow='1'  "+
		" AND EXISTS (SELECT 1 FROM activity_category WHERE giftrecord.actNo = activity_category.actNo AND activity_category.is_bonusshop = 1) " +
		" ORDER BY giftrecord.recordTime DESC LIMIT :pageNo,:pageSize";

        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("userid", userId);
        parameters.addValue("giftTypeParamSet", giftTypeParamSet);
        parameters.addValue("pageNo", pageNo);
        parameters.addValue("pageSize", pageSize);
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(getDataSource());
        return namedParameterJdbcTemplate.query(sql, parameters, new BeanPropertyRowMapper(object));
	}

    @Override
    public List<?> getUserGiftRecordByGiftType(Class<?> object, String userId,  Set<String> giftTypeParamSet, int pageNo, int pageSize) {

        String sql = "SELECT activity.*, gift.* , giftrecord.*, giftshopreleaserecord.*, 0 AS goodId FROM giftrecord " +
                " LEFT JOIN giftshopreleaserecord ON giftrecord.recordId = giftshopreleaserecord.giftRecordId " +
                "LEFT JOIN gift ON giftrecord.giftId = gift.giftId " +
                "LEFT JOIN activity ON giftrecord.actno = activity.actno" +
                " WHERE giftrecord.userid=:userid AND gift.giftType in (:giftTypeParamSet) AND giftrecord.isshow='1' "+
                " ORDER BY giftrecord.recordTime DESC LIMIT :pageNo,:pageSize";
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("userid", userId);
        parameters.addValue("giftTypeParamSet", giftTypeParamSet);
        parameters.addValue("pageNo", pageNo);
        parameters.addValue("pageSize", pageSize);
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(getDataSource());
        return namedParameterJdbcTemplate.query(sql, parameters, new BeanPropertyRowMapper(object));

    }

    @Override
    public int countUserGiftRecordByGiftType(String userId, Set<String> giftTypeParamSet) {
        String sql = "SELECT count(*) FROM giftrecord " +
                " LEFT JOIN gift ON giftrecord.giftId = gift.giftId " +
                " WHERE giftrecord.userid=:userid AND gift.giftType in (:giftTypeParamSet) AND giftrecord.isshow='1' ";

        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("userid", userId);
        parameters.addValue("giftTypeParamSet", giftTypeParamSet);
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(getDataSource());
        return namedParameterJdbcTemplate.queryForInt(sql, parameters);
    }

    @Override
    public int countJiFenShopGiftRecord( String userId, Set<String> giftTypeParamSet) {
        String sql = "SELECT count(*) FROM giftrecord " +
                " LEFT JOIN gift ON giftrecord.giftId = gift.giftId " +
                " WHERE giftrecord.userid=:userid AND gift.giftType in (:giftTypeParamSet) AND giftrecord.isshow='1' "+
                " AND EXISTS (SELECT 1 FROM activity_category WHERE giftrecord.actNo = activity_category.actNo AND activity_category.is_bonusshop = 1) ";

        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("userid", userId);
        parameters.addValue("giftTypeParamSet", giftTypeParamSet);
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(getDataSource());
        return namedParameterJdbcTemplate.queryForInt(sql, parameters);
    }


}
