package com.xunlei.niux.data.vipgame.bo.bonus;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.annotation.Resource;

import org.springframework.stereotype.Service;

import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.vo.bonus.AuctionProduct;
import com.xunlei.niux.data.vipgame.vo.bonus.BaseProduct;

@Service
public class AuctionProductBoImpl implements AuctionProductBo {
	private static SimpleDateFormat sdf=new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
	@Resource(name="BaseDao")
	private BaseDao baseDao;

	public BaseDao getBaseDao() {
		return baseDao;
	}

	public void setBaseDao(BaseDao baseDao) {
		this.baseDao = baseDao;
	}
	public AuctionProduct findOne(long auctionProductId){
		return baseDao.findById(AuctionProduct.class, auctionProductId);
	}
	public List<AuctionProduct> finds(AuctionProduct product,Page page){
		return baseDao.findByObject(AuctionProduct.class, product, page);
	}
	public int count(AuctionProduct product){
		return baseDao.count(product);
	}
	public void insert(AuctionProduct auctionProduct){
		//获取baseProduct
		BaseProduct baseProduct=baseDao.findById(BaseProduct.class, auctionProduct.getBaseProductId());
		if(baseProduct==null){
			throw new RuntimeException("产品类型编码["+auctionProduct.getBaseProductId()+"]不存在");
		}
		auctionProduct.setProductType(baseProduct.getProductType());
		if(baseProduct.getIsFixedBaseUnitNum()){
			auctionProduct.setBaseUnitNum(baseProduct.getBaseUnitNum());
		}
		auctionProduct.setBiddedUserNum(0);
		auctionProduct.setBiddedMinBonusNum(0);
		auctionProduct.setAuctionTimes(0);
		if(auctionProduct.getAuctionProductNum()==null){
			auctionProduct.setAuctionProductNum(0);
		}
		checkAuctionProductValid(auctionProduct);
		baseDao.insert(auctionProduct);
	}
	public void updateSomeInfo(AuctionProduct auctionProduct){
		AuctionProduct targetAuctionProduct=lockQueryAuctionProduct(auctionProduct.getAuctionProductId());
		if(targetAuctionProduct==null){
			throw new RuntimeException("竞拍产品Id["+auctionProduct.getAuctionProductId()+"对应产品不存在");
		}
		int status=auctionProductStatus(targetAuctionProduct);
		if(status==0){
			BaseProduct baseProduct=baseDao.findById(BaseProduct.class, auctionProduct.getBaseProductId());
			targetAuctionProduct.setProductType(baseProduct.getProductType());
			if(baseProduct.getIsFixedBaseUnitNum()){
				targetAuctionProduct.setBaseUnitNum(baseProduct.getBaseUnitNum());
			}else{
				targetAuctionProduct.setBaseUnitNum(auctionProduct.getBaseUnitNum());
			}
			targetAuctionProduct.setProductName(auctionProduct.getProductName());
			targetAuctionProduct.setAuctionProductNum(auctionProduct.getAuctionProductNum());
			targetAuctionProduct.setGameId(auctionProduct.getGameId());
			targetAuctionProduct.setProductLot(auctionProduct.getProductLot());
			targetAuctionProduct.setBaseBonusNum(auctionProduct.getBaseBonusNum());
			targetAuctionProduct.setOneAddBonusNum(auctionProduct.getOneAddBonusNum());
			targetAuctionProduct.setStartAuctionTime(auctionProduct.getStartAuctionTime());
			targetAuctionProduct.setEndAuctionTime(auctionProduct.getEndAuctionTime());
			targetAuctionProduct.setIsSelectFenQu(auctionProduct.getIsSelectFenQu());
			targetAuctionProduct.setIsSelectRole(auctionProduct.getIsSelectRole());
		}else if(status==1){
			//竞拍中
			targetAuctionProduct.setEndAuctionTime(auctionProduct.getEndAuctionTime());
		}
		checkAuctionProductValid(targetAuctionProduct);
		targetAuctionProduct.setPicUrl(auctionProduct.getPicUrl());
		targetAuctionProduct.setSimpleDesc(auctionProduct.getSimpleDesc());
		targetAuctionProduct.setDetailedDesc(auctionProduct.getDetailedDesc());
		targetAuctionProduct.setDisplaySort(auctionProduct.getDisplaySort());
		targetAuctionProduct.setIsDisplay(auctionProduct.getIsDisplay());
		targetAuctionProduct.setEditBy(auctionProduct.getEditBy());
		targetAuctionProduct.setEditTime(auctionProduct.getEditTime());
		baseDao.updateById(targetAuctionProduct);
	}
	private void checkAuctionProductValid(final AuctionProduct auctionProduct){
		if(auctionProduct.getBaseUnitNum()==null||auctionProduct.getBaseUnitNum().doubleValue()<=0.0){
			throw new RuntimeException("基本单位数目必须大于0");
		}
		if(auctionProduct.getProductName()==null||"".equals(auctionProduct.getProductName())){
			throw new RuntimeException("名字不能为空");
		}
		if(auctionProduct.getAuctionProductNum()==null){
			throw new RuntimeException("竞拍商品数不能为空");
		}
		if(auctionProduct.getBaseBonusNum()==null||auctionProduct.getBaseBonusNum()<=0){
			throw new RuntimeException("底价必须大于0");
		}
		if(auctionProduct.getOneAddBonusNum()==null||auctionProduct.getOneAddBonusNum()<=0){
			throw new RuntimeException("每次加价必须大于0");
		}
		if(auctionProduct.getStartAuctionTime()==null||"".equals(auctionProduct.getStartAuctionTime())){
			throw new RuntimeException("开拍时间不能为空");
		}
		if(auctionProduct.getEndAuctionTime()==null||"".equals(auctionProduct.getEndAuctionTime())){
			throw new RuntimeException("结束竞拍时间不能为空");
		}
		if(auctionProduct.getStartAuctionTime().compareTo(auctionProduct.getEndAuctionTime())>=0){
			throw new RuntimeException("竞拍结束时间必须大于开拍时间");
		}
	}
	public void delete(long auctionProductId){
		AuctionProduct auctionProduct=lockQueryAuctionProduct(auctionProductId);
		int status=auctionProductStatus(auctionProduct);
		if(status==0){
			baseDao.deleteById(AuctionProduct.class, auctionProductId);
			return;
		}
		throw new RuntimeException("竞拍状态："+status+"处于竞拍阶段或者一结束竞拍");
	}
	/**
	 * 判断竞拍状态；0：未开拍；1：竞拍中；2：已结束
	 * @param auctionProduct
	 * @return
	 */
	public int auctionProductStatus(AuctionProduct auctionProduct){
		String nowStr=sdf.format(new Date());
		if(auctionProduct.getStartAuctionTime().compareTo(nowStr)>0){
			return 0;
		}
		if(auctionProduct.getEndAuctionTime().compareTo(nowStr)>0){
			return 1;
		}
		return 2;
	}
	public AuctionProduct lockQueryAuctionProduct(long auctionProductId){
		String sql="select * from auctionproduct where auctionProductId=? for update";
		List<Object> paramList=new ArrayList<Object>();
		paramList.add(auctionProductId);
		List<AuctionProduct> list=baseDao.executeQuery(AuctionProduct.class, sql, paramList);
		return (list==null||list.size()==0)?null:list.get(0);
	}
}
