package com.xunlei.niux.data.vipgame.bo.moyu;

import com.ferret.common.dao.BaseDao;

import java.util.ArrayList;

/**
 * @author hezhong
 */
public class MoyuReportBoImpl implements MoyuReportBo {

    private BaseDao baseDao;

    public BaseDao getBaseDao() {
        return baseDao;
    }

    public void setBaseDao(BaseDao baseDao) {
        this.baseDao = baseDao;
    }

    @Override
    public void execDayReport() {
        baseDao.execute(DAY_SQL, new ArrayList<Object>());
    }

    @Override
    public void execTotalReport(String actno) {
        final ArrayList<Object> params = new ArrayList<Object>();
        baseDao.execute("TRUNCATE TABLE mytotalreport", params);

        baseDao.execute(this.TOTAL_SQL, params);

    }

    @Override
    public void execGiftDetail() {
        baseDao.execute(this.DETAIL_SQL, new ArrayList<Object>() );
    }


    private static final String TOTAL_SQL ="INSERT INTO mytotalreport ( " +
            "  actno, " +
            "  usernum, " +
            "  money, " +
            "  gift1, " +
            "  gift2, " +
            "  gift3, " +
            "  gift4, " +
            "  gift5, " +
            "  gift6, " +
            "  gift7 " +
            ")  " +
            "SELECT  " +
            "  j.actno actno, " +
            "  COUNT(DISTINCT j.userid) AS usernum, " +
            "  SUM(j.rechargeMoney) AS money, " +
            "  IFNULL(SUM(exchange.gift1), 0) AS gift1, " +
            "  IFNULL(SUM(exchange.gift2), 0) AS gift2, " +
            "  IFNULL(SUM(exchange.gift3), 0) AS gift3, " +
            "  IFNULL(SUM(exchange.gift4), 0) AS gift4, " +
            "  IFNULL(SUM(exchange.gift5), 0) AS gift5, " +
            "  IFNULL(SUM(exchange.gift6), 0) AS gift6, " +
            "  IFNULL(SUM(exchange.gift7), 0) AS gift7  " +
            "FROM " +
            "  myjifen j, " +
            "  (SELECT  " +
            "    t.jifenid AS jifenid, " +
            "    SUM(t.gift1) AS gift1, " +
            "    SUM(t.gift2) AS gift2, " +
            "    SUM(t.gift3) AS gift3, " +
            "    SUM(t.gift4) AS gift4, " +
            "    SUM(t.gift5) AS gift5, " +
            "    SUM(t.gift6) AS gift6, " +
            "    SUM(t.gift7) AS gift7  " +
            "  FROM " +
            "    (SELECT  " +
            "      jifenid, " +
            "      CASE " +
            "        giftno  " +
            "        WHEN '1501417'  " +
            "        THEN 1  " +
            "        ELSE 0  " +
            "      END AS gift1, " +
            "      CASE " +
            "        giftno  " +
            "        WHEN '1501416'  " +
            "        THEN 1  " +
            "        ELSE 0  " +
            "      END AS gift2, " +
            "      CASE " +
            "        giftno  " +
            "        WHEN '1501411'  " +
            "        THEN 1  " +
            "        ELSE 0  " +
            "      END AS gift3, " +
            "      CASE " +
            "        giftno  " +
            "        WHEN '1501412'  " +
            "        THEN 1  " +
            "        ELSE 0  " +
            "      END AS gift4, " +
            "      CASE " +
            "        giftno  " +
            "        WHEN '1501413'  " +
            "        THEN 1  " +
            "        ELSE 0  " +
            "      END AS gift5, " +
            "      CASE " +
            "        giftno  " +
            "        WHEN '1501414'  " +
            "        THEN 1  " +
            "        ELSE 0  " +
            "      END AS gift6, " +
            "      CASE " +
            "        giftno  " +
            "        WHEN '1501415'  " +
            "        THEN 1  " +
            "        ELSE 0  " +
            "      END AS 'gift7'  " +
            "    FROM " +
            "      myexchange  " +
            "    WHERE STATUS = 1) AS t  " +
            "  GROUP BY t.jifenid) exchange  " +
            "WHERE j.jifenid = exchange.jifenid  " +
            "GROUP BY j.actno";

    private static final String DAY_SQL = "INSERT INTO mydayreport ( " +
            "  reporttime, " +
            "  actno, " +
            "  usernum, " +
            "  money, " +
            "  gift1, " +
            "  gift2, " +
            "  gift3, " +
            "  gift4, " +
            "  gift5, " +
            "  gift6, " +
            "  gift7 " +
            ")  " +
            "SELECT  " +
            "  DATE_FORMAT(SUBDATE(NOW(), 1), '%Y-%m-%d') TIME, " +
            "  j.actno actno, " +
            "  COUNT(DISTINCT j.userid) AS usernum, " +
            "  SUM(t.money) money, " +
            "  SUM(t.gift1) AS gift1, " +
            "  SUM(t.gift2) AS gift2, " +
            "  SUM(t.gift3) AS gift3, " +
            "  SUM(t.gift4) AS gift4, " +
            "  SUM(t.gift5) AS gift5, " +
            "  SUM(t.gift6) AS gift6, " +
            "  SUM(t.gift7) AS gift7  " +
            "FROM " +
            "  (SELECT  " +
            "    exchange.*, " +
            "    IFNULL(h.num, 0) money  " +
            "  FROM " +
            "    (SELECT  " +
            "      t.jifenid AS jifenid, " +
            "      SUM(t.gift1) AS gift1, " +
            "      SUM(t.gift2) AS gift2, " +
            "      SUM(t.gift3) AS gift3, " +
            "      SUM(t.gift4) AS gift4, " +
            "      SUM(t.gift5) AS gift5, " +
            "      SUM(t.gift6) AS gift6, " +
            "      SUM(t.gift7) AS gift7  " +
            "    FROM " +
            "      (SELECT  " +
            "        jifenid, " +
            "        CASE " +
            "          giftno  " +
            "          WHEN '1501417'  " +
            "          THEN 1  " +
            "          ELSE 0  " +
            "        END AS 'gift1', " +
            "        CASE " +
            "          giftno  " +
            "          WHEN '1501416'  " +
            "          THEN 1  " +
            "          ELSE 0  " +
            "        END AS 'gift2', " +
            "        CASE " +
            "          giftno  " +
            "          WHEN '1501411'  " +
            "          THEN 1  " +
            "          ELSE 0  " +
            "        END AS 'gift3', " +
            "        CASE " +
            "          giftno  " +
            "          WHEN '1501412'  " +
            "          THEN 1  " +
            "          ELSE 0  " +
            "        END AS 'gift4', " +
            "        CASE " +
            "          giftno  " +
            "          WHEN '1501413'  " +
            "          THEN 1  " +
            "          ELSE 0  " +
            "        END AS 'gift5', " +
            "        CASE " +
            "          giftno  " +
            "          WHEN '1501414'  " +
            "          THEN 1  " +
            "          ELSE 0  " +
            "        END AS 'gift6', " +
            "        CASE " +
            "          giftno  " +
            "          WHEN '1501415'  " +
            "          THEN 1  " +
            "          ELSE 0  " +
            "        END AS 'gift7'  " +
            "      FROM " +
            "        myexchange  " +
            "      WHERE exchangetime >= CONCAT( " +
            "          DATE_FORMAT(SUBDATE(NOW(), 1), '%Y-%m-%d'), " +
            "          ' 00:00:00' " +
            "        )  " +
            "        AND exchangetime < CONCAT( " +
            "          DATE_FORMAT(NOW(), '%Y-%m-%d'), " +
            "          ' 00:00:00' " +
            "        )  " +
            "        AND STATUS = 1) AS t  " +
            "    GROUP BY t.jifenid) exchange  " +
            "    LEFT JOIN  " +
            "      (SELECT  " +
            "        jifenid, " +
            "        SUM(thisjifennum) num  " +
            "      FROM " +
            "        myjifenhistory  " +
            "      WHERE recordtime >= CONCAT( " +
            "          DATE_FORMAT(SUBDATE(NOW(), 1), '%Y-%m-%d'), " +
            "          ' 00:00:00' " +
            "        )  " +
            "        AND recordtime < CONCAT( " +
            "          DATE_FORMAT(NOW(), '%Y-%m-%d'), " +
            "          ' 00:00:00' " +
            "        )  " +
            "        AND thisjifennum > 0  " +
            "      GROUP BY jifenid) h  " +
            "      ON exchange.jifenid = h.jifenid) t, " +
            "  myjifen j  " +
            "WHERE t.jifenid = j.jifenid  " +
            "GROUP BY j.actno ";


    private final static String DETAIL_SQL = "INSERT INTO mydetailreport ( " +
            "  reporttime, " +
            "  actno, " +
            "  username, " +
            "  servername, " +
            "  LEVEL, " +
            "  gift " +
            ")  " +
            "(SELECT  " +
            "  DATE_FORMAT(SUBDATE(NOW(), 1), '%Y-%m-%d') reporttime, " +
            "  j.actno, " +
            "  j.username, " +
            "  s.areaname, " +
            "  j.levelnum, " +
            "  g.gift  " +
            "FROM " +
            "  myjifen j, " +
            "  (SELECT  " +
            "    t.jifenid jifenid, " +
            "    GROUP_CONCAT(t.gift) gift  " +
            "  FROM " +
            "    (SELECT  " +
            "      jifenid, " +
            "      CASE " +
            "        giftno  " +
            "        WHEN '1501417'  " +
            "        THEN '暗夜魔晶礼包'  " +
            "        WHEN '1501416'  " +
            "        THEN '勇者特权礼包'  " +
            "        WHEN '1501411'  " +
            "        THEN '135新魔石'  " +
            "        WHEN '1501412'  " +
            "        THEN '405点新魔石'  " +
            "        WHEN '1501413'  " +
            "        THEN '1650点新魔石'  " +
            "        WHEN '1501414'  " +
            "        THEN '4140点新魔石'  " +
            "        WHEN '1501415'  " +
            "        THEN '8280点新魔石'  " +
            "      END AS gift  " +
            "    FROM " +
            "      myexchange  " +
            "    WHERE exchangetime >= CONCAT( " +
            "        DATE_FORMAT(SUBDATE(NOW(), 1), '%Y-%m-%d'), " +
            "        ' 00:00:00' " +
            "      )  " +
            "      AND exchangetime < CONCAT( " +
            "        DATE_FORMAT(NOW(), '%Y-%m-%d'), " +
            "        ' 00:00:00' " +
            "      ) AND status = 1 " +
            "      ) t  " +
            "  GROUP BY t.jifenid) g, " +
            "  myserver s  " +
            "WHERE g.jifenid = j.jifenid  " +
            "  AND j.serverid = s.serverid)";
}
