package com.xunlei.niux.data.vipgame.bo.bonus;

import com.xunlei.niux.data.vipgame.vo.bonus.BonusProductGiveOutDayStatistics;

public interface BonusProductGiveOutDayStatisticsBo {
	/**
	 * 查询积分兑换产品数目日统计
	 * @param productNo 产品编号
	 * @param giveOutDate 发放日期
	 * @return  日统计信息
	 */
	BonusProductGiveOutDayStatistics find(String productNo,String giveOutDate);
	/**
	 * 增加一个单位的统计数
	 * @param productNo 产品编号
	 * @param giveOutDate 发放日期
	 * @return 增加后的日统计信息
	 */
	BonusProductGiveOutDayStatistics update_addOne(String productNo,String giveOutDate);
	/**
	 * 减少日统计的一个单位
	 * @param productNo 产品编号
	 * @param giveOutDate 发放日期
	 * @return 减少后的日统计信息
	 */
	BonusProductGiveOutDayStatistics update_removeOne(String productNo,String giveOutDate);
}
