/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.data.vipgame.bo.bonus;

import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.common.exception.NiuRuntimeException;
import com.xunlei.niux.data.vipgame.bo.bonus.AuctionRecordBo;
import com.xunlei.niux.data.vipgame.vo.bonus.AuctionProduct;
import com.xunlei.niux.data.vipgame.vo.bonus.AuctionRecord;
import com.xunlei.niux.easyutils.commonutils.OrderNoUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class AuctionRecordBoImpl
implements AuctionRecordBo {
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    @Resource(name="BaseDao")
    private BaseDao baseDao;

    public BaseDao getBaseDao() {
        return this.baseDao;
    }

    public void setBaseDao(BaseDao baseDao) {
        this.baseDao = baseDao;
    }

    @Override
    public AuctionRecord insertAuctionRecord(AuctionRecord precord) {
        AuctionProduct product = this.lockAndFindAuctionProduct(precord.getAuctionProductId());
        this.checkProductCanAuctionUseTheBonusNum(product, precord.getBonusNum());
        AuctionRecord userLastValidAuctionRecord = this.getUserLastValidAuctionRecord(precord.getUserId(), precord.getAuctionProductId());
        if (userLastValidAuctionRecord != null && userLastValidAuctionRecord.getIsBidded().booleanValue() && !"2".equals(userLastValidAuctionRecord.getBonusStatus())) {
            throw new NiuRuntimeException("1051", "\u5b58\u5728\u5f85\u5904\u7406\u7684\u5355\u636e");
        }
        int thisBonusNum = precord.getBonusNum();
        if (userLastValidAuctionRecord != null && userLastValidAuctionRecord.getIsBidded().booleanValue()) {
            thisBonusNum = precord.getBonusNum() - userLastValidAuctionRecord.getBonusNum();
        }
        if (thisBonusNum <= 0) {
            throw new NiuRuntimeException("1050", "\u79ef\u5206\u4e0d\u80fd\u4e2d\u6807");
        }
        if (userLastValidAuctionRecord != null) {
            userLastValidAuctionRecord.setIsValid(false);
            this.update(userLastValidAuctionRecord);
        }
        AuctionRecord thisAuctionRecord = new AuctionRecord();
        thisAuctionRecord.setAuctionNo(OrderNoUtil.getOrderNo());
        thisAuctionRecord.setAuctionTime(sdf.format(new Date()));
        thisAuctionRecord.setUserId(precord.getUserId());
        thisAuctionRecord.setBonusNum(precord.getBonusNum());
        thisAuctionRecord.setThisBonusNum(thisBonusNum);
        thisAuctionRecord.setBaseUnitNum(product.getBaseUnitNum());
        thisAuctionRecord.setAuctionProductId(precord.getAuctionProductId());
        thisAuctionRecord.setProductLot(product.getProductLot() == null ? "" : product.getProductLot());
        thisAuctionRecord.setGameId(product.getGameId() == null ? "" : product.getGameId());
        thisAuctionRecord.setProductType(product.getProductType() == null ? "" : product.getProductType());
        thisAuctionRecord.setRoleId(precord.getRoleId());
        thisAuctionRecord.setRemark("");
        thisAuctionRecord.setAuctionIp(precord.getAuctionIp());
        thisAuctionRecord.setIsValid(true);
        thisAuctionRecord.setIsBidded(true);
        thisAuctionRecord.setBonusStatus("1");
        thisAuctionRecord.setGiveOutProductStatus("1");
        thisAuctionRecord.setGiveOutFailCause("");
        thisAuctionRecord.setActNo(precord.getActNo());
        thisAuctionRecord.setUserName(precord.getUserName());
        this.baseDao.insert((Object)thisAuctionRecord);
        product = this.setBidderUserNumAndMinBiddedBonus(product);
        return this.findOne(thisAuctionRecord.getAuctionNo());
    }

    @Override
    public AuctionRecord updateConsumeBonusResult(String auctionNo, boolean isSuccess, String msg) {
        if (isSuccess) {
            return this.updateConsumeBonusResult_success(auctionNo);
        }
        return this.updateConsumeBonusResult_fail(auctionNo, msg);
    }

    public AuctionRecord updateConsumeBonusResult_success(String auctionNo) {
        AuctionRecord actionRecord = this.findOne(auctionNo);
        actionRecord.setBonusStatus("2");
        this.baseDao.updateById((Object)actionRecord);
        AuctionProduct product = this.lockAndFindAuctionProduct(actionRecord.getAuctionProductId());
        product.setAuctionTimes(product.getAuctionTimes() + 1);
        this.baseDao.updateById((Object)product);
        this.updatePassAuctionNumRecordSetNotBid(product);
        return actionRecord;
    }

    public AuctionRecord updateConsumeBonusResult_fail(String auctionNo, String msg) {
        AuctionRecord actionRecord = this.findOne(auctionNo);
        AuctionProduct product = this.lockAndFindAuctionProduct(actionRecord.getAuctionProductId());
        actionRecord.setBonusStatus("5");
        actionRecord.setIsValid(false);
        actionRecord.setIsBidded(false);
        msg = msg == null ? "" : msg;
        msg = msg.length() > 255 ? msg.substring(0, 255) : msg;
        actionRecord.setGiveOutFailCause(msg);
        this.baseDao.updateById((Object)actionRecord);
        AuctionRecord userLastAuctionRecord = this.getUserlastAuctionRecord(actionRecord.getUserId(), product.getAuctionProductId());
        if (userLastAuctionRecord != null) {
            userLastAuctionRecord.setIsValid(true);
            this.baseDao.updateById((Object)userLastAuctionRecord);
        }
        product = this.setBidderUserNumAndMinBiddedBonus(product);
        this.updatePassAuctionNumRecordSetNotBid(product);
        return actionRecord;
    }

    @Override
    public AuctionRecord getUserLastValidAndBiddedAuctionRecord(String userId, Long auctionProductId) {
        AuctionRecord query = new AuctionRecord();
        query.setUserId(userId);
        query.setAuctionProductId(auctionProductId);
        query.setIsBidded(true);
        query.setIsValid(true);
        Page page = new Page();
        page.setPageNo(1);
        page.setPageSize(1);
        page.addOrder("auctionTime", OrderType.DESC);
        List<AuctionRecord> list = this.finds(query, page);
        return list == null || list.size() == 0 ? null : list.get(0);
    }

    @Override
    public AuctionRecord getUserLastValidAuctionRecord(String userId, Long auctionProductId) {
        AuctionRecord query = new AuctionRecord();
        query.setUserId(userId);
        query.setAuctionProductId(auctionProductId);
        query.setIsValid(true);
        Page page = new Page();
        page.setPageNo(1);
        page.setPageSize(1);
        page.addOrder("auctionTime", OrderType.DESC);
        List<AuctionRecord> list = this.finds(query, page);
        return list == null || list.size() == 0 ? null : list.get(0);
    }

    public AuctionRecord getUserLastBiddedAuctionRecord(String userId, Long auctionProductId) {
        AuctionRecord query = new AuctionRecord();
        query.setUserId(userId);
        query.setAuctionProductId(auctionProductId);
        query.setIsBidded(true);
        Page page = new Page();
        page.setPageNo(1);
        page.setPageSize(1);
        page.addOrder("auctionTime", OrderType.DESC);
        List<AuctionRecord> list = this.finds(query, page);
        return list == null || list.size() == 0 ? null : list.get(0);
    }

    private AuctionProduct setBidderUserNumAndMinBiddedBonus(AuctionProduct product) {
        AuctionRecord query = new AuctionRecord();
        query.setAuctionProductId(product.getAuctionProductId());
        query.setIsValid(true);
        query.setIsBidded(true);
        int count = this.baseDao.count((Object)query);
        int biddedUserNum = count > product.getAuctionProductNum() ? product.getAuctionProductNum() : count;
        int biddedMinBonusNum = product.getBaseBonusNum();
        if (count >= product.getAuctionProductNum()) {
            AuctionRecord latestAuctionRecord = this.findSortLastestBiddedRecord(product);
            biddedMinBonusNum = latestAuctionRecord.getBonusNum();
        }
        product.setBiddedMinBonusNum(biddedMinBonusNum);
        product.setBiddedUserNum(biddedUserNum);
        this.baseDao.updateById((Object)product);
        return product;
    }

    public void updatePassAuctionNumRecordSetNotBid(AuctionProduct product) {
        AuctionRecord query = new AuctionRecord();
        query.setAuctionProductId(product.getAuctionProductId());
        query.setIsValid(true);
        query.setIsBidded(true);
        query.setBonusStatus("2");
        Page page = new Page();
        page.setPageNo(2);
        page.setPageSize(product.getAuctionProductNum().intValue());
        page.addOrder("bonusNum", OrderType.DESC);
        page.addOrder("auctionTime", OrderType.ESC);
        List arlist = this.baseDao.findByObject(AuctionRecord.class, (Object)query, page);
        if (arlist == null || arlist.size() == 0) {
            return;
        }
        for (AuctionRecord ar : arlist) {
            StringBuilder sb = new StringBuilder();
            sb.append("update auctionrecord set isBidded=false,bonusStatus='3' where userId='").append(ar.getUserId()).append("' and isBidded=true and auctionProductId=").append(ar.getAuctionProductId());
            this.baseDao.execute(sb.toString(), new ArrayList());
        }
    }

    @Override
    public int count(AuctionRecord record) {
        return this.baseDao.count((Object)record);
    }

    @Override
    public void update(AuctionRecord record) {
        this.baseDao.updateById((Object)record);
    }

    @Override
    public void checkProductCanAuctionUseTheBonusNum(AuctionProduct product, Integer bonusNum) {
        this.checkProudctInAuctionValidate(product);
        Integer biddedMinBonusNum = product.getBaseBonusNum();
        if (product.getBiddedUserNum() >= product.getAuctionProductNum()) {
            biddedMinBonusNum = product.getBiddedMinBonusNum() + product.getOneAddBonusNum();
        }
        if (biddedMinBonusNum > bonusNum) {
            throw new NiuRuntimeException("1050", "\u51fa\u4ef7[" + bonusNum + "]\u4f4e\u4e8e\u6700\u4f4e\u4e2d\u6807\u4ef7");
        }
        if (product.getOneAddBonusNum() > 0 && (bonusNum - product.getBaseBonusNum()) % product.getOneAddBonusNum() > 0) {
            throw new NiuRuntimeException("1060", "\u975e\u6cd5\u4ef7\u683c");
        }
    }

    private void checkProudctInAuctionValidate(AuctionProduct product) {
        Date now = new Date();
        String nowStr = sdf.format(now);
        if (nowStr.compareTo(product.getStartAuctionTime()) < 0) {
            throw new NiuRuntimeException("1052", "\u4ea7\u54c1[" + product.getProductName() + "]\u7ade\u62cd\u672a\u5f00\u59cb\uff0c\u5f00\u59cb\u65f6\u95f4[" + product.getStartAuctionTime() + "]");
        }
        if (nowStr.compareTo(product.getEndAuctionTime()) > 0) {
            throw new NiuRuntimeException("1053", "\u4ea7\u54c1[" + product.getProductName() + "]\u7ade\u62cd\u5df2\u7ed3\u675f\uff0c\u7ed3\u675f\u65f6\u95f4[" + product.getEndAuctionTime() + "]");
        }
    }

    public AuctionRecord getUserlastAuctionRecord(String userId, Long auctionProductId) {
        AuctionRecord query = new AuctionRecord();
        query.setUserId(userId);
        query.setAuctionProductId(auctionProductId);
        Page page = new Page();
        page.setPageNo(1);
        page.setPageSize(1);
        page.addOrder("auctionTime", OrderType.DESC);
        List<AuctionRecord> list = this.finds(query, page);
        return list == null || list.size() == 0 ? null : list.get(0);
    }

    @Override
    public List<AuctionRecord> finds(AuctionRecord query, Page page) {
        return this.baseDao.findByObject(AuctionRecord.class, (Object)query, page);
    }

    @Override
    public AuctionRecord findOne(String auctionNo) {
        AuctionRecord query = new AuctionRecord();
        query.setAuctionNo(auctionNo);
        List<AuctionRecord> arlist = this.finds(query, new Page());
        return arlist == null || arlist.size() == 0 ? null : arlist.get(0);
    }

    public AuctionRecord findSortLastestBiddedRecord(AuctionProduct product) {
        AuctionRecord query = new AuctionRecord();
        query.setAuctionProductId(product.getAuctionProductId());
        query.setIsValid(true);
        query.setIsBidded(true);
        Page page = new Page();
        page.setPageNo(product.getAuctionProductNum().intValue());
        page.setPageSize(1);
        page.addOrder("bonusNum", OrderType.DESC);
        page.addOrder("auctionTime", OrderType.ESC);
        List<AuctionRecord> list = this.finds(query, page);
        return list == null || list.size() == 0 ? null : list.get(0);
    }

    public AuctionProduct lockAndFindAuctionProduct(long auctionProductId) {
        return (AuctionProduct)this.baseDao.findById(AuctionProduct.class, (Number)auctionProductId);
    }

    @Override
    public long updateTimestamp(long seqId) {
        long timestamp = System.currentTimeMillis();
        AuctionRecord record = (AuctionRecord)this.baseDao.findById(AuctionRecord.class, (Number)seqId);
        if (record.getTimestamp() != null && timestamp - record.getTimestamp() < 10000L) {
            throw new NiuRuntimeException("1059", "\u5151\u6362\u592a\u9891\u7e41");
        }
        record.setTimestamp(timestamp);
        this.baseDao.updateById((Object)record);
        return timestamp;
    }
}

