package com.xunlei.niux.data.vipgame.dto.game;

import com.ferret.common.dao.annotation.Column;
import com.ferret.common.dao.annotation.Exclude;
import com.xunlei.niux.data.vipgame.vo.LinkInfo;
import com.xunlei.niux.easyutils.commonutils.NumParseUtil;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by jamesjxin on 15-3-17.
 */

public class GameDTO {
    private String gameId;
    private String gameNo;
    private String gameName;
    private String gameDesc;
    private Integer gameFeature;
    private String officialWebSite;
    private String picUrl;
    private String smallPicUrl;
    private Integer displayOrder;
    private Integer mobileGameType;
    private String summary;
    private String packageName;

    //扩展字段
    private String appSize;
    private String downLoadUrl;
    private Integer downloadNum;
    private String mulPhotoUrl;
    
    //增加字段
    private Boolean isHotOrNew;//是否最新或者最热
    private Boolean hasGift;//是否有礼包
    private String runType;//是否独家

    private Boolean isFirstPublish;

    private String videoUrl;
    private String videoDetailPicUrl;
    private boolean isH5Game;
    
    public Boolean getIsHotOrNew() {
		return isHotOrNew;
	}

	public void setIsHotOrNew(Boolean isHotOrNew) {
		this.isHotOrNew = isHotOrNew;
	}

	public Boolean getHasGift() {
		return hasGift;
	}

	public void setHasGift(Boolean hasGift) {
		this.hasGift = hasGift;
	}

	public String getRunType() {
		return runType;
	}

	public void setRunType(String runType) {
		this.runType = runType;
	}

	public Integer getDownloadNum() {
        return downloadNum;
    }

    public void setDownloadNum(Integer downloadNum) {
        this.downloadNum = downloadNum;
    }

    public String getDownLoadUrl() {
        return downLoadUrl;
    }

    public void setDownLoadUrl(String downLoadUrl) {
        this.downLoadUrl = downLoadUrl;
    }

    public String getGameDesc() {
        return gameDesc;
    }

    public void setGameDesc(String gameDesc) {
        this.gameDesc = gameDesc;
    }

    public String getGameId() {
        return gameId;
    }

    public void setGameId(String gameId) {
        this.gameId = gameId;
    }

    public String getGameName() {
        return gameName;
    }

    public void setGameName(String gameName) {
        this.gameName = gameName;
    }

    public String getGameNo() {
        return gameNo;
    }

    public void setGameNo(String gameNo) {
        this.gameNo = gameNo;
    }

    public String getMulPhotoUrl() {
        return mulPhotoUrl;
    }

    public void setMulPhotoUrl(String mulPhotoUrl) {
        this.mulPhotoUrl = mulPhotoUrl;
    }

    public String getOfficialWebSite() {
        return officialWebSite;
    }

    public void setOfficialWebSite(String officialWebSite) {
        this.officialWebSite = officialWebSite;
    }

    public String getPicUrl() {
        return picUrl;
    }

    public void setPicUrl(String picUrl) {
        this.picUrl = picUrl;
    }

    public String getSmallPicUrl() {
        return smallPicUrl;
    }

    public void setSmallPicUrl(String smallPicUrl) {
        this.smallPicUrl = smallPicUrl;
    }

    public String getAppSize() {
        return appSize;
    }

    public void setAppSize(String appSize) {
        this.appSize = appSize;
    }

    public Integer getGameFeature() {
        return gameFeature;
    }

    public void setGameFeature(Integer gameFeature) {
        this.gameFeature = gameFeature;
    }

    public Integer getDisplayOrder() {
        return displayOrder;
    }

    public void setDisplayOrder(Integer displayOrder) {
        this.displayOrder = displayOrder;
    }

    public Integer getMobileGameType() {
        return mobileGameType;
    }

    public void setMobileGameType(Integer mobileGameType) {
        this.mobileGameType = mobileGameType;
    }

    public String getSummary() {
        return summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public String getPackageName() {
        return packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public Boolean getIsFirstPublish() {
        return isFirstPublish;
    }

    public void setIsFirstPublish(Boolean firstPublish) {
        isFirstPublish = firstPublish;
    }

    public Map<String,Object> generateAppGameMap(Map<String, LinkInfo> mobileGameDownloadInfoMap){
        Map<String, Object> map = new HashMap<String, Object>();
        String gameId = getGameId();

        map.put("gameId",gameId);
        map.put("gameNo",getGameNo());
        map.put("img", getPicUrl() == null ? "" : getPicUrl());
        map.put("icon", getSmallPicUrl() == null ? "" : getSmallPicUrl());
        map.put("gameName", getGameName());
        map.put("gameDesc", getGameDesc() == null ? "" : getGameDesc());
        map.put("gameFeature",getGameFeature());
        map.put("featureId",getGameFeature());
        map.put("typeId","");
        map.put("gameOfficialLink", getOfficialWebSite() == null ? "" : getOfficialWebSite());

        map.put("downloadLink", getDownLoadUrl()==null?"":getDownLoadUrl());
        map.put("displayOrder",getDisplayOrder());
        map.put("mulPhotoUrl",getMulPhotoUrl());

        if(gameId.startsWith("c")){
            map.put("downloadNum", NumParseUtil.getDownloadNumStr(String.valueOf(getDownloadNum())));
            map.put("fileSize",getAppSize());
        }else {
            LinkInfo gameDownloadInfo = mobileGameDownloadInfoMap.get(getGameId());
            if (gameDownloadInfo == null) {
                map.put("downloadNum", "");
                map.put("fileSize","");
            } else {
                map.put("downloadNum", NumParseUtil.getDownloadNumStr(gameDownloadInfo.getExt1()));
                map.put("fileSize",gameDownloadInfo.getExt2());
            }
        }
        return map;
    }

    public String getVideoUrl() {
        return videoUrl;
    }

    public void setVideoUrl(String videoUrl) {
        this.videoUrl = videoUrl;
    }

    public String getVideoDetailPicUrl() {
        return videoDetailPicUrl;
    }

    public void setVideoDetailPicUrl(String videoDetailPicUrl) {
        this.videoDetailPicUrl = videoDetailPicUrl;
    }

    public boolean getIsH5Game() {
        return isH5Game;
    }

    public void setIsH5Game(boolean isH5Game) {
        this.isH5Game = isH5Game;
    }
}
