package com.xunlei.niux.data.vipgame.bo;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang.StringUtils;

import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.presql.Select;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.dao.TempLateSchemaDao;
import com.xunlei.niux.data.vipgame.vo.TemplateSchema;

public class TemplateSchemaBoImpl implements TemplateSchemaBo {

	private TempLateSchemaDao tempLateSchemaDao;
	private BaseDao baseDao;
	public BaseDao getBaseDao() {
		return baseDao;
	}
	public void setBaseDao(BaseDao baseDao) {
		this.baseDao = baseDao;
	}
	public void setTempLateSchemaDao(TempLateSchemaDao tempLateSchemaDao){
		this.tempLateSchemaDao = tempLateSchemaDao;
	}
	public TempLateSchemaDao getTempLateSchemaDao(){
		return tempLateSchemaDao;
	}

	public int count(TemplateSchema schema) {
		return baseDao.count(schema);
	}

	@Override
	public List<TemplateSchema> getTemplatesByIds(String sechemaIds) {
		return tempLateSchemaDao.geTemplateSchemasByIds(sechemaIds);
	}


	public void delete(Integer schemaid) {
		baseDao.deleteById(TemplateSchema.class, schemaid);

	}

	public TemplateSchema find(Integer schemaid) {
		return baseDao.findById(TemplateSchema.class, schemaid);
	}

	public List<TemplateSchema> find(TemplateSchema schema) {
		return baseDao.findByObject(TemplateSchema.class,schema,new Page());
	}

	public List<TemplateSchema> find(TemplateSchema schema, Page page) {
		return baseDao.findByObject(TemplateSchema.class,schema,page);
	}

	public void insert(TemplateSchema schema) {
		baseDao.insert(schema);
	}

	public void update(TemplateSchema schema) {
		baseDao.updateById(schema);
	}
	@Override
	public void updateRepeats(TemplateSchema schema) {
		List<Object> paramsList = new ArrayList<Object>();
		StringBuffer preSql = new StringBuffer("update templateschema set execstatus=? ,isexecuted=?,exectime = ?,spendtime=?,execfailreason=? where templateid=?  and isexecuted=0 and schematime<=?");
		paramsList.add(schema.getExecstatus());
		paramsList.add(schema.getIsexecuted());
		paramsList.add(schema.getExectime());
		paramsList.add(schema.getSpendtime());
		paramsList.add(schema.getExecfailreason());
		paramsList.add(schema.getTemplateid());
		paramsList.add(schema.getSchematime());
		if(StringUtils.isNotEmpty(schema.getExt1())){
			preSql.append(" and ext1=?");
			paramsList.add(schema.getExt1());
		}else{
			preSql.append(" and (ext1='' or ext1 is NULL)");
		}
		baseDao.execute(preSql.toString(), paramsList);
	}

}
