/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.data.vipgame.dao;

import com.ferret.common.dao.BaseDaoImpl;
import com.xunlei.niux.data.vipgame.dao.MobileGameApkDao;
import com.xunlei.niux.data.vipgame.dto.game.GameDTO;
import com.xunlei.niux.data.vipgame.dto.game.MobileGameDTO;
import com.xunlei.niux.data.vipgame.util.ObjectMapper;
import com.xunlei.niux.data.vipgame.vo.WDJMobileGameApk;
import com.xunlei.niux.data.vipgame.vo.mobilegameapkversion.MobileGameChannelApk;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.core.RowMapper;

public class MobileGameApkDaoImpl
extends BaseDaoImpl
implements MobileGameApkDao {
    @Override
    public List<WDJMobileGameApk> getWDJMobileGameApk(Long apkId, String gameId, String channleApkStatus, int pageNo, int pageSize) {
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT a.gameId,a.apkUrl,a.path,a.apkName,a.packageType,");
        sql.append(" t.channelApkId,t.apkId, t.channelId,t.channelApkName,t.packageTime,");
        sql.append(" t.downLoadLink, t.channleApkStatus,t.testUser,t.testTime,t.submitTestRemark,");
        sql.append(" t.testRemark, t.muliPhotoUrl, t.isWDJGame from mobileGameChannelApk t ");
        sql.append(" left join mobileGameApk a  on t.apkId=a.apkId");
        sql.append(" where t.isWDJGame=1 ");
        if (null != apkId && 0L != apkId) {
            sql.append("  and t.apkId=" + apkId);
        }
        if (StringUtils.isNotEmpty((String)gameId)) {
            sql.append("  and t.channelId='" + gameId + "'");
        }
        if (StringUtils.isNotEmpty((String)channleApkStatus)) {
            sql.append("  and t.channleApkStatus='" + channleApkStatus + "'");
        }
        if (pageSize > 0) {
            int pageStart = (pageNo - 1) * pageSize;
            sql.append(" limit " + pageStart + "," + pageSize);
        }
        return this.findBySql(WDJMobileGameApk.class, sql.toString());
    }

    @Override
    public int countWDJMobileGameApk(Long apkId, String gameId, String channleApkStatus, int pageNo, int pageSize) {
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT count(1) from mobileGameChannelApk t ");
        sql.append(" left join mobileGameApk a  on t.apkId=a.apkId");
        sql.append(" where t.isWDJGame=1 ");
        if (null != apkId && 0L != apkId) {
            sql.append("  and t.apkId=" + apkId);
        }
        if (StringUtils.isNotEmpty((String)gameId)) {
            sql.append("  and t.channelId='" + gameId + "'");
        }
        if (StringUtils.isNotEmpty((String)channleApkStatus)) {
            sql.append("  and t.channleApkStatus='" + channleApkStatus + "'");
        }
        if (pageSize > 0) {
            int pageStart = (pageNo - 1) * pageSize;
            sql.append(" limit " + pageStart + "," + pageSize);
        }
        return this.getJdbcTemplate().queryForInt(sql.toString());
    }

    @Override
    public List<GameDTO> getPhoneGameDto(String gameId, String channelId) {
        GameDTO gameDTO = new GameDTO();
        StringBuffer sql = new StringBuffer();
        sql.append("select * from games \nleft join \n(select a.gameId, ca.muliPhotoUrl, ca.downLoadLink, ca.channelId, ca.muliPhotoUrl as mulPhotoUrl from mobileGameChannelApk ca\nleft join mobileGameApk a\non a.apkId = ca.apkId\n)apkgame\non games.gameId = apkgame.gameId\nwhere games.gameId=? and apkgame.channelId=?;");
        ArrayList<String> list = new ArrayList<String>();
        list.add(gameId);
        list.add(channelId);
        final ArrayList<GameDTO> gameList = new ArrayList<GameDTO>();
        this.getJdbcTemplate().query(sql.toString(), list.toArray(), new RowCallbackHandler(){

            public void processRow(ResultSet resultSet) throws SQLException {
                GameDTO gameDTO = new GameDTO();
                gameDTO.setAppSize(resultSet.getString("appSize"));
                gameDTO.setDisplayOrder(resultSet.getInt("displayOrder"));
                gameDTO.setDownloadNum(resultSet.getInt("downloadNum"));
                gameDTO.setDownLoadUrl(resultSet.getString("downLoadLink"));
                gameDTO.setGameDesc(resultSet.getString("gameDesc"));
                gameDTO.setGameFeature(resultSet.getInt("gameFeature"));
                gameDTO.setGameId(resultSet.getString("gameId"));
                gameDTO.setGameName(resultSet.getString("gameName"));
                gameDTO.setGameNo(resultSet.getString("gameNo"));
                gameDTO.setHasGift(resultSet.getBoolean("hasGift"));
                gameDTO.setIsFirstPublish(resultSet.getBoolean("isFirstPublish"));
                gameDTO.setMobileGameType(resultSet.getInt("mobileGameType"));
                gameDTO.setMulPhotoUrl(resultSet.getString("mulPhotoUrl"));
                gameDTO.setOfficialWebSite(resultSet.getString("officialWebSite"));
                gameDTO.setPackageName(resultSet.getString("packageName"));
                gameDTO.setPicUrl(resultSet.getString("picUrl"));
                gameDTO.setRunType(resultSet.getString("runType"));
                gameDTO.setSmallPicUrl(resultSet.getString("smallPicUrl"));
                gameDTO.setSummary(resultSet.getString("summary"));
                gameList.add(gameDTO);
            }
        });
        return gameList;
    }

    @Override
    public List<MobileGameDTO> getMobileGameDTO(String gameId, String channelId) {
        MobileGameDTO gameDTO = new MobileGameDTO();
        StringBuffer sql = new StringBuffer();
        sql.append("select * from games g\nleft join commonspreadinfo c\non g.gameId = c.gameId\nwhere c.advNo=? and g.gameId=?\norder by c.recordTime desc");
        ArrayList<String> list = new ArrayList<String>();
        list.add(channelId);
        list.add(gameId);
        final ArrayList<MobileGameDTO> gameList = new ArrayList<MobileGameDTO>();
        this.getJdbcTemplate().query(sql.toString(), list.toArray(), new RowCallbackHandler(){

            public void processRow(ResultSet resultSet) throws SQLException {
                MobileGameDTO gameDTO = new MobileGameDTO();
                gameDTO.setAppSize(resultSet.getString("appSize"));
                gameDTO.setDisplayOrder(resultSet.getInt("displayOrder"));
                gameDTO.setDownloadNum(resultSet.getInt("downloadNum"));
                gameDTO.setGameDesc(resultSet.getString("gameDesc"));
                gameDTO.setGameFeature(resultSet.getInt("gameFeature"));
                gameDTO.setGameId(resultSet.getString("gameId"));
                gameDTO.setGameName(resultSet.getString("gameName"));
                gameDTO.setGameNo(resultSet.getString("gameNo"));
                gameDTO.setMobileGameType(resultSet.getInt("mobileGameType"));
                gameDTO.setPackageName(resultSet.getString("packageName"));
                gameDTO.setPicUrl(resultSet.getString("picUrl"));
                gameDTO.setSmallPicUrl(resultSet.getString("smallPicUrl"));
                gameDTO.setSummary(resultSet.getString("summary"));
                gameDTO.setShortUrl(resultSet.getString("shortUrl"));
                gameDTO.setAppSize(resultSet.getString("appSize"));
                gameDTO.setMobileGameType(resultSet.getInt("mobileGameType"));
                gameList.add(gameDTO);
            }
        });
        return gameList;
    }

    @Override
    public List<MobileGameChannelApk> getMobileGameChannelApk(Long apkId, String chanelIds) {
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT t.* from mobileGameChannelApk t ");
        sql.append(" where 1=1 ");
        if (null != apkId && apkId != 0L) {
            sql.append("  and t.apkId=" + apkId);
        }
        if (StringUtils.isNotEmpty((String)chanelIds)) {
            sql.append("   and t.channelId in ( " + chanelIds + ")");
        }
        return this.getJdbcTemplate().query(sql.toString(), (RowMapper)new ObjectMapper(MobileGameChannelApk.class));
    }

    @Override
    public List<MobileGameChannelApk> getApkByIds(String apkIds) {
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT t.* from mobileGameChannelApk t where 1=1 ");
        if (StringUtils.isNotEmpty((String)apkIds)) {
            sql.append("   and t.channelApkId in ( " + apkIds + ")");
        }
        return this.getJdbcTemplate().query(sql.toString(), (RowMapper)new ObjectMapper(MobileGameChannelApk.class));
    }
}

