/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.data.vipgame.bo;

import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.BaseDaoImpl;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.bo.GameServersBo;
import com.xunlei.niux.data.vipgame.dto.game.BoxGameServerExtInfoDTO;
import com.xunlei.niux.data.vipgame.vo.GameServers;
import com.xunlei.niux.easyutils.commonutils.DateUtil;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.jdbc.core.RowCallbackHandler;

public class GameServersBoImpl
extends BaseDaoImpl
implements GameServersBo {
    private static final int OPEN_SERVERS_NUM = 10;
    private BaseDao baseDao;

    public BaseDao getBaseDao() {
        return this.baseDao;
    }

    public void setBaseDao(BaseDao baseDao) {
        this.baseDao = baseDao;
    }

    @Override
    public void execute(String sql, List<Object> list) {
        this.baseDao.execute(sql, list);
    }

    @Override
    public List<GameServers> findGameServers(GameServers gameServrs, int pageNo, int pageSize) {
        Page page = new Page();
        page.setPageNo(pageNo);
        page.setPageSize(pageSize);
        page.addOrder("fenQuNum", OrderType.DESC);
        return this.baseDao.findByObject(GameServers.class, (Object)gameServrs, page);
    }

    @Override
    public int count(GameServers gameServrs) {
        return this.baseDao.count((Object)gameServrs);
    }

    @Override
    public GameServers findGameServersById(long seqid) {
        return (GameServers)this.baseDao.findById(GameServers.class, (Number)seqid);
    }

    @Override
    public void update(GameServers gameServrs) {
        this.baseDao.updateById((Object)gameServrs);
    }

    @Override
    public void insert(GameServers gameServrs) {
        this.baseDao.insert((Object)gameServrs);
    }

    @Override
    public List<GameServers> find(GameServers gs, Page page) {
        return this.baseDao.findByObject(GameServers.class, (Object)gs, page);
    }

    @Override
    public GameServers getLatestGameServerByGameId(String gameId, boolean isQueryTestData) {
        if (gameId == null || "".equals(gameId)) {
            return null;
        }
        Page page = new Page();
        page.setPageNo(1);
        page.setPageSize(1);
        page.addOrder("openTime", OrderType.DESC);
        page.addOrder("fenQuNum", OrderType.DESC);
        GameServers gameServrs = new GameServers();
        gameServrs.setGameId(gameId);
        gameServrs.setOpenStatus("1");
        List list = this.baseDao.findByObject(GameServers.class, (Object)gameServrs, page);
        return list != null && list.size() > 0 ? (GameServers)list.get(0) : null;
    }

    @Override
    public void delete(long seqId) {
        this.baseDao.deleteById(GameServers.class, (Number)seqId);
    }

    @Override
    public List<GameServers> getNewestOpenedGameServersByGameIdList(List<String> gameIdList) {
        if (CollectionUtils.isEmpty(gameIdList)) {
            return new ArrayList<GameServers>();
        }
        String baseSql = "(select * from gameservers where gameId = ? and openstatus='1' order by openTime desc,fenQuNum desc limit 1 )";
        String querySql = "";
        int index = 0;
        ArrayList<String> paramList = new ArrayList<String>();
        for (String gameId : gameIdList) {
            if (StringUtils.isEmpty((String)gameId)) continue;
            if (index > 0) {
                querySql = querySql + " union ";
            }
            querySql = querySql + baseSql;
            paramList.add(gameId);
            ++index;
        }
        List gameServersList = this.baseDao.executeQuery(GameServers.class, querySql, paramList);
        if (CollectionUtils.isEmpty((Collection)gameServersList)) {
            return new ArrayList<GameServers>();
        }
        return gameServersList;
    }

    @Override
    public String getNewestOpenedGameServerByGameId(String gameId) {
        GameServers query = new GameServers();
        query.setGameId(gameId);
        query.setOpenStatus("1");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        query.setToopentime(sdf.format(new Date()));
        Page page = new Page();
        page.addOrder("openTime", OrderType.DESC);
        page.addOrder("fenQuNum", OrderType.DESC);
        page.setPageNo(1);
        page.setPageSize(1);
        List serversList = this.baseDao.findByObject(GameServers.class, (Object)query, page);
        if (CollectionUtils.isEmpty((Collection)serversList)) {
            throw new RuntimeException("\u6ca1\u6709\u6709\u6548\u7684\u533a\u670d\u4fe1\u606f\uff01");
        }
        GameServers gameServer = (GameServers)serversList.get(0);
        return gameServer.getServerId();
    }

    @Override
    public boolean isValidOpenedGameServer(String gameId, String serverId) {
        GameServers query = new GameServers();
        query.setGameId(gameId);
        query.setServerId(serverId);
        query.setOpenStatus("1");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        query.setToopentime(sdf.format(new Date()));
        Page page = new Page();
        page.addOrder("openTime", OrderType.DESC);
        page.addOrder("fenQuNum", OrderType.DESC);
        page.setPageNo(1);
        page.setPageSize(1);
        List serversList = this.baseDao.findByObject(GameServers.class, (Object)query, page);
        return CollectionUtils.isNotEmpty((Collection)serversList);
    }

    @Override
    public boolean isValidOpenedGameServerAndCanUserReceiveTask(String gameId, String serverId) throws Exception {
        GameServers query = new GameServers();
        query.setGameId(gameId);
        query.setServerId(serverId);
        query.setOpenStatus("1");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        query.setToopentime(sdf.format(new Date()));
        Page page = new Page();
        page.addOrder("openTime", OrderType.DESC);
        page.addOrder("fenQuNum", OrderType.DESC);
        page.setPageNo(1);
        page.setPageSize(1);
        List serversList = this.baseDao.findByObject(GameServers.class, (Object)query, page);
        if (CollectionUtils.isNotEmpty((Collection)serversList)) {
            GameServers gameServer = (GameServers)serversList.get(0);
            String openTime = gameServer.getOpenTime();
            String newestServerId = this.getNewestOpenedGameServerByGameId(gameId);
            if (newestServerId.equals(serverId) || DateUtil.isCurTimeInRange((String)openTime, (String)DateUtil.getNDaysLater((String)openTime, (int)5))) {
                return true;
            }
        }
        return false;
    }

    @Override
    public List<GameServers> getOpenServersByFromDateAndToDate(String fromDate, String toDate) {
        String sql = "select gameservers.* from \ngames join gameservers on gameservers.gameId = games.gameId\nwhere (games.clientType =0 or games.clientType =1) and gameservers.openTime >= ? and gameservers.openTime <= ?\norder by gameservers.openTime,gameservers.fenQuNum ";
        ArrayList<String> list = new ArrayList<String>();
        list.add(fromDate + " 00:00:00");
        list.add(toDate + " 23:59:59");
        List serversList = this.baseDao.executeQuery(GameServers.class, sql, list);
        return serversList;
    }

    @Override
    public List<GameServers> getXmpOpenServersByFromDateAndToDate(String fromDate, boolean isSort, int limit) {
        String sql = "SELECT distinct s3.* FROM (SELECT gameidbytuijian FROM linkinfo WHERE linklocid='1260') s1 \nINNER JOIN games s2 ON s1.gameidbytuijian=s2.gameid  INNER  JOIN gameservers s3 ON s3.gameId = s2.gameId\nWHERE (s2.clientType =0 OR s2.clientType =1) AND  s3.openTime <= ?\nORDER BY s3.openTime  ";
        sql = !isSort ? sql + " desc,s3.fenQuNum desc " : sql + " asc,s3.fenQuNum asc ";
        sql = sql + "  limit " + limit;
        ArrayList<String> list = new ArrayList<String>();
        list.add(fromDate);
        List serversList = this.baseDao.executeQuery(GameServers.class, sql, list);
        return serversList;
    }

    @Override
    public List<GameServers> getNewOpenServersByFromDateAndToDate(String fromDate, String toDate, boolean isSort) {
        String sql = "SELECT distinct s3.* FROM (SELECT gameidbytuijian FROM linkinfo WHERE linklocid='1260') s1 \nINNER JOIN games s2 ON s1.gameidbytuijian=s2.gameid  INNER  JOIN gameservers s3 ON s3.gameId = s2.gameId\nWHERE (s2.clientType =0 OR s2.clientType =1) AND s3.openTime >= ? AND s3.openTime <= ?\nORDER BY s3.openTime  ";
        sql = !isSort ? sql + " desc,s3.fenQuNum desc" : sql + " asc,s3.fenQuNum asc";
        ArrayList<String> list = new ArrayList<String>();
        list.add(fromDate + " 00:00:00");
        list.add(toDate + " 23:59:59");
        List serversList = this.baseDao.executeQuery(GameServers.class, sql, list);
        return serversList;
    }

    @Override
    public List<BoxGameServerExtInfoDTO> getNewHotOpenServersByFromDateAndToDate(String fromDate, String toDate, boolean isSort) {
        String sql = "SELECT distinct s3.*,s2.isHot  FROM (SELECT gameidbytuijian FROM linkinfo WHERE linklocid='1260') s1 \nINNER JOIN games s2 ON s1.gameidbytuijian=s2.gameid  INNER  JOIN gameservers s3 ON s3.gameId = s2.gameId\nWHERE (s2.clientType =0 OR s2.clientType =1) AND s3.openTime >= ? AND s3.openTime <= ?\nORDER BY s3.openTime  ";
        sql = !isSort ? sql + " desc,s3.fenQuNum desc" : sql + " asc,s3.fenQuNum asc";
        ArrayList<String> list = new ArrayList<String>();
        list.add(fromDate + " 00:00:00");
        list.add(toDate + " 23:59:59");
        List serversList = this.baseDao.executeQuery(BoxGameServerExtInfoDTO.class, sql, list);
        return serversList;
    }

    @Override
    public List<GameServers> getNewOpenServersByFromDateAndToDateHlg(String fromDate, String toDate, boolean isSort) {
        String sql = "SELECT distinct s3.* FROM (SELECT gameidbytuijian FROM linkinfo WHERE linklocid='1261') s1 \nINNER JOIN games s2 ON s1.gameidbytuijian=s2.gameid  INNER  JOIN gameservers s3 ON s3.gameId = s2.gameId\nWHERE s2.clientType =4 AND s3.openTime >= ? AND s3.openTime <= ?\nORDER BY s3.openTime  ";
        sql = !isSort ? sql + " desc,s3.fenQuNum desc" : sql + " asc,s3.fenQuNum asc";
        ArrayList<String> list = new ArrayList<String>();
        list.add(fromDate + " 00:00:00");
        list.add(toDate + " 23:59:59");
        List serversList = this.baseDao.executeQuery(GameServers.class, sql, list);
        if (serversList != null && serversList.size() < 10) {
            List<GameServers> yeyouServersList = this.getNewOpenServersByFromDateAndToDate(fromDate, toDate, isSort);
            serversList.addAll(yeyouServersList);
        }
        return serversList;
    }

    @Override
    public List<GameServers> getTimeOpenFenQuGameServersList() {
        String querySql = "select * from gameservers where openstatus <> '1' and fenQuOpenFlag = 1 and fenQuOpenTime < now()";
        return this.baseDao.executeQuery(GameServers.class, querySql, new ArrayList());
    }

    @Override
    public List<GameServers> getLatestAndComingOneGameServer() {
        String sql = "select gameservers.* from (select gameid, max(opentime) as opentime from gameservers where openstatus='1' group by gameid \nunion all select gameid, min(opentime) as opentime from gameservers where openstatus='0' group by gameid ) s \ninner join gameservers on s.gameid = gameservers.gameid and s.opentime = gameservers.opentime\ninner join games on games.gameid = gameservers.gameid\nwhere (games.clientType =0 OR games.clientType =1) order by games.gameid;";
        ArrayList list = new ArrayList();
        List serversList = this.baseDao.executeQuery(GameServers.class, sql, list);
        return serversList;
    }

    @Override
    public List<GameServers> getNewGamesList() {
        String sql = "SELECT gameservers.* FROM  ( SELECT seqId, opentime FROM    ( SELECT MIN(gms.openTime) AS opentime, gms.gameid,gms.seqId FROM gameservers gms      INNER JOIN games ON games.status = 1 AND (games.clientType = 0 or games.clientType = 1)  AND games.gameid = gms.gameid      WHERE openstatus in (1,2) GROUP BY gameid\n   ) gs   ORDER BY opentime DESC LIMIT 0,10  ) s1 INNER JOIN gameservers ON gameservers.seqId = s1.seqId ORDER BY s1.opentime DESC ";
        ArrayList list = new ArrayList();
        List gamesList = this.executeQuery(GameServers.class, sql, list);
        return gamesList;
    }

    @Override
    public List<GameServers> getLatestNewestOpenedGameServersByGameIdList(List<String> gameIdList) {
        if (CollectionUtils.isEmpty(gameIdList)) {
            return new ArrayList<GameServers>();
        }
        String baseSql = "(select * from gameservers WHERE gameId=? and openstatus=1 and STR_TO_DATE(openTime, \"%Y-%m-%d\") = (\n\tselect STR_TO_DATE(max(openTime), \"%Y-%m-%d\") from gameservers where gameId=? and openstatus=1\n))";
        String querySql = "";
        int index = 0;
        ArrayList<String> paramList = new ArrayList<String>();
        for (String gameId : gameIdList) {
            if (StringUtils.isEmpty((String)gameId)) continue;
            if (index > 0) {
                querySql = querySql + " union ";
            }
            querySql = querySql + baseSql;
            paramList.add(gameId);
            paramList.add(gameId);
            ++index;
        }
        List gameServersList = this.baseDao.executeQuery(GameServers.class, querySql, paramList);
        if (CollectionUtils.isEmpty((Collection)gameServersList)) {
            return new ArrayList<GameServers>();
        }
        return gameServersList;
    }

    @Override
    public Map<String, Object> getLastOpenServers() {
        String sql = "select gameId,max(openTime) as openTime from gameservers where  openstatus = 1 GROUP BY gameid ";
        final HashMap<String, Object> forMap = new HashMap<String, Object>();
        this.getJdbcTemplate().query(sql, new Object[0], new RowCallbackHandler(){

            public void processRow(ResultSet resultSet) throws SQLException {
                forMap.put(resultSet.getString("gameId"), resultSet.getString("openTime"));
            }
        });
        return forMap;
    }
}

