package com.xunlei.niux.data.vipgame.dao.lottery;

import com.ferret.common.dao.BaseDaoImpl;
import com.xunlei.niux.data.vipgame.bo.lottery.dto.LotteryRecordDTO;
import com.xunlei.niux.data.vipgame.vo.lottery.LotteryRecord;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.map.ListOrderedMap;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.jdbc.core.RowCallbackHandler;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

/**
 * Created by jamesjxin on 15-1-22.
 */
public class LotteryRecordDaoImpl extends BaseDaoImpl implements LotteryRecordDao {

    @Override
    public List<LotteryRecordDTO> getLotteryRecordByActNoAndGiftType(String actNo, String giftType, int max) {
        String sql = "select lotteryrecord.*, gift.productTotalPrice, " +
                " '' as userImgUrl, '' as province, '' as giftPicUrl " +
                " from gift join lotteryrecord on gift.giftId = lotteryrecord.giftId\n" +
                " where lotteryrecord.actNo = ? ";
        List<Object> args = new ArrayList<Object>();
        args.add(actNo);
        if(StringUtils.isNotEmpty(giftType)){
            sql += " and gift.giftType = ? ";
            args.add(giftType);
        }
        sql += " order by recordTime desc limit ? ";
        args.add(max);

        List<LotteryRecordDTO> recordList = findBySql(LotteryRecordDTO.class,sql,args);

        return recordList;
    }
}
