package com.xunlei.niux.data.vipgame.dao.lottery;

import com.ferret.common.dao.BaseDaoImpl;
import com.xunlei.niux.data.vipgame.bo.lottery.dto.LotteryRecordDTO;
import com.xunlei.niux.data.vipgame.vo.lottery.LotteryRecord;
import org.apache.commons.lang.StringUtils;

import java.util.List;

/**
 * Created by jamesjxin on 15-1-22.
 */
public class LotteryRecordDaoImpl extends BaseDaoImpl implements LotteryRecordDao {

    @Override
    public List<LotteryRecordDTO> getLotteryRecordByActNoAndGiftType(String actNo, String giftType, int max) {
        String sql = "select lotteryrecord.*, gift.productTotalPrice, " +
                " '' as userImgUrl, '' as province, '' as giftPicUrl " +
                "from gift join lotteryrecord on gift.giftId = lotteryrecord.giftId\n" +
                "where lotteryrecord.actNo = ? ";
        Object[] args;
        if(StringUtils.isNotEmpty(giftType)){
            sql += " and gift.giftType = ? ";
            args = new Object[]{actNo,giftType,max};
        }else{
            args = new Object[]{actNo,max};
        }

        sql += " order by recordTime desc limit ? ";

        List<LotteryRecordDTO> recordList = getJdbcTemplate().queryForList(sql, args, LotteryRecordDTO.class);
        return recordList;
    }
}
