package com.xunlei.niux.data.vipgame.bo;

import java.util.List;

import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.vo.GameServers;
/**
 * 游戏服务器（分区）业务层
 * @author lin
 * @date 2012-9-12
 * @Descripter:
 */
public interface GameServersBo {
    void execute(String sql, List<Object> list);
	List<GameServers> findGameServers(GameServers gameServrs,int pageNo,int pageSize);
	int count(GameServers gameServrs);
	GameServers findGameServersById(long seqid);
	void update(GameServers gameServrs);
	void insert(GameServers gameServrs);
	List<GameServers> find(GameServers gs,Page page);
	void delete(long seqId);
	/**
	 * 获取gameid对应游戏的最新开区，如果包含测试数据isQueryTestData true;
	 * @param gameId
	 * @param isQueryTestData
	 * @return
	 */
	GameServers getLatestGameServerByGameId(String gameId,boolean isQueryTestData);

    public List<GameServers> getNewestOpenedGameServersByGameIdList(List<String> gameIdList);

    public String getNewestOpenedGameServerByGameId(String gameId);

    public boolean isValidOpenedGameServer(String gameId,String serverId);

    public List<GameServers> getOpenServersByFromDateAndToDate(String fromDate,String toDate);
    
    public List<GameServers> getNewOpenServersByFromDateAndToDate(String fromDate,String toDate,boolean isSort);
    
    public List<GameServers> getXmpOpenServersByFromDateAndToDate(String fromDate,boolean isSort,int limit);
    
    /**
     * 获取定时开区数据
     * @return
     */
    public List<GameServers> getTimeOpenFenQuGameServersList();
}
