package com.xunlei.niux.data.vipgame.bo;

import java.util.ArrayList;
import java.util.List;
import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.presql.Select;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.vo.Activity;

public class ActivityBoImpl implements ActivityBo{
	private BaseDao baseDao;
	public BaseDao getBaseDao() {
		return baseDao;
	}

	public void setBaseDao(BaseDao baseDao) {
		this.baseDao = baseDao;
	}

	public void insert(Activity activity) {
		if(activity==null){
			throw new RuntimeException("活动为空");
		}
		if(activity.getActno()==null||"".equals(activity.getActno())){
			throw new RuntimeException("活动编号为空");
		}
		Activity a1=findByActno(activity.getActno());
		if(a1!=null){
			throw new RuntimeException("活动编号["+a1.getActno()+"]已存在");
		}
		baseDao.insert(activity);
	}

	public void delete(long seqid) {
		baseDao.deleteById(Activity.class, seqid);
		
	}

	public void update(Activity activity) {
		baseDao.updateById(activity);
	}
	public int count(Activity activity) {
		 String title = activity.getTitle();
		 activity.setTitle(null);
		 Select select = new Select(activity, new Page());
	     String presql =  select.getPreSql();	     
	     if(presql.indexOf("where")==-1){
	        	presql += "   where 1=1 ";
	        }
	        if(title != null && !"".equals(title)){
	        	presql += " and title like '%"+title+"%'";
	        }
	        System.out.println("countsql:"+presql);
	        List list = baseDao.executeQuery(Activity.class, presql, select.getParamsList());
	        activity.setTitle(title);
		return list==null?0:list.size();
	}

	public List<Activity> find(Activity activity, Page page) {
		if(activity==null){
			return new ArrayList<Activity>();
		}
		String title = activity.getTitle();
		activity.setTitle(null);
		return findByObject(Activity.class,title, activity, page);
	}

	public List<Activity> find(Activity activity) {
		if(activity==null){
			return new ArrayList<Activity>();
		}

		return baseDao.findByObject(Activity.class, activity, new Page());
	}

    public List findByObject(Class clazz,String title, Object entity, Page page)
    {
	   
        Select select = new Select(entity, page);
        String presql =  select.getPreSql();
        String limit = "";
        String orderby = "";
        if(presql.indexOf("limit") != -1){
        	limit = presql.substring(presql.indexOf("limit"));        	
        	presql = presql.substring(0,presql.indexOf("limit"));    
        	if(presql.indexOf("order")!=-1){
            	orderby = presql.substring(presql.indexOf("order"));
            	presql = presql.substring(0,presql.indexOf("order"));      
        	}	
        }
        if(presql.indexOf("where")==-1){
        	presql += "   where 1=1 ";
        }
      
        if(title != null && !"".equals(title)){
        	presql += " and title like '%"+title+"%'";
        }
        presql += (" "+orderby);
        presql +=(" "+limit);
        System.out.println("presql:"+presql);
        return baseDao.executeQuery(clazz, presql, select.getParamsList());
    }
	
	public Activity find(long seqid) {
		return baseDao.findById(Activity.class, seqid);
	}

	public Activity findByActno(String actno) {
		if(actno==null||"".equals(actno)){
			return null;
		}
		Activity activity=new Activity();
		activity.setActno(actno);
		List<Activity> list=find(activity);
		if(list==null||list.size()==0){
			return null;
		}
		return list.get(0);
	}
}
