package com.xunlei.niux.data.vipgame.util;

import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.cache.CacheManager;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.authority.AuthInfo;
import com.xunlei.niux.easyutils.commonutils.ResultUtils;
import com.xunlei.niux.easyutils.sign.SignUtil;
import org.apache.commons.lang.StringUtils;

import java.util.Arrays;
import java.util.List;
import java.util.Map;

/**
 * Created with IntelliJ IDEA.
 * User: admin
 * Date: 13-10-31
 * Time: 上午11:43
 * To change this template use File | Settings | File Templates.
 */
public class AuthorityUtil {
    private static final int timeOut = 60*12;
    private static String msg;

    /**
     * 验证接口权限
     * @param authId
     * @param sign
     * @param param
     * @return
     * Code AuthorityCode]
     */
    public static Map<String,Object> Authority(String authId,String sign,String remoteIp,Map param){

        if(StringUtils.isEmpty(authId) || StringUtils.isEmpty(sign)){
            msg = "参数不能为空";
            return ResultUtils.generateMap(AuthorityCode.INVALIDPARAM,msg);
        }
        //验证本地接口数字签名

        AuthInfo auth = getAuthByAuthId(authId);

        if(!auth.getIsValid()){
            msg = "权限失效";
            return ResultUtils.generateMap(AuthorityCode.AUTHINVALID, msg);
        }
        String authIp = auth.getAuthIp().trim();
        if(!(authIp==null || authIp.length()==0)){
            List<String> iplist = Arrays.asList(authIp.split("\\|"));
            if(!iplist.contains(remoteIp)){
                msg = "ip没有权限";
                return ResultUtils.generateMap(AuthorityCode.IPINVALID,msg);
            }
        }

        String privateKey = auth.getAuthKey().trim();
        String mysign = SignUtil.sign(param, privateKey);
        if (!sign.trim().equals(mysign.trim())) {
            msg = "验证不通过";
            return ResultUtils.generateMap(AuthorityCode.INVALIDSIGN,msg);
        }

        msg = "验证通过";
        return ResultUtils.generateMap(AuthorityCode.SUCCESS,msg);
    }

    private static AuthInfo getAuthByAuthId(String authId){
        AuthInfo authInfo = null;
        String cacheKey = AuthorityUtil.class+"authId_"+authId;

        CacheManager cacheManager = CacheManager.GetInstance();
        //从缓存获取数据
        Object object = cacheManager.get(cacheKey);
        if(object == null ){
            //获取数据逻辑
            AuthInfo query = new AuthInfo();
            query.setAuthId(authId);
            List authInfoList = FacadeFactory.INSTANCE.getAuthInfoBo().find(query, new Page());
            if(authInfoList == null || authInfoList.size()==0){
                return null;
            }
            authInfo = (AuthInfo)authInfoList.get(0);

            //更新缓存
            cacheManager.put(cacheKey,authInfo,timeOut);
        } else {
            authInfo = (AuthInfo)object;
        }
        return authInfo;
    }
}
