package com.xunlei.niux.data.vipgame.dao.gift;

import com.ferret.common.dao.BaseDaoImpl;
import com.xunlei.niux.data.vipgame.dto.GiftRecordDTO;
import org.springframework.jdbc.core.RowCallbackHandler;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

/**
 * Created by jamesjxin on 14-4-17.
 */
public class GiftRecordDaoImpl extends BaseDaoImpl implements GiftRecordDao{

    @Override
    public List<GiftRecordDTO> getUnReleaseProductGiftRecord() {
        final List<GiftRecordDTO> giftRecordDTOList = new ArrayList<GiftRecordDTO>();

        String sql = "SELECT giftrecord.*,giftshopreleaserecord.*,gift.goodId FROM giftrecord\n" +
                "LEFT JOIN giftshopreleaserecord ON giftrecord.recordId = giftshopreleaserecord.`giftRecordId`\n" +
                "LEFT JOIN gift ON giftrecord.giftId = gift.giftId\n" +
                "WHERE giftType = 'product' AND showLocNo='jinzuan_product' AND (giftshopreleaserecord.releaseStatus IS NULL OR giftshopreleaserecord.releaseStatus != 1);";


        getJdbcTemplate().query(sql,new RowCallbackHandler() {
            @Override
            public void processRow(ResultSet resultSet) throws SQLException {
                GiftRecordDTO giftRecordDTO = new GiftRecordDTO();
                giftRecordDTO.setRecordId(resultSet.getLong("recordId"));
                giftRecordDTO.setGiftId(resultSet.getLong("giftId"));
                giftRecordDTO.setUserId(resultSet.getString("userId"));
                giftRecordDTO.setGameId(resultSet.getString("gameId"));
                giftRecordDTO.setServerId(resultSet.getString("serverId"));
                giftRecordDTO.setRoleId(resultSet.getString("roleId"));
                giftRecordDTO.setGiftNum(resultSet.getDouble("giftNum"));
                giftRecordDTO.setMobile(resultSet.getString("mobile"));
                giftRecordDTO.setGiftStatus(resultSet.getString("giftStatus"));
                giftRecordDTO.setActNo(resultSet.getString("actNo"));
                giftRecordDTO.setThirdRecordId(resultSet.getString("thirdRecordId"));
                giftRecordDTO.setFailCause(resultSet.getString("failCause"));
                giftRecordDTO.setRecordTime(resultSet.getString("recordTime"));
                giftRecordDTO.setDealTime(resultSet.getString("dealTime"));
                giftRecordDTO.setExpireDate(resultSet.getString("expireDate"));
                giftRecordDTO.setXunleiVipType(resultSet.getString("xunleiVipType"));
                giftRecordDTO.setParentRecordId(resultSet.getLong("parentRecordId"));
                giftRecordDTO.setIsShow(resultSet.getBoolean("isShow"));
                giftRecordDTO.setSerialNumber(resultSet.getString("serialNumber"));
                giftRecordDTO.setShowLocNo(resultSet.getString("showLocNo"));
                giftRecordDTO.setReleaseStatus(resultSet.getBoolean("releaseStatus"));
                giftRecordDTO.setReleaseTime(resultSet.getString("releaseTime"));
                giftRecordDTO.setGoodId(resultSet.getInt("goodId"));

                giftRecordDTOList.add(giftRecordDTO);
            }
        });

        return giftRecordDTOList;
    }
}
