package com.xunlei.niux.data.vipgame.bt.bonus;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

import com.xunlei.niux.common.exception.NiuRuntimeException;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.BonusProduct;
import com.xunlei.niux.data.vipgame.vo.bonus.BonusProductGiveOutDayStatistics;

/**
 * 产品积分业务帮助类
 * @author Administrator
 *
 */
public class BonusProductBT {
	private static SimpleDateFormat sdf=new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
	/**
	 * 判断产品能够兑换
	 * @param bonusProduct
	 * @param exchargeNum
	 */
	public static void checkProductEnoughExchange(BonusProduct bonusProduct){
		if(bonusProduct==null){
			throw new NiuRuntimeException("1015","产品为空");
		}
		if(bonusProduct.getProductNum()<1){
			throw new NiuRuntimeException("1017","产品数量不够");
		}
		if(!"1".equals(bonusProduct.getProductStatus())){
			throw new NiuRuntimeException("1016","产品不可兑换");
		}
		String now =sdf.format(new Date());
		if(now.compareTo(bonusProduct.getValidPeriod())>0){
			throw new NiuRuntimeException("1018","产品兑换过期");
		}
	}
	public static void checkProductDayEnough(String productNo,String giveOutDate,Integer maxDayNum){
		if(maxDayNum==null||maxDayNum<=0){
			return ;
		}
		BonusProductGiveOutDayStatistics bpgods=FacadeFactory.INSTANCE.getBonusProductGiveOutDayStatisticsBo().find(productNo, giveOutDate);
		if(bpgods==null){
			return ;
		}
		if(maxDayNum<bpgods.getGiveOutSum()+1){
			throw new NiuRuntimeException("1019", "已达到每日兑换上线");
		}
	}
	public static BonusProduct checkProductEnoughExchange(String productNo){
		BonusProduct product=new BonusProduct();
		product.setProductNo(productNo);
		List<BonusProduct> list=FacadeFactory.INSTANCE.getBonusProductBo().find(product, 1, 1);
		if(list==null||list.size()==0){
			throw new NiuRuntimeException("1015","物品不存在");
		}
		BonusProduct bonusProduct=list.get(0);
		checkProductEnoughExchange(bonusProduct);
		return bonusProduct;
	}
}
