package com.xunlei.niux.data.vipgame.bo.gift;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.annotation.Resource;
import org.springframework.stereotype.Service;

import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.util.OrderNoUtil;
import com.xunlei.niux.data.vipgame.vo.gift.Gift;
import com.xunlei.niux.data.vipgame.vo.gift.GiftPackage;
import com.xunlei.niux.data.vipgame.vo.gift.GiftPackageDetail;
import com.xunlei.niux.data.vipgame.vo.gift.GiftRecord;

@Service
public class UseGiftPackageBoImpl implements UseGiftPackageBo {
	private static SimpleDateFormat sdfDate = new SimpleDateFormat("yyyy-MM-dd");
	private static SimpleDateFormat sdf=new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
	@Resource(name="BaseDao")
	private BaseDao baseDao;
	/**
	 * @param p_giftRecord
	 */
	public void userGiftPackage(GiftRecord p_giftRecord){
		GiftRecord giftRecord=findAndLockGiftRecord(p_giftRecord.getRecordId());
		Gift gift=baseDao.findById(Gift.class, giftRecord.getGiftId());
		if(!gift.getGiftType().equals("niuxgift")){
			throw new RuntimeException("不是礼包记录["+p_giftRecord.getRecordId()+"]");
		}
		if(!giftRecord.getGiftStatus().equals("WAIT")){
			throw new RuntimeException("已用礼包记录["+p_giftRecord.getRecordId()+"]");
		}
		giftRecord.setGameId(p_giftRecord.getGameId()==null?"":p_giftRecord.getGameId());
		giftRecord.setServerId(p_giftRecord.getServerId()==null?"":p_giftRecord.getServerId());
        giftRecord.setServerName(p_giftRecord.getServerName());
		giftRecord.setRoleId(p_giftRecord.getRoleId()==null?"":p_giftRecord.getRoleId());
		giftRecord.setXunleiVipType(p_giftRecord.getXunleiVipType()==null?"UNKOWN":p_giftRecord.getXunleiVipType());
		giftRecord.setMobile(p_giftRecord.getMobile()==null?"":p_giftRecord.getMobile());
		giftRecord.setDealTime(sdf.format(new Date()));
		giftRecord.setGiftStatus("SUCCESS");
		baseDao.updateById(giftRecord);
		
		//处理礼包的明细
		GiftPackage giftPackage=baseDao.findById(GiftPackage.class, gift.getGiftLot());
		List<GiftPackageDetail> details=findGiftPackageDetails(giftPackage.getPackageId());
		for(int i=0;i<details.size();i++){
			GiftPackageDetail detail=details.get(i);
			GiftRecord detailGiftRecord=new GiftRecord();
			detailGiftRecord.setActNo(giftRecord.getActNo());
			detailGiftRecord.setGameId(giftRecord.getGameId());
			detailGiftRecord.setGiftId(detail.getProductId());
			detailGiftRecord.setGiftNum((double)detail.getProductNum());
			detailGiftRecord.setRoleId(giftRecord.getRoleId());
			detailGiftRecord.setServerId(giftRecord.getServerId());
            detailGiftRecord.setServerName(giftRecord.getServerName());
			detailGiftRecord.setThirdRecordId(OrderNoUtil.getOrderNo());
			detailGiftRecord.setUserId(giftRecord.getUserId());
			detailGiftRecord.setExpireDate("");
			detailGiftRecord.setParentRecordId(giftRecord.getRecordId());
			detailGiftRecord.setIsShow(false);
			addGiftPackageDetail(detailGiftRecord);
		}
		//发放子礼包
		GiftPackage query=new GiftPackage();
		query.setParentPackageId(giftPackage.getPackageId());
		query.setIsValid(true);
		List<GiftPackage> childGPList=baseDao.findByObject(GiftPackage.class, query, new Page());
		for(int i=0;i<childGPList.size();i++){
			GiftPackage childgp=childGPList.get(i);
			if(!childgp.getXunleiVipUseType().equals("ALL")&&!childgp.getXunleiVipUseType().equals(giftRecord.getXunleiVipType())){
				continue;
			}
			Gift childGift=findGiftByPackageId(childgp.getPackageId());
			GiftRecord detailGiftRecord=new GiftRecord();
			detailGiftRecord.setActNo(giftRecord.getActNo());
			detailGiftRecord.setGiftId(childGift.getGiftId());
			detailGiftRecord.setGiftNum((double) 1);
			detailGiftRecord.setThirdRecordId(OrderNoUtil.getOrderNo());
			detailGiftRecord.setUserId(giftRecord.getUserId());
			detailGiftRecord.setExpireDate(calExpireDate(childgp.getExpireDays()));
			detailGiftRecord.setGameId("");
			detailGiftRecord.setRoleId("");
			detailGiftRecord.setServerId("");
			detailGiftRecord.setParentRecordId(giftRecord.getRecordId());
			if(childgp.getInheritParentGameServerType().equals("GAME")){
				detailGiftRecord.setGameId(giftRecord.getGameId());
			}else if(childgp.getInheritParentGameServerType().equals("SERVER")){
				detailGiftRecord.setGameId(giftRecord.getGameId());
				detailGiftRecord.setRoleId(giftRecord.getRoleId());
				detailGiftRecord.setServerId(giftRecord.getServerId());
                detailGiftRecord.setServerName(giftRecord.getServerName());
			}
			detailGiftRecord.setIsShow(true);
			addGiftPackageDetail(detailGiftRecord);
		}
	}
	public Gift findGiftByPackageId(long packageId){
		Gift gift=new Gift();
		gift.setGiftLot(String.valueOf(packageId));
		gift.setGiftType("niuxgift");
		Page page =new Page();
		page.setPageNo(1);
		page.setPageSize(1);
		List<Gift> giftList=baseDao.findByObject(Gift.class, gift, page);
		return giftList==null||giftList.size()==0?null:giftList.get(0);
	}
	public void addGiftPackageDetail(GiftRecord p_detailGiftRecord){
		GiftRecord detailGiftRecord=new GiftRecord();
		detailGiftRecord.setActNo(p_detailGiftRecord.getActNo());
		detailGiftRecord.setDealTime("");
		detailGiftRecord.setExpireDate(p_detailGiftRecord.getExpireDate());
		detailGiftRecord.setFailCause("");
		detailGiftRecord.setGameId(p_detailGiftRecord.getGameId());
		detailGiftRecord.setGiftId(p_detailGiftRecord.getGiftId());
		detailGiftRecord.setGiftNum(p_detailGiftRecord.getGiftNum());
		detailGiftRecord.setGiftStatus("WAIT");
		detailGiftRecord.setMobile("");
		detailGiftRecord.setRecordTime(sdf.format(new Date()));
		detailGiftRecord.setRoleId(p_detailGiftRecord.getRoleId());
		detailGiftRecord.setServerId(p_detailGiftRecord.getServerId());
        detailGiftRecord.setServerName(p_detailGiftRecord.getServerName());
		detailGiftRecord.setThirdRecordId(p_detailGiftRecord.getThirdRecordId());
		detailGiftRecord.setUserId(p_detailGiftRecord.getUserId());
		detailGiftRecord.setXunleiVipType("UNKOWN");
		detailGiftRecord.setIsShow(p_detailGiftRecord.getIsShow());
		detailGiftRecord.setParentRecordId(p_detailGiftRecord.getParentRecordId()==null?0:p_detailGiftRecord.getParentRecordId());
		detailGiftRecord.setSerialNumber("");
		detailGiftRecord.setShowLocNo(p_detailGiftRecord.getShowLocNo());
		baseDao.insert(detailGiftRecord);
	}
	private List<GiftPackageDetail> findGiftPackageDetails(long packageId){
		GiftPackageDetail query=new GiftPackageDetail();
		query.setPackageId(packageId);
		return baseDao.findByObject(GiftPackageDetail.class, query, new Page());
	}
	private  GiftRecord findAndLockGiftRecord(long recordId){
		String sql="select * from giftrecord where recordId=?";
		List<Object> paramList=new ArrayList<Object>();
		paramList.add(recordId);
		List<GiftRecord> list=baseDao.executeQuery(GiftRecord.class, sql, paramList);
		return list.size()==0?null:list.get(0);
	}
	
	/**
	 * 计算过期时间
	 * 
	 * @param days
	 * @return
	 */
	private static String calExpireDate(int days) {
		long now = System.currentTimeMillis();
		long expiretime = now + 24L * 60 * 60 * 1000 * days;
		return sdfDate.format(new Date(expiretime));
	}
	public BaseDao getBaseDao() {
		return baseDao;
	}
	public void setBaseDao(BaseDao baseDao) {
		this.baseDao = baseDao;
	}
}
