package com.xunlei.niux.data.vipgame.bo.bonus;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

import javax.annotation.Resource;

import org.springframework.stereotype.Service;

import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.util.OrderNoUtil;
import com.xunlei.niux.data.vipgame.vo.bonus.SignDayNum;
import com.xunlei.niux.data.vipgame.vo.bonus.SignRecord;
@Service
public class SignRecordBoImpl implements SignRecordBo {
	private static SimpleDateFormat sdf=new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
	private static SimpleDateFormat sdfshort=new SimpleDateFormat("yyyy-MM-dd");
	@Resource(name="BaseDao")
	private BaseDao baseDao;
	@Resource
	private SignDayNumBo signDayNumBo;
	
	public SignDayNumBo getSignDayNumBo() {
		return signDayNumBo;
	}
	public void setSignDayNumBo(SignDayNumBo signDayNumBo) {
		this.signDayNumBo = signDayNumBo;
	}
	
	public BaseDao getBaseDao() {
		return baseDao;
	}
	public void setBaseDao(BaseDao baseDao) {
		this.baseDao = baseDao;
	}

	public List<SignRecord> find(SignRecord signRecord, Page page) {
		return baseDao.findByObject(SignRecord.class, signRecord, page);
	}

	public int count(SignRecord signRecord) {
		return baseDao.count(signRecord);
	}
	public void update(SignRecord signRecord){
		baseDao.updateById(signRecord);
	}
	public SignRecord find(String userId, Long seqId) {
		SignRecord signRecord=new SignRecord();
		signRecord.setUserId(userId);
		signRecord.setSeqId(seqId);
		List<SignRecord> list=find(signRecord, new Page());
		return (list==null||list.size()==0)?null:list.get(0);
	}
	public SignRecord find(String userId, String signDate) {
		SignRecord signRecord=new SignRecord();
		signRecord.setUserId(userId);
		signRecord.setSignDate(signDate);
		List<SignRecord> list=find(signRecord, new Page());
		return (list==null||list.size()==0)?null:list.get(0);
	}
	public SignRecord findLatestSign(String userId) {
		SignRecord signRecord=new SignRecord();
		signRecord.setUserId(userId);
		Page page=new Page();
		page.setPageNo(1);
		page.setPageSize(1);
		//page.addOrder("signTime", OrderType.DESC);
		page.addOrder("signDate", OrderType.DESC);
		List<SignRecord> list=find(signRecord, page);
		return (list==null||list.size()==0)?null:list.get(0);
	}
	public SignRecord insert(SignRecord signRecord,boolean isReSign) {
		Date now=new Date();
		//获取上次签名
		SignRecord latestSignRecord=findLatestSign(signRecord.getUserId());
		//计算连续签到次数
		if(isReSign){
			signRecord.setSeriesSignDays(latestSignRecord.getSeriesSignDays());			
		}else{
			signRecord.setSeriesSignDays(calSeriesSignDays(latestSignRecord, now));
		}		
		signRecord.setSignNo(OrderNoUtil.getOrderNo());
		signRecord.setSignTime(sdf.format(now));
		//signRecord.setSignDate(sdfshort.format(now));
		signRecord.setNextGiveOutTime(sdf.format(now));
		signRecord.setSignSumDays(isReSign?latestSignRecord.getSeriesSignDays():calSignSumDays(latestSignRecord));
		signRecord.setBonusNum(isReSign?1:calSignBonus(signRecord.getSeriesSignDays()));//如果是补签只送一个积分
		signRecord.setGiveOutBonusStatus("0");
		int todaySignIndex=updateSignDayNum(sdfshort.format(now),isReSign);
		signRecord.setTodaySignIndex(todaySignIndex);
		int signTotalBonusNum=calSignBonusTotalNum(latestSignRecord, signRecord.getBonusNum());
		signRecord.setSignTotalBonusNum(isReSign?latestSignRecord.getSignTotalBonusNum()+1:signTotalBonusNum);
		baseDao.insert(signRecord);
		return signRecord;
	}
	private int updateSignDayNum(String signDate,boolean isReSign){
		SignDayNum signDayNum=signDayNumBo.findAndUpdateLock(signDate);
		if(isReSign) return signDayNum.getTotalSignNum();
		if(signDayNum==null){
			signDayNum=new SignDayNum();
			signDayNum.setSignDate(signDate);
			signDayNum.setTotalSignNum(0);
		}
		signDayNum.setTotalSignNum(signDayNum.getTotalSignNum()+1);
		if(signDayNum.getSeqId()==null){
			signDayNumBo.insert(signDayNum);
		}else{
			signDayNumBo.update(signDayNum);
		}
		return signDayNum.getTotalSignNum();
	}
	/**
	 *  计算签到积分
	 *  积分规则如下：
	 *  每日在线签到
	 *	用户第1日签到：1分
	 *	用户连续第2日签到：2分
	 *	……
	 *	用户连续第7日签到：7分
	 *	后续用户每日签到，则一直为7分。当某日用户中断后，重新由1分开始
	 * @param seriesSignDays
	 * @return
	 */
	private int calSignBonus(int seriesSignDays){
		if(seriesSignDays<7){
			return seriesSignDays;
		}
		return 7;
	}
	private int calSignBonusTotalNum(SignRecord latestSignRecord,int bonusNum){
		if(latestSignRecord==null){
			return bonusNum;
		}
		return bonusNum+latestSignRecord.getSignTotalBonusNum();
	}
	/**
	 * 计算连续签到次数
	 * @param latestSignRecord
	 * @param now
	 * @return
	 */
	private int calSeriesSignDays(final SignRecord latestSignRecord,Date now){
		String nowDate=sdfshort.format(now);
		Date yes=new Date(now.getTime()-24*60*60*1000);
		//计算连续签到的次数
		if(latestSignRecord==null){
			return 1;
		}else if(nowDate.equals(latestSignRecord.getSignDate())){
			throw new RuntimeException("今天已签到");
		}else if(latestSignRecord.getSignDate().equals(sdfshort.format(yes))){
			//昨天签到了
			return latestSignRecord.getSeriesSignDays()+1;
		}
		return 1;
	}
	private int calSignSumDays(final SignRecord latestSignRecord){
		//计算连续签到的次数
		if(latestSignRecord==null){
			return 1;
		}
		return latestSignRecord.getSignSumDays()+1;
	}
}
