package com.xunlei.niux.data.vipgame.bo.bonus;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

import javax.annotation.Resource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.bo.BonusProductBo;
import com.xunlei.niux.data.vipgame.bt.bonus.BonusProductBT;
import com.xunlei.niux.data.vipgame.bt.bonus.ExchangeTransBt;
import com.xunlei.niux.data.vipgame.util.OrderNoUtil;
import com.xunlei.niux.data.vipgame.vo.BonusProduct;
import com.xunlei.niux.data.vipgame.vo.bonus.ExchangeTrans;

@Service
public class ExchangeTransBoImpl implements ExchangeTransBo{
	private static SimpleDateFormat sdfShort=new SimpleDateFormat("yyyy-MM-dd");
	private static SimpleDateFormat sdf=new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
	@Resource(name="BaseDao")
	private BaseDao baseDao;
	@Autowired
	private BonusProductBo bonusProductBo;
	@Autowired
	private BonusProductGiveOutDayStatisticsBo bonusProductGiveOutDayStatisticsBo;
	/**
	 * 插入兑换交易记录，并返回最近的交易。
	 * 返回的记录通过seqId判断新旧记录。如果seqId==null，表示新记录
	 * @param pTrans
	 * @return
	 */
	public ExchangeTrans insert(final ExchangeTrans pTrans){
		Date now=new Date();
		//判断产品是否够兑换,并锁定。如果不能兑换时抛出异常
		BonusProduct bonusProduct=bonusProductBo.update_consume(pTrans.getProductNo());
		//判断用户是否已经兑换该产品。如果已兑换就返回已经兑换的交易数据
		ExchangeTrans latestExchangeTrans=checkUserExchanged(pTrans.getUserId(), bonusProduct);
		//如果上次交易为完成，返回上次交易。
		if(latestExchangeTrans!=null){
			//退还锁定的产品
			bonusProductBo.update_rechargefailconsum(pTrans.getProductNo());
			//较少统计中的统计数据
//			bonusProductGiveOutDayStatisticsBo.update_removeOne(pTrans.getProductNo(), latestExchangeTrans.getBalanceDate());
			return latestExchangeTrans;
		}else{
			//判断是否达到每日兑换总上线,如果不够兑换时，抛出异常
			BonusProductBT.checkProductDayEnough(bonusProduct.getProductNo(), sdfShort.format(now), bonusProduct.getEverydayMaxNum());
			//增加到每日统计中
			bonusProductGiveOutDayStatisticsBo.update_addOne(bonusProduct.getProductNo(), sdfShort.format(now));
		}

		//插入本次交易
		ExchangeTrans exchangeTrans=new ExchangeTrans();
		exchangeTrans.setBalanceDate(sdfShort.format(now));
		exchangeTrans.setBonusConsumeStatus("0");//扣除积分中
		exchangeTrans.setBonusConsumeTime("");
		exchangeTrans.setBonusNum(pTrans.getBonusNum());
		exchangeTrans.setExchangeDirect(bonusProduct.getExchangeType());//交易方向
		exchangeTrans.setExchangeStatus("0");//扣除积分中
		exchangeTrans.setExchangeTime(sdf.format(now));
		exchangeTrans.setGameId(bonusProduct.getGameId());
		exchangeTrans.setProductLot(bonusProduct.getProductLot());
		exchangeTrans.setProductName(bonusProduct.getProductName());
		exchangeTrans.setProductNo(bonusProduct.getProductNo());
		exchangeTrans.setProductType(bonusProduct.getProductType());
		exchangeTrans.setProductUnit(bonusProduct.getProductUnit());
		exchangeTrans.setProductNum(pTrans.getProductNum());
		exchangeTrans.setRemark(pTrans.getRemark());
		exchangeTrans.setSerialNumber("");
		exchangeTrans.setServerId(pTrans.getServerId());
		exchangeTrans.setUserId(pTrans.getUserId());
		exchangeTrans.setUserName(pTrans.getUserName());
		exchangeTrans.setExchangeNo(OrderNoUtil.getOrderNo());
		exchangeTrans.setExchangeStatusUpdateTime(sdf.format(now));
		//验证参数是否满足要求,不满足要求抛出异常
		ExchangeTransBt.checkInsertParam(exchangeTrans);
		//插入数据库
		baseDao.insert(exchangeTrans);
		return exchangeTrans;
	}
	/**
	 * 判断用户是否已经兑换该产品。如果已经兑换，返回最后一次兑换的交易记录。
	 * @param userId
	 * @param pBonusProduct
	 * @return
	 */
	public ExchangeTrans checkUserExchanged(String userId,final BonusProduct pBonusProduct){
		//判断用户是否达到每日最大兑换数目。如果达到最大兑换数目，返回最后兑换记录;否则返回null
		ExchangeTrans latestExchangeTrans=checkUserExceedEveryDayExchangeNum(userId, pBonusProduct);
		//如果latestExchangeTrans不为空直接返回
		if(latestExchangeTrans!=null){
			return latestExchangeTrans;
		}
		//判断是否达到约束周期的最大数目.并将结果返回
		return checkUserExceedRestrictExchangeNum(userId, pBonusProduct);
	}
	/**
	 * 判断用户是否达到每日最大兑换数目。
	 * 如果达到最大兑换数目，返回最后兑换记录;否则返回null
	 * @param userId
	 * @param pBonusProduct
	 * @return
	 */
	private ExchangeTrans checkUserExceedEveryDayExchangeNum(String userId,final BonusProduct pBonusProduct){
		//如果没有每日兑换的最大限制，直接返回null
		if(pBonusProduct.getUserEverydayMaxNum()==null||pBonusProduct.getUserEverydayMaxNum()<=0){
			return null;
		}
		Date now = new Date();
		//获取今天兑换数目,包括0:扣积分中；1：发放产品；2：已成功的交易记录
		ExchangeTrans query=new ExchangeTrans();
		query.setUserId(userId);
		query.setProductNo(pBonusProduct.getProductNo());
		query.setToExchangeStatus("3");//0:扣积分中；1：发放产品；2：已成功的交易记录
		query.setBalanceDate(sdfShort.format(now));
		int  count=baseDao.count(query);
		//判断是否达到了今天的最大限制。如果没有达到直接返回空，否则查询出最后提交的兑换记录
		if(count<pBonusProduct.getUserEverydayMaxNum()){
			return null;
		}
		//查询最后提交的兑换记录
		Page page=new Page();
		page.addOrder("exchangeTime",OrderType.DESC);
		page.setPageNo(1);
		page.setPageSize(1);
		return findOne(query,page);
	}
	/**
	 * 判断用户是否达到约束周期的最大兑换数。如果达到，返回最后的交易记录；否则，返回null。
	 * @param userId
	 * @param pBonusProduct
	 * @return
	 */
	private ExchangeTrans checkUserExceedRestrictExchangeNum(String userId,final BonusProduct pBonusProduct){
		//判断约束周期是否有最大交易数量限制。如果没有，直接返回null。
		if(pBonusProduct.getUserRestrictMaxNum()==null||pBonusProduct.getUserRestrictMaxNum()<=0){
			return null;
		}
		//计算约束天数
		Date now = new Date();
		Date restrictDate=null;
		if(pBonusProduct.getRestrictDays()!=null&&pBonusProduct.getRestrictDays()>0){
			restrictDate=new Date(now.getTime()-24*60*60*1000*(pBonusProduct.getRestrictDays()-1));
		}
		//查询用户约束周期内兑换总数，包括0:扣积分中；1：发放产品；2：已成功的交易记录
		ExchangeTrans query=new ExchangeTrans();
		query.setUserId(userId);
		query.setProductNo(pBonusProduct.getProductNo());
		query.setToExchangeStatus("3");//0:扣积分中；1：发放产品；2：已成功的交易记录
		if(restrictDate!=null){
			query.setFromBalanceDate(sdfShort.format(restrictDate));
		}
		int  count=baseDao.count(query);
		//判断是否达到了约束周期的最大限制。如果没有达到直接返回空，否则查询出最后提交的兑换记录
		if(count<pBonusProduct.getUserRestrictMaxNum()){
			return null;
		}
		//查询最后提交的兑换记录
		Page page=new Page();
		page.addOrder("exchangeTime",OrderType.DESC);
		page.setPageNo(1);
		page.setPageSize(1);
		return findOne(query,page);
	}
	/**
	 * 更新消费积分状态，并返回更新后的交易记录。扣除成功进入发放奖品阶段，失败就退还扣除的奖品并交易订单结束。
	 * @param pTrans
	 * @param isSuccess
	 * @return
	 */
	public ExchangeTrans updateBonusConsumeStatus(ExchangeTrans pTrans,boolean isSuccess){
		ExchangeTrans exchangeTrans=find(pTrans.getExchangeNo());
		if(exchangeTrans==null){
			throw new RuntimeException("兑换订单["+pTrans.getExchangeNo()+"]不存在");
		}
		if(!"0".equals(exchangeTrans.getExchangeStatus())){
			throw new RuntimeException("兑换订单["+exchangeTrans.getExchangeNo()+"]不存于积分扣除阶段");
		}
		//如果扣除积分失败，退还产品
		if(isSuccess==false){
			bonusProductBo.update_rechargefailconsum(exchangeTrans.getProductNo());//返还扣除的产品
			//较少统计中的统计数据
			bonusProductGiveOutDayStatisticsBo.update_removeOne(exchangeTrans.getProductNo(), exchangeTrans.getBalanceDate());
		}
		Date now = new Date();
		exchangeTrans.setBonusConsumeTime(sdf.format(now));
		exchangeTrans.setExchangeStatusUpdateTime(sdf.format(now));
		exchangeTrans.setRemark(pTrans.getRemark());
		//如果积分扣除成功，更新状态到下一个
		if(isSuccess){
			exchangeTrans.setExchangeStatus("1");//1：发放产品中
			exchangeTrans.setBonusConsumeStatus("1");//积分扣除成功
		}else{
			exchangeTrans.setExchangeStatus("3");//订单兑换失败
			exchangeTrans.setBonusConsumeStatus("2");//积分扣除失败
		}
		baseDao.updateById(exchangeTrans);
		return exchangeTrans;
	}
	/**
	 * 发放奖品结果更新，并将更新的记录返回。如果发放失败，需要返回产品，并且记录进入到返回积分阶段
	 * @param pTrans
	 * @param isSuccess
	 * @return
	 */
	public ExchangeTrans updateProductGiveOutStatus(ExchangeTrans pTrans,boolean isSuccess){
		ExchangeTrans exchangeTrans=find(pTrans.getExchangeNo());
		if(exchangeTrans==null){
			throw new RuntimeException("兑换订单["+pTrans.getExchangeNo()+"]不存在");
		}
		if(!"1".equals(exchangeTrans.getExchangeStatus())){
			throw new RuntimeException("兑换订单["+exchangeTrans.getExchangeNo()+"]不处于发放奖品阶段");
		}
		//失败退还产品
		if(isSuccess==false){
			bonusProductBo.update_rechargefailconsum(exchangeTrans.getProductNo());
			bonusProductGiveOutDayStatisticsBo.update_removeOne(exchangeTrans.getProductNo(), exchangeTrans.getBalanceDate());
		}
		//更新交易订单状态和其他信息
		Date now = new Date();
		exchangeTrans.setExchangeStatusUpdateTime(sdf.format(now));
		exchangeTrans.setRemark(pTrans.getRemark());
		if(isSuccess){
			exchangeTrans.setSerialNumber(pTrans.getSerialNumber());//更新序列号
			exchangeTrans.setExchangeStatus("2");//订单状态更新为兑换成功
		}else{
			exchangeTrans.setExchangeStatus("4");//订单状态更新为退还积分状态
		}
		baseDao.updateById(exchangeTrans);
		return exchangeTrans;
	}
	/**
	 * 积分退还成功
	 */
	public ExchangeTrans updateBonusReturnSuccess(ExchangeTrans pTrans){
		ExchangeTrans exchangeTrans=find(pTrans.getExchangeNo());
		if(exchangeTrans==null){
			throw new RuntimeException("兑换订单["+pTrans.getExchangeNo()+"]不存在");
		}
		if(!"4".equals(exchangeTrans.getExchangeStatus())){
			throw new RuntimeException("兑换订单["+exchangeTrans.getExchangeNo()+"]不处于退回积分阶段");
		}
		if(!"1".equals(exchangeTrans.getBonusConsumeStatus())){
			throw new RuntimeException("兑换订单["+exchangeTrans.getExchangeNo()+"]未成功扣除积分");
		}
		//更新交易订单状态和其他信息
		Date now = new Date();
		exchangeTrans.setExchangeStatusUpdateTime(sdf.format(now));
		exchangeTrans.setRemark(pTrans.getRemark());
		exchangeTrans.setExchangeStatus("3");
		exchangeTrans.setBonusConsumeStatus("3");
		baseDao.updateById(exchangeTrans);
		return exchangeTrans;
	}
	public List<ExchangeTrans> find(ExchangeTrans pTrans,Page page){
		return baseDao.findByObject(ExchangeTrans.class, pTrans, page);
	}
	public ExchangeTrans findOne(ExchangeTrans pTrans,Page page){
		List<ExchangeTrans> list=find(pTrans,page);
		return (list==null||list.size()==0)?null:list.get(0);
	}
	public ExchangeTrans find(String exchangeNo){
		if(exchangeNo==null||"".equals(exchangeNo)){
			throw new RuntimeException("交易编号为空");
		}
		ExchangeTrans query=new ExchangeTrans();
		query.setExchangeNo(exchangeNo);
		return findOne(query, new Page());
	}
	public int count(ExchangeTrans pTrans){
		return baseDao.count(pTrans);
	}
	public BaseDao getBaseDao() {
		return baseDao;
	}
	public void setBaseDao(BaseDao baseDao) {
		this.baseDao = baseDao;
	}
	public BonusProductBo getBonusProductBo() {
		return bonusProductBo;
	}
	public void setBonusProductBo(BonusProductBo bonusProductBo) {
		this.bonusProductBo = bonusProductBo;
	}
	
}
