/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.data.vipgame.bo;

import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vipgame.bo.BonusProductBo;
import com.xunlei.niux.data.vipgame.bt.bonus.BonusProductBT;
import com.xunlei.niux.data.vipgame.dto.BonusProductDTO;
import com.xunlei.niux.data.vipgame.vo.BonusProduct;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;

public class BonusProductBoImpl
implements BonusProductBo {
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private BaseDao baseDao;

    public BaseDao getBaseDao() {
        return this.baseDao;
    }

    public void setBaseDao(BaseDao baseDao) {
        this.baseDao = baseDao;
    }

    @Override
    public List<BonusProduct> find(BonusProduct product, int pageNo, int pageSize) {
        Page page = new Page();
        page.setPageNo(pageNo);
        page.setPageSize(pageSize);
        page.addOrder("inputTime", OrderType.DESC);
        return this.baseDao.findByObject(BonusProduct.class, (Object)product, page);
    }

    @Override
    public BonusProduct update_consume(String productNo) {
        StringBuilder sb = new StringBuilder();
        sb.append("select * from bonusproduct where productNo=? for update");
        ArrayList<String> list = new ArrayList<String>();
        list.add(productNo);
        List bplist = this.baseDao.executeQuery(BonusProduct.class, sb.toString(), list);
        BonusProduct bp = bplist == null || bplist.size() == 0 ? null : (BonusProduct)bplist.get(0);
        BonusProductBT.checkProductEnoughExchange(bp);
        bp.setProductNum(bp.getProductNum() - 1L);
        bp.setUsedSum(bp.getUsedSum() + 1L);
        this.baseDao.updateById((Object)bp);
        return bp;
    }

    @Override
    public void update_rechargefailconsum(String productNo) {
        BonusProduct bp;
        StringBuilder sb = new StringBuilder();
        sb.append("select * from bonusproduct where productNo=? for update");
        ArrayList<String> list = new ArrayList<String>();
        list.add(productNo);
        List bplist = this.baseDao.executeQuery(BonusProduct.class, sb.toString(), list);
        BonusProduct bonusProduct = bp = bplist == null || bplist.size() == 0 ? null : (BonusProduct)bplist.get(0);
        if (bp == null) {
            throw new RuntimeException("\u4ea7\u54c1\u4e0d\u5b58\u5728");
        }
        bp.setProductNum(bp.getProductNum() + 1L);
        bp.setUsedSum(bp.getUsedSum() - 1L);
        this.baseDao.updateById((Object)bp);
    }

    @Override
    public void update_recharge(BonusProduct pProduct) {
        BonusProduct bp;
        if (pProduct.getProductNo() == null || "".equals(pProduct.getProductNo())) {
            throw new RuntimeException("\u4ea7\u54c1\u4e0d\u5b58\u5728");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("select * from bonusproduct where productNo=? for update");
        ArrayList<String> list = new ArrayList<String>();
        list.add(pProduct.getProductNo());
        List bplist = this.baseDao.executeQuery(BonusProduct.class, sb.toString(), list);
        BonusProduct bonusProduct = bp = bplist == null || bplist.size() == 0 ? null : (BonusProduct)bplist.get(0);
        if (bp == null) {
            throw new RuntimeException("\u4ea7\u54c1\u4e0d\u5b58\u5728");
        }
        bp.setProductNum(bp.getProductNum() + pProduct.getProductNum());
        bp.setProductSum(bp.getProductSum() + pProduct.getProductNum());
        if (bp.getProductNum() < 0L) {
            throw new RuntimeException("\u53ef\u7528\u4ea7\u54c1\u6570\u4e0d\u80fd\u5c0f\u4e8e0");
        }
        bp.setEditBy(pProduct.getEditBy());
        bp.setEditTime(pProduct.getEditTime());
        this.baseDao.updateById((Object)bp);
    }

    @Override
    public void updateSomeData(BonusProduct pProduct) {
        BonusProduct bp;
        StringBuilder sb = new StringBuilder();
        sb.append("select * from bonusproduct where productNo=? for update");
        ArrayList<String> list = new ArrayList<String>();
        list.add(pProduct.getProductNo());
        List bplist = this.baseDao.executeQuery(BonusProduct.class, sb.toString(), list);
        BonusProduct bonusProduct = bp = bplist == null || bplist.size() == 0 ? null : (BonusProduct)bplist.get(0);
        if (bp == null) {
            throw new RuntimeException("\u4ea7\u54c1\u4e0d\u5b58\u5728");
        }
        bp.setProductName(pProduct.getProductName());
        bp.setPrice(pProduct.getPrice());
        bp.setVipPrice(pProduct.getVipPrice());
        bp.setEverydayMaxNum(pProduct.getEverydayMaxNum());
        bp.setUserEverydayMaxNum(pProduct.getUserEverydayMaxNum());
        bp.setUserRestrictMaxNum(pProduct.getUserRestrictMaxNum());
        bp.setRestrictDays(pProduct.getRestrictDays());
        bp.setContent(pProduct.getContent());
        bp.setEditBy(pProduct.getEditBy());
        bp.setEditTime(pProduct.getEditTime());
        bp.setProductStatus(pProduct.getProductStatus());
        bp.setValidPeriod(pProduct.getValidPeriod());
        bp.setMinGameLevel(pProduct.getMinGameLevel() == null ? 0 : pProduct.getMinGameLevel());
        bp.setSuccessTipLink(pProduct.getSuccessTipLink());
        bp.setSuccessTips(pProduct.getSuccessTips());
        bp.setGiveOutType(pProduct.getGiveOutType());
        bp.setMinJinKaLevel(pProduct.getMinJinKaLevel());
        bp.setIsQuFenServer(pProduct.getIsQuFenServer());
        bp.setPlatForm(pProduct.getPlatForm());
        bp.setExchangeDirect(pProduct.getExchangeDirect());
        bp.setGameId(pProduct.getGameId());
        bp.setIsNeedBaiJinVip(pProduct.getIsNeedBaiJinVip());
        bp.setProductLot(pProduct.getProductLot());
        bp.setBaseUnitNum(pProduct.getBaseUnitNum());
        bp.setProductType(pProduct.getProductType());
        bp.setIsSelectRole(pProduct.getIsSelectRole());
        this.baseDao.updateById((Object)bp);
    }

    public List<BonusProduct> findBonusProduct(BonusProduct product, Page page) {
        return this.baseDao.findByObject(BonusProduct.class, (Object)product, page);
    }

    @Override
    public BonusProduct findBonusProductById(long seqId) {
        return (BonusProduct)this.baseDao.findById(BonusProduct.class, (Number)seqId);
    }

    @Override
    public int count(BonusProduct product) {
        return this.baseDao.count((Object)product);
    }

    @Override
    public void update(BonusProduct product) {
        this.baseDao.updateById((Object)product);
    }

    @Override
    public void insert(BonusProduct product) {
        this.baseDao.insert((Object)product);
    }

    @Override
    public void delete(Long seqId) {
        this.baseDao.deleteById(BonusProduct.class, (Number)seqId);
    }

    @Override
    public void execute(String sql, List<Object> list) {
        this.baseDao.execute(sql, list);
    }

    @Override
    public List executeQuery(Class class1, String sql, List list) {
        return this.baseDao.executeQuery(class1, sql, list);
    }

    @Override
    public List<BonusProductDTO> getBonusProductRankingList(int limit) {
        String sql = "select bonusproduct.*,linkinfo.smallpicurl as smallPic from linkinfo\njoin bonusproduct on linkinfo.linklocid = '1273' and linkinfo.linktitle = bonusproduct.seqId\norder by (bonusproduct.productsum - bonusproduct.productnum) DESC limit " + limit + ";";
        ArrayList list = new ArrayList();
        List bplist = this.baseDao.executeQuery(BonusProductDTO.class, sql, list);
        return bplist;
    }
}

