package com.xunlei.niux.data.vip.facade;

import org.springframework.context.support.ClassPathXmlApplicationContext;

import java.util.ResourceBundle;

public class FacadeFactory {
	public static final IFacade INSTANCE;
	static{
		String jndi=getJndiType();
		if("tomcat".equals(jndi)){
			INSTANCE=(IFacade)new ClassPathXmlApplicationContext(new String[]{"com/xunlei/niux/data/vip/xml/tomcatjndi.xml","com/xunlei/niux/data/vip/xml/applicationContext.xml"}).getBean("vipFacade");
		}else if("jdbc".equals(jndi)){
			INSTANCE=(IFacade)new ClassPathXmlApplicationContext(new String[]{"com/xunlei/niux/data/vip/xml/jdbc.xml","com/xunlei/niux/data/vip/xml/applicationContext.xml"}).getBean("vipFacade");
		}else{
			INSTANCE=(IFacade)new ClassPathXmlApplicationContext(new String[]{"com/xunlei/niux/data/vip/xml/springjndi.xml","com/xunlei/niux/data/vip/xml/applicationContext.xml"}).getBean("vipFacade");
		}
	}
	private static String getJndiType(){
		try{
			String type=ResourceBundle.getBundle("jnditype").getString("xlniuxdata_vip_jndi_type");
			if(type==null){
				return "";
			}
			return type.trim().toLowerCase();
		}catch(Exception e){
			return "";
		}
	}
}
