package com.xunlei.niux.data.vip.bo;

import com.ferret.common.dao.BaseDao;
import com.xunlei.niux.data.vip.vo.UserVip;
import com.xunlei.niux.data.vip.vo.VipLevel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import java.util.ArrayList;
import java.util.List;

/**
 * @author hezhong
 */
@Repository
public class UserVipBoImpl implements UserVipBo {

    private static List<VipLevel> vipLevels;

    @Autowired
    private BaseDao baseDao;

    @Autowired
    private VipLevelBo vipLevelBo;

    private final static String INSERT_SQL = "INSERT INTO %s (userId, payMoney, vipLervelNum,createTime,editTime) VALUES (?, ?, ?, ?, ?)";

    @Override
    public void insert(UserVip userVip) {
        if (userVip == null) {
            throw new RuntimeException("UserVip为空");
        }

        if (userVip.getUserId() == null || userVip.getPayMoney() == null) {
            throw new RuntimeException("UserVip的userid或paymoney为空");
        }


        String tableName = getTableName(userVip.getUserId());

        String sql = String.format(INSERT_SQL, tableName);
        List<Object> paramList=new ArrayList<Object>();
        paramList.add(userVip.getUserId());
        paramList.add(userVip.getPayMoney());
        paramList.add(getVipNum(userVip.getPayMoney()));
        paramList.add(userVip.getCreateTime());
        paramList.add(userVip.getEditTime());

        baseDao.execute(sql, paramList);

    }

    private final static String FIND_SQL = "select * from %s where userId = ? %s";

    @Override
    public UserVip find(long userId) {
        return find(userId, false);
    }

    @Override
    public UserVip find(long userId, boolean isLock) {
        String lockStr = "";
        if (isLock) {
            lockStr = " for update ";
        }

        String sql = String.format(FIND_SQL, getTableName(userId), lockStr);
        List<Object> paramList=new ArrayList<Object>();
        paramList.add(userId);
        List<UserVip> list=baseDao.executeQuery(UserVip.class, sql, paramList);

        return (list==null||list.size()==0)?null:list.get(0);
    }

    private static final String UPDATE_SQL = "UPDATE %s SET payMoney = ?,  vipLervelNum = ?,  createTime = ?,  editTime = ? " +
            " WHERE userId = ?";

    @Override
    public void update(UserVip userVip) {
        if (userVip == null) {
            throw new RuntimeException("UserVip为空");
        }

        if (userVip.getUserId() == null || userVip.getPayMoney() == null) {
            throw new RuntimeException("UserVip的userid或paymoney为空");
        }

        String tableName = getTableName(userVip.getUserId());
        String sql = String.format(UPDATE_SQL, tableName);
        List<Object> paramList=new ArrayList<Object>();
        paramList.add(userVip.getPayMoney());
        paramList.add(getVipNum(userVip.getPayMoney()));
        paramList.add(userVip.getCreateTime());
        paramList.add(userVip.getEditTime());
        paramList.add(userVip.getUserId());

        baseDao.execute(sql, paramList);

    }

    private String getTableName(Long userId) {
        if (userId == null || "".equals(userId)) {
            throw new RuntimeException("userId为空");
        }
        return "uservip_" + (userId % 50);
    }

    private int getVipNum(Double money) {
        int vip = 0;

        for (VipLevel vipLevel : getVipLevels()) {
            if (money >= vipLevel.getMinMoney()) {
                vip = vipLevel.getLevelNum();
            }
        }

        return vip;
    }

    public List<VipLevel> getVipLevels() {
        if (vipLevels == null) {
            vipLevels = vipLevelBo.find(new VipLevel());
        }

        return vipLevels;
    }
}
