package com.xunlei.niux.data.vip.bo;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.vip.vo.UserRebateInfo;
import com.xunlei.niux.data.vip.vo.UserRebateRecord;
import com.xunlei.niux.data.vip.vo.UserRebateUseRecord;

@Service
public class UserRebateBoImpl implements UserRebateBo {
	private static SimpleDateFormat sdfTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
	private static SimpleDateFormat sdfDate = new SimpleDateFormat("yyyy-MM-dd");
	@Autowired
	private BaseDao baseDao;

	/**
	 * 添加返利记录
	 * 
	 * @param record
	 * @return
	 */
	public UserRebateRecord addRebateRecord(UserRebateRecord p_record) {
		// 查询和行锁返利信息
		UserRebateInfo rebateInfo = findAndLockRebateInfo(p_record.getUserId());
		if (rebateInfo == null) {
			rebateInfo = new UserRebateInfo();
			rebateInfo.setUserId(p_record.getUserId());
			rebateInfo.setCanUseRebateSum(0);
			rebateInfo.setExpiredRebateSum(0);
			rebateInfo.setLatestRebateSum(0);
			rebateInfo.setRebateSum(0);
			rebateInfo.setUsedRebateSum(0);
			baseDao.insert(rebateInfo);
		}
		rebateInfo.setCanUseRebateSum(rebateInfo.getCanUseRebateSum() + p_record.getRebateMoney());
		rebateInfo.setLatestRebateSum(rebateInfo.getLatestRebateSum() + p_record.getRebateMoney());
		rebateInfo.setRebateSum(rebateInfo.getRebateSum() + p_record.getRebateMoney());
		baseDao.updateById(rebateInfo);

		Long now = System.currentTimeMillis();
		Long expireLong = now + 1L * 24 * 60 * 60 * 1000 * 180;// 180天后失效
		Date expireDate = new Date(expireLong);
		// 插入记录
		UserRebateRecord userRebateRecord = new UserRebateRecord();
		userRebateRecord.setUserId(p_record.getUserId());
		userRebateRecord.setGameId(p_record.getGameId());
		userRebateRecord.setExpireDate(sdfDate.format(expireDate));
		userRebateRecord.setJinKaVipLevel(p_record.getJinKaVipLevel());
		userRebateRecord.setPayOrderMoney(p_record.getPayOrderMoney());
		userRebateRecord.setPayOrderNo(p_record.getPayOrderNo());
		userRebateRecord.setRebateMoney(p_record.getRebateMoney());
		userRebateRecord.setRebateStatus(p_record.getRebateMoney() > 0 ? "WAITUSE" : "NOREBATE");
		userRebateRecord.setRecordTime(sdfTime.format(new Date(now)));
		userRebateRecord.setRoleId(p_record.getRoleId());
		userRebateRecord.setServerId(p_record.getServerId());
		userRebateRecord.setUseRecordNo("");
		userRebateRecord.setRebateNo(p_record.getRebateNo());
		userRebateRecord.setRoleName(p_record.getRoleName());
		userRebateRecord.setServerName(p_record.getServerName());
		baseDao.insert(userRebateRecord);
		return userRebateRecord;
	}

	/**
	 * 添加使用记录
	 * 
	 * @param p_useRecord
	 * @param rebateNos
	 * @return
	 */
	public UserRebateUseRecord addRebateUseRecord(UserRebateUseRecord p_useRecord, String[] rebateNos) {
		UserRebateInfo userRebateInfo = findAndLockRebateInfo(p_useRecord.getUserId());
		userRebateInfo.setCanUseRebateSum(userRebateInfo.getCanUseRebateSum() - p_useRecord.getUseMoney());
		userRebateInfo.setUsedRebateSum(userRebateInfo.getUsedRebateSum() + p_useRecord.getUseMoney());
		baseDao.updateById(userRebateInfo);
		UserRebateUseRecord useRebate = new UserRebateUseRecord();
		useRebate.setGameId(p_useRecord.getGameId());
		useRebate.setRoleId(p_useRecord.getRoleId());
		useRebate.setServerId(p_useRecord.getServerId());
		useRebate.setUseMoney(p_useRecord.getUseMoney());
		useRebate.setUserId(p_useRecord.getUserId());
		useRebate.setUseStatus("W");
		useRebate.setUseTime(sdfTime.format(new Date()));
		useRebate.setUseTimeStamp(0L);
		useRebate.setUseRecordNo(p_useRecord.getUseRecordNo());
		useRebate.setServerName(p_useRecord.getServerName());
		useRebate.setRoleName(p_useRecord.getRoleName());
		baseDao.insert(useRebate);

		for (String rebateNo : rebateNos) {
			if (rebateNo == null || "".equals(rebateNo)) {
				continue;
			}
			UserRebateRecord rebateRecord = baseDao.findById(UserRebateRecord.class, rebateNo);
			if (rebateRecord == null) {
				throw new RuntimeException("返利编号[" + rebateNo + "]不存在对应的记录");
			}
			if (!rebateRecord.getRebateStatus().equals("WAITUSE")) {
				throw new RuntimeException("返利编号[" + rebateNo + "]记录不属于待使用");
			}
			if (rebateRecord.getExpireDate().compareTo(sdfDate.format(new Date())) < 0) {
				throw new RuntimeException("返利编号[" + rebateNo + "]记录已经失效");
			}
			rebateRecord.setRebateStatus("USED");
			rebateRecord.setUseRecordNo(useRebate.getUseRecordNo());
			baseDao.updateById(rebateRecord);
		}
		return p_useRecord;
	}

	/**
	 * 更新使用时间戳
	 */
	public UserRebateUseRecord updateRebateUseRecordTimestamp(String useRecordNo) {
		if (useRecordNo == null || useRecordNo.equals("")) {
			throw new NullPointerException("useRecordNo为空");
		}
		UserRebateUseRecord useRecord = findAndLockRebateUseRecord(useRecordNo);
		if (System.currentTimeMillis() - useRecord.getUseTimeStamp() < 2000) {
			throw new RuntimeException("访问太频繁");
		}
		useRecord.setUseTimeStamp(System.currentTimeMillis());
		baseDao.updateById(useRecord);
		return useRecord;
	}

	private UserRebateUseRecord findAndLockRebateUseRecord(String useRecordNo) {
		if (useRecordNo == null || useRecordNo.equals("")) {
			throw new NullPointerException("useRecordNo为空");
		}
		String sql = "select * from user_rebate_userecord where useRecordNo=?";
		List<Object> paramList = new ArrayList<Object>();
		paramList.add(useRecordNo);
		List<UserRebateUseRecord> list = baseDao.executeQuery(UserRebateUseRecord.class, sql, paramList);
		return (list == null || list.size() == 0) ? null : list.get(0);
	}

	/**
	 * 查询和行锁
	 * 
	 * @param userId
	 * @return
	 */
	private UserRebateInfo findAndLockRebateInfo(String userId) {
		if (userId == null || "".equals(userId)) {
			throw new NullPointerException("userId为空");
		}
		String sql = "select * from user_rebate_info where userId=?";
		List<Object> paramList = new ArrayList<Object>();
		paramList.add(userId);
		List<UserRebateInfo> list = baseDao.executeQuery(UserRebateInfo.class, sql, paramList);
		return (list == null || list.size() == 0) ? null : list.get(0);
	}

	/**
	 * 清空最近的返利总额
	 * 
	 * @param userId
	 */
	public void updateRebateInfoLatestRebateSumZero(String userId) {
		UserRebateInfo rebateInfo = findAndLockRebateInfo(userId);
		rebateInfo.setLatestRebateSum(0);
		baseDao.updateById(rebateInfo);
	}

	/**
	 * 
	 * @param userId
	 * @param rebateMoney
	 */
	public void addHistoryRebate(String userId, int rebateMoney) {
		if (userId == null || "".equals(userId)) {
			throw new NullPointerException();
		}
		// 插入记录
		UserRebateRecord userRebateRecord = new UserRebateRecord();
		userRebateRecord.setUserId(userId);
		userRebateRecord.setGameId("");
		userRebateRecord.setExpireDate("2013-10-09");
		userRebateRecord.setJinKaVipLevel(0);
		userRebateRecord.setPayOrderMoney(rebateMoney);
		userRebateRecord.setPayOrderNo("payhis" + userId);
		userRebateRecord.setRebateMoney(rebateMoney);
		userRebateRecord.setRebateStatus("USED");
		userRebateRecord.setRecordTime("2013-10-10 12:00:00");
		userRebateRecord.setRoleId("");
		userRebateRecord.setServerId("");
		userRebateRecord.setUseRecordNo("");
		userRebateRecord.setRebateNo("rebatehis" + userId);
		userRebateRecord.setRoleName("");
		userRebateRecord.setServerName("");
		baseDao.insert(userRebateRecord);

		// 更新总数
		UserRebateInfo rebateInfo = findAndLockRebateInfo(userId);
		if (rebateInfo == null) {
			rebateInfo = new UserRebateInfo();
			rebateInfo.setUserId(userId);
			rebateInfo.setCanUseRebateSum(0);
			rebateInfo.setExpiredRebateSum(0);
			rebateInfo.setLatestRebateSum(0);
			rebateInfo.setRebateSum(0);
			rebateInfo.setUsedRebateSum(0);
			baseDao.insert(rebateInfo);
		}
		rebateInfo.setUsedRebateSum(rebateInfo.getUsedRebateSum() + rebateMoney);
		rebateInfo.setRebateSum(rebateInfo.getRebateSum() + rebateMoney);
		baseDao.updateById(rebateInfo);
	}

	public void updateFailUseRecord(String userId, String useRecordNo) {
		if (useRecordNo == null || "".equals(useRecordNo) || userId == null || "".equals(userId)) {
			throw new NullPointerException();
		}
		// 锁定记录
		UserRebateInfo userRebateInfo = findAndLockRebateInfo(userId);
		
		// 查看使用记录是否符合返回的标准
		UserRebateUseRecord useRecord = baseDao.findById(UserRebateUseRecord.class, useRecordNo);
		if (!useRecord.getUseStatus().equals("F")) {
			throw new RuntimeException("订单[" + useRecordNo + "]编号非法");
		}
		if (!useRecord.getUserId().equals(userId)) {
			throw new RuntimeException("订单[" + useRecordNo + "]用户不一致");
		}
		useRecord.setUseStatus("R");// 已返回状态
		baseDao.updateById(useRecord);
		
		// 更新用户返利记录
		userRebateInfo.setCanUseRebateSum(userRebateInfo.getCanUseRebateSum() + useRecord.getUseMoney());
		userRebateInfo.setUsedRebateSum(userRebateInfo.getUsedRebateSum() - useRecord.getUseMoney());
		if (userRebateInfo.getUsedRebateSum() < 0) {
			throw new RuntimeException("用户[" + useRecord.getUserId() + "]已使用返利金额["
					+ userRebateInfo.getUsedRebateSum() + "]非法");
		}
		if (userRebateInfo.getRebateSum() != userRebateInfo.getCanUseRebateSum()
				+ userRebateInfo.getUsedRebateSum() + userRebateInfo.getExpiredRebateSum()) {
			throw new RuntimeException("用户[" + useRecord.getUserId() + "]总返利与各明细不一致");
		}
		baseDao.updateById(userRebateInfo);

		//更新具体明细
		UserRebateRecord queryRecord = new UserRebateRecord();
		queryRecord.setUseRecordNo(useRecordNo);
		List<UserRebateRecord> recordList = baseDao.findByObject(UserRebateRecord.class, queryRecord,
				new Page());
		int money = 0;
		for (UserRebateRecord record : recordList) {
			money = money + record.getRebateMoney();
			if (!record.getUserId().equals(useRecord.getUserId())) {
				throw new RuntimeException("用户[" + useRecord.getUserId() + "]返利记录[" + record.getRebateNo()
						+ "]用户不一致");
			}
			if (!record.getRebateStatus().equals("USED")) {
				throw new RuntimeException("用户[" + useRecord.getUserId() + "]返利记录[" + record.getRebateNo()
						+ "]不处于使用阶段");
			}
			if(!record.getUseRecordNo().equals(useRecordNo)){
				throw new RuntimeException("非法使用编号");
			}
			record.setRebateStatus("WAITUSE");
			record.setUseRecordNo("");
			baseDao.updateById(record);
		}
        //金额不一致所有更新通过异常回滚
		if (money != useRecord.getUseMoney()) {
			throw new RuntimeException("金额不统一");
		}
	}
}
