/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.data.vip.bo;

import com.ferret.common.dao.BaseDao;
import com.xunlei.niux.data.vip.bo.UserVipBo;
import com.xunlei.niux.data.vip.bo.VipLevelBo;
import com.xunlei.niux.data.vip.vo.Order;
import com.xunlei.niux.data.vip.vo.UserVip;
import com.xunlei.niux.data.vip.vo.VipLevel;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class UserVipBoImpl
implements UserVipBo {
    private static List<VipLevel> vipLevels;
    @Autowired
    private BaseDao baseDao;
    @Autowired
    private VipLevelBo vipLevelBo;
    private static final String INSERT_SQL = "INSERT INTO %s (userId, payMoney, vipLervelNum,createTime,editTime) VALUES (?, ?, ?, ?, ?)";
    private static final String FIND_SQL = "select * from %s where userId = ? %s";
    private static final String UPDATE_SQL = "UPDATE %s SET payMoney = ?,  vipLervelNum = ?,  createTime = ?,  editTime = ?  WHERE userId = ?";

    @Override
    public void insert(UserVip userVip) {
        if (userVip == null) {
            throw new RuntimeException("UserVip\u4e3a\u7a7a");
        }
        if (userVip.getUserId() == null || userVip.getPayMoney() == null) {
            throw new RuntimeException("UserVip\u7684userid\u6216paymoney\u4e3a\u7a7a");
        }
        String tableName = this.getTableName(userVip.getUserId());
        String sql = String.format(INSERT_SQL, tableName);
        ArrayList<Object> paramList = new ArrayList<Object>();
        paramList.add(userVip.getUserId());
        paramList.add(userVip.getPayMoney());
        paramList.add(this.getVipNum(userVip.getPayMoney()));
        paramList.add(userVip.getCreateTime());
        paramList.add(userVip.getEditTime());
        this.baseDao.execute(sql, paramList);
    }

    public void insert(Order order) {
        this.baseDao.insert((Object)order);
    }

    @Override
    public void insert(UserVip userVip, Order order) {
        this.insert(order);
        this.insert(userVip);
    }

    @Override
    public UserVip find(long userId) {
        return this.find(userId, false);
    }

    @Override
    public UserVip find(long userId, boolean isLock) {
        String lockStr = "";
        if (isLock) {
            lockStr = " for update ";
        }
        String sql = String.format(FIND_SQL, this.getTableName(userId), lockStr);
        ArrayList<Long> paramList = new ArrayList<Long>();
        paramList.add(userId);
        List list = this.baseDao.executeQuery(UserVip.class, sql, paramList);
        return list == null || list.size() == 0 ? null : (UserVip)list.get(0);
    }

    @Override
    public void update(UserVip userVip, Order order) {
        this.insert(order);
        this.update(userVip);
    }

    @Override
    public void update(UserVip userVip) {
        if (userVip == null) {
            throw new RuntimeException("UserVip\u4e3a\u7a7a");
        }
        if (userVip.getUserId() == null || userVip.getPayMoney() == null) {
            throw new RuntimeException("UserVip\u7684userid\u6216paymoney\u4e3a\u7a7a");
        }
        String tableName = this.getTableName(userVip.getUserId());
        String sql = String.format(UPDATE_SQL, tableName);
        ArrayList<Object> paramList = new ArrayList<Object>();
        paramList.add(userVip.getPayMoney());
        paramList.add(this.getVipNum(userVip.getPayMoney()));
        paramList.add(userVip.getCreateTime());
        paramList.add(userVip.getEditTime());
        paramList.add(userVip.getUserId());
        this.baseDao.execute(sql, paramList);
    }

    private String getTableName(Long userId) {
        if (userId == null || "".equals(userId)) {
            throw new RuntimeException("userId\u4e3a\u7a7a");
        }
        return "uservip_" + userId % 50L;
    }

    private int getVipNum(Double money) {
        int vip = 0;
        for (VipLevel vipLevel : this.getVipLevels()) {
            if (!(money >= (double)vipLevel.getMinMoney().intValue())) continue;
            vip = vipLevel.getLevelNum();
        }
        return vip;
    }

    public List<VipLevel> getVipLevels() {
        if (vipLevels == null) {
            vipLevels = this.vipLevelBo.find(new VipLevel());
        }
        return vipLevels;
    }
}

