package com.xunlei.niux.data.gateway.vo;

import com.ferret.common.dao.annotation.Column;
import com.ferret.common.dao.annotation.Exclude;
import com.ferret.common.dao.annotation.Table;
import com.ferret.common.dao.enums.Operator;
import com.xunlei.common.util.Extendable;

/**
 * Created by hhb on 19/03/2018.
 */
@Table(tableName = "paygatewayinfo", pkFieldName = "seqId", pkFieldAssign = false)
public class PayGatewayInfo {

    private String  seqId;

    /**
     * 本文档为固定值：v2.0
     */
    @Exclude
    private String version;

    /**
     * 登录态ID,可以是WEB、客户端
     */
    @Exclude
    private String sessionid;

    /**
     * 用户内部ID,公司帐号总库的内部ID，唯一确定一个帐号
     */
    private String userid;

    /**
     * sessionid的 类型
     * web 表示sessionid是web登录的sessionid ，oauth 表示sessionid是第三方登录的 ；==-1表示sessionid是客户端的（如果是内网需要设置为相应的业务ID） 默认值为 web
     */
    @Exclude
    private String opid;

    /**
     * 活动id
     * 20001 商品或商品类型ID 业务线接入请使用分配给各业务线的ID 购买同一个商品（业务号相同）但可以有不同的活动ID，商户的验证接口可以跟据不同的活动ID计算不同的价格
     */
    private String activeid;

    /**
     * 业务号
     * 一个业务号可以对应多个活动ID xiazaibao 下载宝
     */
    private String bizno;

    /**
     * 购买数量
     */
    private String num;

    /**
     * 价格
     * 下单价格（下单的最终价格以相应活动ID配置的接口的返回结果来确定），计量单位分（1元==100分） 最后支付的价格是以业务方接口的返回结果决定的
     */
    private String rmb;

    /**
     *支付方式
     *现在支持的支付方式：E、E2、A1、B、N2、W4
     */
    private String paytype;

    /**
     * 支付源
     * paytype==B 必须bankNo 参数的值为具体银行的编号 CCB ICBC 具体请查看渠道网关的文档
     */
    private String bankNo;

    /**
     * 网关备用参数
     * paytype==A1 必须 other1 参数，参数值为雷点帐户密码一次MD5加密（不区分大小写）
     */
    private String other1;

    /**
     * 支付成功后 用户浏览器 跳转的地址
     * 当需要用户做页面支付动作时，成功后 由迅雷支付跳转的地址，可用来显示用 户订单的结果
     */
    @Exclude
    private String fgUrl;
    /**
     * 扩展数据
     * 扩展参数的数据支付中心不会进行任何处理，会原样传递给商户的验证接口、下单通知接口及支付成功通知接口,扩展数据格式: a1=xx&a2=xxx&a3=xxx  必须URLENCODE
     */
    private String ext2;

    /**
     * 扩展数据
     * Json格式的扩展字段， {"actData":"xx"} actData 表示是活动类支付的扩展字段 xx 为业务方要保存的数据 mAid:支付接入位置（值由支付的开发分配） 0=末定义 1=web 2=wap 3=支付浮层 4=页游web页，5=页游浮层
     */
    private String ext3;

    /**
     * 业务来源
     * 用于区分业务流量（如果这个参数不为空则在订单数据的ext1字段中保存有mRef=xxx），接入方原则上应该传该参数，值由支付中心分配
     */
    private String mref;

    /**
     * 支付来源
     * 用于区分支付来源（如果这个参数不为空则在订单数据的ext1字段中保存有fRef=xxx）
     */
    private String referfrom;

    /**
     * 支付位置
     * 用于区分支付来源（如果这个参数不为空则在订单数据的ext1字段中保存有fAid=xxx）
     */
    private String aidfrom;

    /**
     * 订单id
     */
    private String orderid;

    /**
     * 下单时间
     */
    private String fordertime;

    @Column(columnName="fordertime",isWhereColumn=true,operator= Operator.GE)
    private String fromOrderTime;

    @Column(columnName="fordertime",isWhereColumn=true,operator=Operator.LT)
    private String toOrderTime;
    
    /**
     * 支付时间
     */
    private String fxlpaytime;
    
    /**
     * 支付id
     */
    private String fxlpayid;

    private String updatetime;

    //newPayHandle 使用 。新增参数 begin ------------
    @Exclude
    private String ext1;
    @Exclude
    private String orderTime;
    @Exclude
    private String other2;
    @Exclude
    private String pageCharset;
    @Exclude
    private String bgUrl;
    @Exclude
    private String bizNo;
    @Exclude
    private String orderId;
    @Exclude
    private String orderAmt;
    @Exclude
    private String productName;
    @Exclude
    private String productDesc;
    @Exclude
    private String xlnumId;
    @Exclude
    private String clientIp;
    @Exclude
    private String payType;
    @Exclude
    private String peerId;
    @Exclude
    private String signMsg;
    //可能有的参数begin---
    @Exclude
    private String other3;
    @Exclude
    private String xunleiId;
    @Exclude
    private String payerName;
    @Exclude
    private String payerContact;
    //可能有的参数end---
    //新增参数 end ------------
    
    //第三方渠道id
    private String channelid;

    //支付成功展示username
    private String username;

    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

	public String getChannelid() {
		return channelid;
	}

	public void setChannelid(String channelid) {
		this.channelid = channelid;
	}

	public String getUpdatetime() {
        return updatetime;
    }

    public void setUpdatetime(String updatetime) {
        this.updatetime = updatetime;
    }

    public String getOrderid() {
        return orderid;
    }

    public void setOrderid(String orderid) {
        this.orderid = orderid;
    }

    public String getFordertime() {
        return fordertime;
    }

    public void setFordertime(String fordertime) {
        this.fordertime = fordertime;
    }

    public String getFxlpaytime() {
        return fxlpaytime;
    }

    public void setFxlpaytime(String fxlpaytime) {
        this.fxlpaytime = fxlpaytime;
    }

    public String getFxlpayid() {
        return fxlpayid;
    }

    public void setFxlpayid(String fxlpayid) {
        this.fxlpayid = fxlpayid;
    }

    public String getVersion() {
        return version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getSessionid() {
        return sessionid;
    }

    public void setSessionid(String sessionid) {
        this.sessionid = sessionid;
    }

    public String getUserid() {
        return userid;
    }

    public void setUserid(String userid) {
        this.userid = userid;
    }

    public String getOpid() {
        return opid;
    }

    public void setOpid(String opid) {
        this.opid = opid;
    }

    public String getActiveid() {
        return activeid;
    }

    public void setActiveid(String activeid) {
        this.activeid = activeid;
    }

    public String getBizno() {
        return bizno;
    }

    public void setBizno(String bizno) {
        this.bizno = bizno;
    }

    public String getNum() {
        return num;
    }

    public void setNum(String num) {
        this.num = num;
    }

    public String getRmb() {
        return rmb;
    }

    public void setRmb(String rmb) {
        this.rmb = rmb;
    }

    public String getPaytype() {
        return paytype;
    }

    public void setPaytype(String paytype) {
        this.paytype = paytype;
    }

    public String getBankNo() {
        return bankNo;
    }

    public void setBankNo(String bankNo) {
        this.bankNo = bankNo;
    }

    public String getOther1() {
        return other1;
    }

    public void setOther1(String other1) {
        this.other1 = other1;
    }

    public String getFgUrl() {
        return fgUrl;
    }

    public void setFgUrl(String fgUrl) {
        this.fgUrl = fgUrl;
    }

    public String getExt2() {
        return ext2;
    }

    public void setExt2(String ext2) {
        this.ext2 = ext2;
    }

    public String getExt3() {
        return ext3;
    }

    public void setExt3(String ext3) {
        this.ext3 = ext3;
    }

    public String getMref() {
        return mref;
    }

    public void setMref(String mref) {
        this.mref = mref;
    }

    public String getReferfrom() {
        return referfrom;
    }

    public void setReferfrom(String referfrom) {
        this.referfrom = referfrom;
    }

    public String getAidfrom() {
        return aidfrom;
    }

    public void setAidfrom(String aidfrom) {
        this.aidfrom = aidfrom;
    }

    public String getSeqId() {
        return seqId;
    }

    public void setSeqId(String seqId) {
        this.seqId = seqId;
    }


    //新增参数 begin ------------
	public String getExt1() {
		return ext1;
	}

	public void setExt1(String ext1) {
		this.ext1 = ext1;
	}

	public String getOrderTime() {
		return orderTime;
	}

	public void setOrderTime(String orderTime) {
		this.orderTime = orderTime;
	}

	public String getOther2() {
		return other2;
	}

	public void setOther2(String other2) {
		this.other2 = other2;
	}

	public String getPageCharset() {
		return pageCharset;
	}

	public void setPageCharset(String pageCharset) {
		this.pageCharset = pageCharset;
	}

	public String getBgUrl() {
		return bgUrl;
	}

	public void setBgUrl(String bgUrl) {
		this.bgUrl = bgUrl;
	}

	public String getBizNo() {
		return bizNo;
	}

	public void setBizNo(String bizNo) {
		this.bizNo = bizNo;
	}

	public String getOrderId() {
		return orderId;
	}

	public void setOrderId(String orderId) {
		this.orderId = orderId;
	}

	public String getOrderAmt() {
		return orderAmt;
	}

	public void setOrderAmt(String orderAmt) {
		this.orderAmt = orderAmt;
	}

	public String getProductName() {
		return productName;
	}

	public void setProductName(String productName) {
		this.productName = productName;
	}

	public String getProductDesc() {
		return productDesc;
	}

	public void setProductDesc(String productDesc) {
		this.productDesc = productDesc;
	}

	public String getXlnumId() {
		return xlnumId;
	}

	public void setXlnumId(String xlnumId) {
		this.xlnumId = xlnumId;
	}

	public String getClientIp() {
		return clientIp;
	}

	public void setClientIp(String clientIp) {
		this.clientIp = clientIp;
	}

	public String getPayType() {
		return payType;
	}

	public void setPayType(String payType) {
		this.payType = payType;
	}

	public String getPeerId() {
		return peerId;
	}

	public void setPeerId(String peerId) {
		this.peerId = peerId;
	}

	public String getSignMsg() {
		return signMsg;
	}

	public void setSignMsg(String signMsg) {
		this.signMsg = signMsg;
	}

	public String getOther3() {
		return other3;
	}

	public void setOther3(String other3) {
		this.other3 = other3;
	}

	public String getXunleiId() {
		return xunleiId;
	}

	public void setXunleiId(String xunleiId) {
		this.xunleiId = xunleiId;
	}

	public String getPayerName() {
		return payerName;
	}

	public void setPayerName(String payerName) {
		this.payerName = payerName;
	}

	public String getPayerContact() {
		return payerContact;
	}

	public void setPayerContact(String payerContact) {
		this.payerContact = payerContact;
	}
    //新增参数 end ------------

	@Override
	public String toString() {
		return "PayGatewayInfo [seqId=" + seqId + ", version=" + version
				+ ", sessionid=" + sessionid + ", userid=" + userid + ", opid="
				+ opid + ", activeid=" + activeid + ", bizno=" + bizno
				+ ", num=" + num + ", rmb=" + rmb + ", paytype=" + paytype
				+ ", bankNo=" + bankNo + ", other1=" + other1 + ", fgUrl="
				+ fgUrl + ", ext2=" + ext2 + ", ext3=" + ext3 + ", mref="
				+ mref + ", referfrom=" + referfrom + ", aidfrom=" + aidfrom
				+ ", orderid=" + orderid + ", fordertime=" + fordertime
				+ ", fxlpaytime=" + fxlpaytime + ", fxlpayid=" + fxlpayid
				+ ", updatetime=" + updatetime + ", ext1=" + ext1
				+ ", orderTime=" + orderTime + ", other2=" + other2
				+ ", pageCharset=" + pageCharset + ", bgUrl=" + bgUrl
				+ ", bizNo=" + bizNo + ", orderId=" + orderId + ", orderAmt="
				+ orderAmt + ", productName=" + productName + ", productDesc="
				+ productDesc + ", xlnumId=" + xlnumId + ", clientIp="
				+ clientIp + ", payType=" + payType + ", peerId=" + peerId
				+ ", signMsg=" + signMsg + ", other3=" + other3 + ", xunleiId="
				+ xunleiId + ", payerName=" + payerName + ", payerContact="
				+ payerContact + "]";
	}

	public String getFromOrderTime() {
		return fromOrderTime;
	}

	public void setFromOrderTime(String fromOrderTime) {
		this.fromOrderTime = fromOrderTime;
	}

	public String getToOrderTime() {
		return toOrderTime;
	}

	public void setToOrderTime(String toOrderTime) {
		this.toOrderTime = toOrderTime;
	}
	
	
	
}
