package com.xunlei.niux.data.gateway.facade;

import java.util.ResourceBundle;

import org.springframework.context.support.ClassPathXmlApplicationContext;

public class FacadeFactory {
	public static final IFacade INSTANCE;
	private static ClassPathXmlApplicationContext context;
	static{
		String jndi=getJndiType();
		if("tomcat".equals(jndi)){
			context=new ClassPathXmlApplicationContext(new String[]{"com/xunlei/niux/data/gateway/xml/tomcatjndi.xml","com/xunlei/niux/data/gateway/xml/applicationContext.xml"});
			INSTANCE=(IFacade)context.getBean("GatewayFacade");
		}else if("jdbc".equals(jndi)){
			INSTANCE=(IFacade)new ClassPathXmlApplicationContext(new String[]{"com/xunlei/niux/data/gateway/xml/jdbc.xml","com/xunlei/niux/data/gateway/xml/applicationContext.xml"}).getBean("GatewayFacade");
		}else{
			INSTANCE=(IFacade)new ClassPathXmlApplicationContext(new String[]{"com/xunlei/niux/data/gateway/xml/springjndi.xml","com/xunlei/niux/data/gateway/xml/applicationContext.xml"}).getBean("GatewayFacade");
		}
	}
	private static String getJndiType(){
		try{
			String type=ResourceBundle.getBundle("jnditype").getString("xlniuxdata_gateway_jndi_type");
			if(type==null){
				return "";
			}
			return type.trim().toLowerCase();
		}catch(Exception e){
			return "";
		}
	}
}
