package com.xunlei.niux.data.pay.dao;

import org.apache.log4j.Logger;

import com.xunlei.common.dao.JdbcBaseDao;
import com.xunlei.niux.data.pay.vo.PayDetailOK;

public class PayDetailOKDaoImpl extends JdbcBaseDao implements IPayDetailOKDao {

	private static Logger log = Logger.getLogger(PayDetailOKDaoImpl.class);

	public double queryDaySumAllAmt(PayDetailOK data) {
		StringBuilder sql = new StringBuilder(
				"select sum(TotalMoney) from paydetailok  where OrderIdStatus='S' and PayCode='00' ");
		if (isNotEmpty(data.getSuccesstime())) {
			sql.append("And SuccessTime>='").append(data.getSuccesstime())
					.append(" 00:00:00' ");
			sql.append("And SuccessTime<='").append(data.getSuccesstime())
					.append(" 23:59:59' ");
		}
		sql.append("And gameid='").append(data.getGameid()).append("' ");
		return getSingleDouble(sql.toString());
	}

	public double queryDaySumGiftAmt(PayDetailOK data) {
		StringBuilder sql = new StringBuilder(
				"select sum(TotalMoney) from paydetailok  where OrderIdStatus='S' and PayCode='00' and GiftFlag='1' ");
		if (isNotEmpty(data.getSuccesstime())) {
			sql.append("And SuccessTime>='").append(data.getSuccesstime())
					.append(" 00:00:00' ");
			sql.append("And SuccessTime<='").append(data.getSuccesstime())
					.append(" 23:59:59' ");
		}
		sql.append("And gameid='").append(data.getGameid()).append("' ");
		sql.append("And ToInnerUserid not in ('123540516','292604999','8326841') ");
		return getSingleDouble(sql.toString());
	}

	public double queryDaySumIncomeAmt(PayDetailOK data) {
		StringBuilder sql = new StringBuilder(
				"select sum(TotalMoney) from paydetailok  where OrderIdStatus='S' and PayCode='00' ");
		if (isNotEmpty(data.getSuccesstime())) {
			sql.append("And SuccessTime>='").append(data.getSuccesstime())
					.append(" 00:00:00' ");
			sql.append("And SuccessTime<='").append(data.getSuccesstime())
					.append(" 23:59:59' ");
		}
		sql.append("And gameid='").append(data.getGameid()).append("' ");
		sql.append("And ToInnerUserid not in ('123540516','292604999','8326841') ");
		return getSingleDouble(sql.toString());
	}

	public double queryDaySumTestAmt(PayDetailOK data) {
		StringBuilder sql = new StringBuilder(
				"select sum(TotalMoney) from paydetailok  where OrderIdStatus='S' and PayCode='00' ");
		if (isNotEmpty(data.getSuccesstime())) {
			sql.append("And SuccessTime>='").append(data.getSuccesstime())
					.append(" 00:00:00' ");
			sql.append("And SuccessTime<='").append(data.getSuccesstime())
					.append(" 23:59:59' ");
		}
		sql.append("And gameid='").append(data.getGameid()).append("' ");
		sql.append("And ToInnerUserid  in ('123540516','292604999','8326841') ");
		return getSingleDouble(sql.toString());
	}

	public int queryDayIncomeOrderNums(PayDetailOK data) {
		StringBuilder sql = new StringBuilder(
				"select count(1) from paydetailok  where OrderIdStatus='S' and PayCode='00' ");
		if (isNotEmpty(data.getSuccesstime())) {
			sql.append("And SuccessTime>='").append(data.getSuccesstime())
					.append(" 00:00:00' ");
			sql.append("And SuccessTime<='").append(data.getSuccesstime())
					.append(" 23:59:59' ");
		}
		sql.append("And gameid='").append(data.getGameid()).append("' ");
		sql.append("And ToInnerUserid not in ('123540516','292604999','8326841') ");
		return getSingleInt(sql.toString());
	}

	public int queryDayTestOrderNums(PayDetailOK data) {
		StringBuilder sql = new StringBuilder(
				"select count(1) from paydetailok  where OrderIdStatus='S' and PayCode='00' ");
		if (isNotEmpty(data.getSuccesstime())) {
			sql.append("And SuccessTime>='").append(data.getSuccesstime())
					.append(" 00:00:00' ");
			sql.append("And SuccessTime<='").append(data.getSuccesstime())
					.append(" 23:59:59' ");
		}
		sql.append("And gameid='").append(data.getGameid()).append("' ");
		sql.append("And ToInnerUserid in ('123540516','292604999','8326841') ");
		return getSingleInt(sql.toString());
	}

	public double queryDayVouchersMoney(PayDetailOK data) {
		StringBuffer sql = new StringBuffer(
				"select sum(vouchersMoney) from paydetailok  where GiftFlag='2' and OrderIdStatus='S' and PayCode='00' ");
		if (isNotEmpty(data.getSuccesstime())) {
			sql.append("And SuccessTime>='").append(data.getSuccesstime())
					.append(" 00:00:00' ");
			sql.append("And SuccessTime<='").append(data.getSuccesstime())
					.append(" 23:59:59' ");
		}
		sql.append("And gameid='").append(data.getGameid()).append("' ");
		sql.append("And ToInnerUserid not in ('123540516','292604999','8326841') ");
		return getSingleDouble(sql.toString());
	}
}
