package com.xunlei.niux.data.pay.bo;

import java.util.List;

import com.ferret.common.dao.BaseDao;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.pay.dao.IPayDetailOKDao;
import com.xunlei.niux.data.pay.vo.PayDetailOK;

public class PayDetailOkBoImpl implements PayDetailOkBo {
	private BaseDao baseDao;
	private IPayDetailOKDao payDetailOKDao;

	public BaseDao getBaseDao() {
		return baseDao;
	}

	public void setBaseDao(BaseDao baseDao) {
		this.baseDao = baseDao;
	}

	public IPayDetailOKDao getPayDetailOKDao() {
		return payDetailOKDao;
	}

	public void setPayDetailOKDao(IPayDetailOKDao payDetailOKDao) {
		this.payDetailOKDao = payDetailOKDao;
	}

	public List<PayDetailOK> findPayDetailOk(PayDetailOK payDetailOk, Page page) {
		return baseDao.findByObject(PayDetailOK.class, payDetailOk, page);
	}

	public int count(PayDetailOK payDetailOk) {
		return baseDao.count(payDetailOk);
	}

	public void update(PayDetailOK payDetailOk) {
		baseDao.updateById(payDetailOk);
	}

	public void insert(PayDetailOK payDetailOk) {
		baseDao.insert(payDetailOk);
	}

	public void delete(Long seqId) {
		baseDao.deleteById(PayDetailOK.class, seqId);
	}

	public void execute(String sql, List<Object> list) {
		baseDao.execute(sql, list);

	}

	public List executeQuery(Class<?> clazz, String sql) {
		return baseDao.findBySql(clazz, sql);
	}

	@Override
	public double queryDaySumAllAmt(PayDetailOK data) {
		return payDetailOKDao.queryDaySumAllAmt(data);
	}

	@Override
	public double queryDaySumGiftAmt(PayDetailOK data) {
		return payDetailOKDao.queryDaySumGiftAmt(data);
	}

	@Override
	public double queryDaySumIncomeAmt(PayDetailOK data) {
		return payDetailOKDao.queryDaySumIncomeAmt(data);
	}

	@Override
	public double queryDaySumTestAmt(PayDetailOK data) {
		return payDetailOKDao.queryDaySumTestAmt(data);
	}

	@Override
	public int queryDayIncomeOrderNums(PayDetailOK data) {
		return payDetailOKDao.queryDayIncomeOrderNums(data);
	}

	@Override
	public int queryDayTestOrderNums(PayDetailOK data) {
		return payDetailOKDao.queryDayTestOrderNums(data);
	}

	@Override
	public double queryDayVouchersMoney(PayDetailOK data) {
		return payDetailOKDao.queryDayVouchersMoney(data);
	}
}
