package com.xunlei.niux.data.pay.facade;

import java.util.ResourceBundle;

import org.springframework.context.support.ClassPathXmlApplicationContext;

public class FacadeFactory {
	public static final IFacade INSTANCE;
	static{
		String jndi=getJndiType();
		if("tomcat".equals(jndi)){
			INSTANCE=(IFacade)new ClassPathXmlApplicationContext(new String[]{"com/xunlei/niux/data/pay/xml/tomcatjndi.xml","com/xunlei/niux/data/pay/xml/applicationContext.xml"}).getBean("PayFacade");
		}else if("jdbc".equals(jndi)){
			INSTANCE=(IFacade)new ClassPathXmlApplicationContext(new String[]{"com/xunlei/niux/data/pay/xml/jdbc.xml","com/xunlei/niux/data/pay/xml/applicationContext.xml"}).getBean("PayFacade");
		}else{
			INSTANCE=(IFacade)new ClassPathXmlApplicationContext(new String[]{"com/xunlei/niux/data/pay/xml/springjndi.xml","com/xunlei/niux/data/pay/xml/applicationContext.xml"}).getBean("PayFacade");
		}
	}
	private static String getJndiType(){
		try{
			String type=ResourceBundle.getBundle("jnditype").getString("xlniuxdata_pay_jndi_type");
			if(type==null){
				return "";
			}
			return type.trim().toLowerCase();
		}catch(Exception e){
			return "";
		}
	}
}
