package com.xunlei.niux.data.auditplatform.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

import com.xunlei.common.util.StringTools;

public class DateUtil {

	private static final SimpleDateFormat sdf = new SimpleDateFormat(
			"yyyy-MM-dd HH:mm:ss");
	private static final SimpleDateFormat Daysdf = new SimpleDateFormat(
			"yyyy-MM-dd");	
	private static final SimpleDateFormat OrderDaysdf = new SimpleDateFormat(
			"yyyyMMddHHmmss");
	
	
	public static String getOrderTime(){
		return OrderDaysdf.format(new Date());
	}
	
	/**
	 * 获得当前日期
	 * @return
	 * @throws java.text.ParseException
	 */
	public static String getNowDay()
			throws ParseException {
		Calendar cal = Calendar.getInstance();		
		return Daysdf.format(cal.getTime());
	}
	
	public static String getNowTime()
			throws ParseException {
		Calendar cal = Calendar.getInstance();		
		return sdf.format(cal.getTime());
	}
	
	/**
	 * 获得当前日期之前或之后numValue天的日期
	 * @param daytime
	 * @param numValue
	 * @param flag
	 * @return
	 * @throws java.text.ParseException
	 */
	public static String getNewDay(String daytime, int numValue,boolean flag)
			throws ParseException {
		Date date = Daysdf.parse(daytime);
		Calendar cal = Calendar.getInstance();
		cal.setTime(date);
		cal.add(Calendar.DAY_OF_YEAR, flag?numValue:-numValue);
		return Daysdf.format(cal.getTime());
	}
	
	
	public static String getYesterayDay()
			throws ParseException {
		Calendar cal = Calendar.getInstance();
		cal.add(Calendar.DAY_OF_YEAR, -1);
		return Daysdf.format(cal.getTime());
	}
	
	/**
	 * 判断time1是否大于等于time2
	 * 
	 * @param time1
	 * @param time2
	 * @return
	 * @throws java.text.ParseException
	 */
	public static long compareTime(String time1, String time2) throws Exception {
		if (StringTools.isEmpty(time1))
			return -1;
		Date date1 = Daysdf.parse(time1);
		Date date2 = Daysdf.parse(time2);
		long data1 = date1.getTime();
		long data2 = date2.getTime();
		return (data1 - data2) / 1000;
	}
}
