/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.data.auditplatform.util;

import java.lang.reflect.Field;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.springframework.jdbc.core.RowMapper;

public class ObjectMapper
implements RowMapper {
    private Class clazz;
    private boolean isNative;
    private boolean needFather;

    public ObjectMapper(Class clazz, boolean isNative, boolean needFather) {
        this.clazz = clazz;
        this.isNative = isNative;
        this.needFather = needFather;
    }

    public ObjectMapper(Class clazz, boolean needFather) {
        this.clazz = clazz;
        this.isNative = false;
        this.needFather = needFather;
    }

    public ObjectMapper(Class clazz) {
        this.clazz = clazz;
        this.isNative = false;
        this.needFather = false;
    }

    public Object mapRow(ResultSet rs, int rowNum) throws SQLException {
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            ResultSetMetaData md = rs.getMetaData();
            for (int i = 0; i < md.getColumnCount(); ++i) {
                String columnName = md.getColumnLabel(i + 1);
                if (columnName == null) {
                    columnName = "";
                }
                if (columnName.contains("_")) {
                    columnName = columnName.replace("_", "");
                }
                map.put(columnName.toLowerCase(), columnName);
            }
            Object obj = this.clazz.newInstance();
            Field[] fieldsss = obj.getClass().getDeclaredFields();
            ArrayList<Field> fields = new ArrayList<Field>();
            fields.addAll(Arrays.asList(fieldsss));
            if (this.needFather) {
                Field[] fieldss = obj.getClass().getSuperclass().getDeclaredFields();
                fields.addAll(Arrays.asList(fieldss));
            }
            for (int i = 0; i < fields.size(); ++i) {
                Field field = (Field)fields.get(i);
                if (field.getName().equals("serialVersionUID") || map.get(field.getName().toLowerCase()) == null) continue;
                field.setAccessible(true);
                String fieldName = null;
                fieldName = this.isNative ? this.getNativeName(field.getName()) : field.getName();
                this.typeMapper(field, obj, rs, fieldName);
                field.setAccessible(false);
            }
            return obj;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private String getNativeName(String fieldName) {
        char[] names = fieldName.toCharArray();
        int index = 0;
        String result = "";
        for (char name : names) {
            if (Character.isUpperCase(name)) {
                result = result + '_';
                result = result + Character.toLowerCase(name);
            } else {
                result = result + name;
            }
            ++index;
        }
        return result;
    }

    private void typeMapper(Field field, Object obj, ResultSet rs, String fieldName) throws Exception {
        String type = field.getType().getName();
        if (type.equals("java.lang.String")) {
            field.set(obj, rs.getString(fieldName));
        } else if (type.equals("int")) {
            field.set(obj, rs.getInt(fieldName));
        } else if (type.equals("java.lang.Integer")) {
            if (rs.getString(fieldName) == null || "".equals(rs.getString(fieldName))) {
                field.set(obj, null);
            } else {
                field.set(obj, rs.getInt(fieldName));
            }
        } else if (type.equals("long")) {
            field.set(obj, rs.getLong(fieldName));
        } else if (type.equals("java.lang.Long")) {
            if (rs.getString(fieldName) == null || "".equals(rs.getString(fieldName))) {
                field.set(obj, null);
            } else {
                field.set(obj, rs.getLong(fieldName));
            }
        } else if (type.equals("boolean") || type.equals("java.lang.Boolean")) {
            field.set(obj, rs.getBoolean(fieldName));
        } else if (type.equals("java.util.Date")) {
            field.set(obj, rs.getTimestamp(fieldName));
        } else if (type.equals("double") || type.equals("java.lang.Double")) {
            field.set(obj, rs.getDouble(fieldName));
        } else if (type.equals("float") || type.equals("java.lang.Float")) {
            field.set(obj, Float.valueOf(rs.getFloat(fieldName)));
        } else if (type.equals("java.sql.Timestamp")) {
            field.set(obj, rs.getTimestamp(fieldName));
        }
    }
}

