package com.xunlei.niux.data.auditplatform.vo;

import com.ferret.common.dao.annotation.Table;

@Table(tableName = "contract", pkFieldAssign = false, pkFieldName = "seqId")
public class Contract {
    //未审核
    public static final int CONTRACT_STATUS_NO_AUDIT=0;
    //审核中
    public static final int CONTRACT_STATUS_AUDIT_ING=1;
    //已经签订
    public static final int CONTRACT_STATUS_AUDIT_SUCCESS=2;
    //驳回
    public static final int CONTRACT_STATUS_AUDIT_FAIL=3;

    //空  没有上传合同
    public static final int CONTRACT_TYPE_NO_ONE=0;
    //非标准合同（标准合同部分修改）
    public static final int CONTRACT_TYPE_NORMAL_EDITED=1;
    //标准合同
    public static final int CONTRACT_TYPE_NORMAL=2;
    //非标准合同（对方版本）
    public static final int CONTRACT_TYPE_NO_NORMAL=3;

    private Long seqId;
    private Long userId;
    private Long auditId;
    private Integer type;
    private Integer status;
    private String docPath;
    private String inputTime;
    private String editTime;
    private String auditTime;
    private String auditBy;
    private String remark;

    public Long getSeqId() {
        return seqId;
    }

    public void setSeqId(Long seqId) {
        this.seqId = seqId;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public Long getAuditId() {
        return auditId;
    }

    public void setAuditId(Long auditId) {
        this.auditId = auditId;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getInputTime() {
        return inputTime;
    }

    public void setInputTime(String inputTime) {
        this.inputTime = inputTime;
    }

    public String getAuditTime() {
        return auditTime;
    }

    public void setAuditTime(String auditTime) {
        this.auditTime = auditTime;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getDocPath() {
        return docPath;
    }

    public void setDocPath(String docPath) {
        this.docPath = docPath;
    }

    public String getEditTime() {
        return editTime;
    }

    public void setEditTime(String editTime) {
        this.editTime = editTime;
    }

    public String getAuditBy() {
        return auditBy;
    }

    public void setAuditBy(String auditBy) {
        this.auditBy = auditBy;
    }
}
