package com.xunlei.niux.data.auditplatform.facade;

import java.util.ResourceBundle;

import org.springframework.context.support.ClassPathXmlApplicationContext;

public class FacadeFactory {
	public static final IFacade INSTANCE;
	static{
		String jndi=getJndiType();
		if("tomcat".equals(jndi)){
			INSTANCE=(IFacade)new ClassPathXmlApplicationContext(new String[]{"com/xunlei/niux/data/auditplatform/xml/tomcatjndi.xml","com/xunlei/niux/data/auditplatform/xml/applicationContext.xml"}).getBean("facade");
		}else if("jdbc".equals(jndi)){
			INSTANCE=(IFacade)new ClassPathXmlApplicationContext(new String[]{"com/xunlei/niux/data/auditplatform/xml/jdbc.xml","com/xunlei/niux/data/auditplatform/xml/applicationContext.xml"}).getBean("facade");
		}else{
			INSTANCE=(IFacade)new ClassPathXmlApplicationContext(new String[]{"com/xunlei/niux/data/auditplatform/xml/springjndi.xml","com/xunlei/niux/data/auditplatform/xml/applicationContext.xml"}).getBean("facade");
		}
	}
	private static String getJndiType(){
		try{
			String type=ResourceBundle.getBundle("jnditype").getString("xlniuxdata_auditplatform_jndi_type");
			if(type==null){
				return "";
			}
			return type.trim().toLowerCase();
		}catch(Exception e){
			return "";
		}
	}
}
