package com.xunlei.niux.data.auditplatform.dao;

import com.ferret.common.dao.BaseDaoImpl;
import com.xunlei.niux.data.auditplatform.dto.ContractDto;
import com.xunlei.niux.data.auditplatform.util.ObjectMapper;
import org.apache.commons.lang.StringUtils;


import java.util.ArrayList;
import java.util.List;

/**
 * Created by Dean on 2016/8/29.
 */
public class ContractDaoImpl  extends BaseDaoImpl implements IContractDao{


    public List<ContractDto> getContracts(long userId){
        StringBuffer sql=new StringBuffer();
        sql.append(" SELECT a.seqId,a.gameFullName gameName,c.inputTime,IFNULL(c.`status`,0) status,IFNULL(c.type,0) type from  auditmobilegameinfo a ");
        sql.append(" left JOIN (SELECT * from contract c1 where not EXISTS (SELECT null from contract c2 where c1.auditId=c2.auditId and c1.seqId<c2.seqId )) " );
        sql.append(" c on a.seqId=c.auditId ");
        sql.append(" where a.userId="+userId);
        return getJdbcTemplate().query(sql.toString(),new ObjectMapper(ContractDto.class));
    }

    public int countAllContracts(String gameName,String companyName,int type,int status,String startDate,String endDate,int pageNo,int pageSize){
        StringBuffer sql=new StringBuffer();
        List<Object> args=new ArrayList<Object>();
        sql.append(" SELECT count(1) from contract t ");
        sql.append(" LEFT JOIN auditmobilegameinfo a on t.auditId=a.seqId  WHERE 1=1 ");
        if(type>=0){
            sql.append(" and t.type=? ");
            args.add(type);
        }
        if(status>=0){
            sql.append(" and t.`status`=? ");
            args.add(status);
        }
        if(StringUtils.isNotEmpty(gameName)){
            sql.append(" and a.gameFullName like '?'");
            args.add("%"+gameName+"%");
        }
        if(StringUtils.isNotEmpty(companyName)){
            sql.append(" and a.companyName like '?'");
            args.add("%"+companyName+"%");
        }
        if(StringUtils.isNotEmpty(startDate)){
            sql.append(" and t.inputTime> ?");
            args.add(startDate);
        }
        if(StringUtils.isNotEmpty(endDate)){
            sql.append(" and t.inputTime< ?");
            args.add(endDate);
        }
        sql.append(" ORDER BY t.inputTime DESC");
        if(pageNo>0&&pageSize>0){
            int pageStart=(pageNo-1)*pageSize;
            sql.append(" LIMIT "+pageStart+","+pageSize);
        }
        return getJdbcTemplate().queryForInt(sql.toString(),args.toArray());
    }

    public List<ContractDto> getAllContracts(String gameName,String companyName,int type,int status,String startDate,String endDate,int pageNo,int pageSize){
        StringBuffer sql=new StringBuffer();
        List<Object> args=new ArrayList<Object>();
        sql.append(" SELECT t.seqId,a.gameFullName gameName,a.companyName,t.inputTime,t.`status`,t.type,t.remark,t.docPath from contract t ");
        sql.append(" LEFT JOIN auditmobilegameinfo a on t.auditId=a.seqId  WHERE 1=1 ");
        if(type>=0){
            sql.append(" and t.type=? ");
            args.add(type);
        }
        if(status>=0){
            sql.append(" and t.`status`=? ");
            args.add(status);
        }
        if(StringUtils.isNotEmpty(gameName)){
            sql.append(" and a.gameFullName like '?'");
            args.add("%"+gameName+"%");
        }
        if(StringUtils.isNotEmpty(companyName)){
            sql.append(" and a.companyName like '?'");
            args.add("%"+companyName+"%");
        }
        if(StringUtils.isNotEmpty(startDate)){
            sql.append(" and t.inputTime> ?");
            args.add(startDate);
        }
        if(StringUtils.isNotEmpty(endDate)){
            sql.append(" and t.inputTime< ?");
            args.add(endDate);
        }
        sql.append(" ORDER BY t.inputTime DESC");
        if(pageNo>0&&pageSize>0){
            int pageStart=(pageNo-1)*pageSize;
            sql.append(" LIMIT "+pageStart+","+pageSize);
        }
        return getJdbcTemplate().query(sql.toString(),args.toArray(),new ObjectMapper(ContractDto.class));
    }


}
