/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.data.auditplatform.util;

import com.xunlei.common.util.StringTools;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateUtil {
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final SimpleDateFormat Daysdf = new SimpleDateFormat("yyyy-MM-dd");
    private static final SimpleDateFormat OrderDaysdf = new SimpleDateFormat("yyyyMMddHHmmss");

    public static String getOrderTime() {
        return OrderDaysdf.format(new Date());
    }

    public static String getNowDay() throws ParseException {
        Calendar cal = Calendar.getInstance();
        return Daysdf.format(cal.getTime());
    }

    public static String getNowTime() throws ParseException {
        Calendar cal = Calendar.getInstance();
        return sdf.format(cal.getTime());
    }

    public static String getNewDay(String daytime, int numValue, boolean flag) throws ParseException {
        Date date = Daysdf.parse(daytime);
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(6, flag ? numValue : -numValue);
        return Daysdf.format(cal.getTime());
    }

    public static String getYesterayDay() throws ParseException {
        Calendar cal = Calendar.getInstance();
        cal.add(6, -1);
        return Daysdf.format(cal.getTime());
    }

    public static long compareTime(String time1, String time2) throws Exception {
        if (StringTools.isEmpty((String)time1)) {
            return -1L;
        }
        Date date1 = Daysdf.parse(time1);
        Date date2 = Daysdf.parse(time2);
        long data1 = date1.getTime();
        long data2 = date2.getTime();
        return (data1 - data2) / 1000L;
    }
}

